% test priors
close all;
 
set_paramest;

x0 = [ 0.01
    6.799
    0.1723
    0.82
    0.84938
    -2.3469
   -0.7709
   -1.05
   -2.9868
   -3.8367
   -2.6117
   -3.0250
    ];

x = x0;

Define_priors;

Define_Model_estimation

Estimated_parameters;

params = param;

for j = 1:size(params.estimated,1)

    figure(j);
    param = char(params.estimated(j,:));
    title(param);
    if eval(['priors.',param,'.trans']),
        Xdrawsj = exp(X_draws(j,burnin:end));
    else,
        Xdrawsj = X_draws(j,burnin:end);
    end;
    subplot(2,1,1)
    [a,b] = hist(Xdrawsj,100);
    bar(b,a/sum(a));
    hold on;
    h = get(gca);
    x = h.XLim(1):(h.XLim(2)-h.XLim(1))/99:h.XLim(2);
            
%     if strfind(eval(['priors.',param,'.dist']),'norm'), x = -10:.01:10; 
%     elseif strfind(eval(['priors.',param,'.dist']),'beta'), x = 0:.01:1;
%     elseif strfind(eval(['priors.',param,'.dist']),'gam'), x = 0:.01:10; 
%     end;

    subplot(2,1,2)
    for i = 1:length(x),
        pdf(i) = eval([eval(['priors.',param,'.dist']),'(',num2str(x(i)),',',num2str(eval(['priors.',param,'.m1'])),',',num2str(eval(['priors.',param,'.m2'])),')']);
    end;    
    plot(x,pdf,'r')    
    hold off;
    
    clear pdf

end;




