
function [vrbs_obs, Y_obs, Y_data,Y_data_ini, sample_size,traning_sample,Estsamplest,Estsamplend]  = set_YdataCPIfun 



%% Prepare data


pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Data'];
if isunix, pathslash = '/'; else pathslash = '\'; end

load([datapath, pathslash, 'CPIdataM']);


% VarList
vrbs_obs.infl = 1;
vrbs_obs.infl1Q_spf = 2;
vrbs_obs.infl2Q_spf = 3;
vrbs_obs.infl12Q_liv = 4;
vrbs_obs.infl12Q_livtrue = 5;

vrbs_obs.infl3Q_spf = 6;
vrbs_obs.infl4Q_spf = 7;
vrbs_obs.infl2Y_bcff = 8;
vrbs_obs.infl510Y_bcff = 9;



vrbs_obs.n_obsvables = 9;


fullsamplest = Obs_start;
fullsamplend = Obs_end;



fullsample = fullsamplest:1/4:fullsamplend;

Y_obs = NaN(vrbs_obs.n_obsvables,length(fullsample));


Y_obs(vrbs_obs.infl:vrbs_obs.infl12Q_livtrue,:) = Obs(:,vrbs_obs.infl:vrbs_obs.infl12Q_livtrue)';

% add long term survey (need extended data)



% Set sample period

Estsamplest = 1955; traning_sample = 16;

Estsamplend = 2015.25;


Estsample = find(fullsample >= Estsamplest & fullsample <= Estsamplend);
 
Y_obs = Y_obs(:,Estsample);




% Select observables used in the estimation: Baseline is only Q1,Q2
% forecasts

Y_data = Y_obs;



% Y_data(vrbs_obs.infl3Q_spf:vrbs_obs.infl510Y_bcei(end),:) = ...
%     NaN(size(Y_obs(vrbs_obs.infl3Q_spf:vrbs_obs.infl510Y_bcei(end),:)));


% Setting number of observation shocks

vrbs_obs.nobs_shocks = 5;




%% Re-set sample size and determine initial conditions

lags_ini = 3; % lags for initial conditions


% Set initial conditions

Y_data_ini = Y_data(:,1:lags_ini);

Y_data = Y_data(:,lags_ini+1:end);

Y_obs = Y_obs(:,lags_ini+1:end);

sample_size = size(Y_data,2);


% end

% keyboard


