

function [F,Q,Sc] = State_SpaceB(vrbs,param,MShok,VCV_eps)            


F = zeros(vrbs.n_var_ss);


F(vrbs.infl,[vrbs.infl;vrbs.phi]) = ...
    param.OMEGA_c(vrbs.infl,[vrbs.infl vrbs.phi]);

F(vrbs.infl,vrbs.pibar) = (1-param.gammap)*param.Tpi;


F(vrbs.phi,vrbs.phi) = param.OMEGA_c(vrbs.phi,vrbs.phi);


F(vrbs.pibar,vrbs.pibar) = 1;


F(vrbs.fe,vrbs.pibar) = (1-param.gammap)*(param.Tpi-1);



Sc = zeros(vrbs.n_var_ss,vrbs.n_shocks + vrbs.n_obs_shocks); 


Sc(vrbs.infl,MShok.n_phi) = 1;

Sc(vrbs.infl,MShok.n_muT) = 1;


Sc(vrbs.phi,MShok.n_phi) = 1;


Sc(vrbs.fe,MShok.n_phi) = 1;

Sc(vrbs.fe,MShok.n_muT) = 1;


Sc(vrbs.muT,MShok.n_muT) = 1;

Sc(vrbs.phiT,MShok.n_phi) = 1;


% Observation shocks
Sc(end-vrbs.n_obs_shocks+1:end,end-vrbs.n_obs_shocks+1:end) = eye(vrbs.n_obs_shocks);



% Variance covariance matrix Q

    Q = Sc*VCV_eps*Sc';
   
   