
function [paramest, x0] = SetParamest_fun(Model)



% Choose Model: 1. Baseline; 2. Gauss (2014); 3. Kostyshyna (2012) [Kushner and Yin 1995]

paramest.Model = Model;


% Set parameters to estimate


x0_ini = [];


% Long-term mean

paramest.pibar = 1; x0_ini(paramest.pibar) = 2.5/4;

count_mean = 1;


% Learning alghoritm

paramest.nu = count_mean + 1; x0_ini(paramest.nu) = .075;


if Model == 1
    
paramest.g = count_mean + 2; x0_ini(paramest.g) = 5.6;

count_learn = count_mean + 2;

end


if Model == 2
   
paramest.iota = count_mean + 2; x0_ini(paramest.iota) = 1;

paramest.gplus = count_mean +3; x0_ini(paramest.gplus) = 0.2;
    
count_learn = count_mean + 3;    
    
end


% initial gain

if Model == 3
    
paramest.ini_g = count_mean + 2; x0_ini(paramest.ini_g) = 1/9;

paramest.ini_Vk = count_mean + 3; x0_ini(paramest.ini_Vk) = 0;

count_learn = count_mean + 3;

end
    



% Inflation
 
paramest.gammap = count_learn+1; x0_ini(paramest.gammap) = .25; 

paramest.Tpi = count_learn+2; x0_ini(paramest.Tpi) = .25; 

  

count_Phillips = count_learn+2;


% Reduced-form model for mc

paramest.rho_phi = count_Phillips+1; x0_ini(paramest.rho_phi) = 0.75;

count_rf = count_Phillips+1;


% structural shocks

paramest.n_phi = count_rf+1; x0_ini(paramest.n_phi) = -0.9;

paramest.n_muT = count_rf+2; x0_ini(paramest.n_muT) = -0.9;


count_strinn = count_rf+2;


% observation shocks

paramest.oe1B = count_strinn+1; x0_ini(paramest.oe1B) = -2.2;

paramest.oe2B = count_strinn+2; x0_ini(paramest.oe2B) = -2.2;

paramest.oe3B = count_strinn+3; x0_ini(paramest.oe3B) = -2.2;

paramest.oe4B = count_strinn+4; x0_ini(paramest.oe4B) = -2.2;

paramest.oe5B = count_strinn+5; x0_ini(paramest.oe5B) = -2.2;


paramest.n_estimated_parameters = count_strinn+5;


x0_ini = x0_ini';

x0 = x0_ini;


% alternative initial conditions 

if Model == 1
    
% Baseline

x0 = [0.5050
    0.0172
    0.1338
    0.1270
    0.9586
    0.8934
   -2.4611
   -1.0030
   -1.1945
   -3.1673
   -3.9123
   -2.6304
   -3.0530];

  

elseif Model == 2
    
    x0 = [0.5050
    0.0172
    70
    0.13
    0.1270
    0.9586
    0.8934
   -2.4611
   -1.0030
   -1.1945
   -3.1673
   -3.9123
   -2.6304
   -3.0530];

elseif Model == 3;
    
  x0 = [0.5050
    0.0172
    0.1338
    0.01
    0.1270
    0.9586
    0.8934
   -2.4611
   -1.0030
   -1.1945
   -3.1673
   -3.9123
   -2.6304
   -3.0530];
  
end      
    











