

%%% Computes the particle Smoother given a set of parameters


%% [1] State space model in petit format

k_g = 1/param.ini_ginv;

% Variables:
infl = 1; pbar = 2; f = 3; s = 4;

% Model matrix entries (see notes)
Fsm = zeros(4+7,4+7); % adds all shocks 

Scsm = [1 1 
         0 0
         1 1
         1 0
         1 0
         0 1]; % includes the two structural shocks

     
Scsm = [Scsm zeros(6,5)];

Scsm = [Scsm;zeros(5,7)];

Scsm(end-4,end-4) = eye(5);


Fsm(infl,infl) = param.gammap;

Fsm(infl,pbar) = (1-param.gammap)*param.Tpi;

Fsm(infl,f) = (1-param.gammap)*param.Tpi*(1/k_g);

Fsm(infl,s) = param.rho_phi;


Fsm(pbar,pbar) = 1;

Fsm(pbar,f) = (1/k_g);


Fsm(f,f) = (1-param.gammap)*(param.Tpi-1)*(1/k_g);

Fsm(f,pbar) = (1-param.gammap)*(param.Tpi-1); 


Fsm(s,s) = param.rho_phi;
 

Qsm = Scsm'*param.VCV_eps*Scsm;


invQsm = Qsm\eye(size(Qsm));

% Agent's prediction model

OMsm = zeros(3);

% inflation
OMsm(1,1) = param.gammap;

OMsm(1,2) = 1 - param.gammap;

OMsm(1,3) = param.rho_phi;

% pibar

OMsm(2,2) = 1;

% s
OMsm(3,3) = param.rho_phi;



% Petit observation equation

musm = 4*param.pibar*ones(5,1); % constant, same size of observations

Hmsm = zeros(5, 11);


% Inflation
Hmsm(vrbs_obs.infl,infl) = 1; 


OMsm1 = OMsm(1,:);


Hm(vrbs_obs.infl1Q_spf,[infl, pbar, s]) = OMsm1;


OMsm2 = OMsm^2; OMsm2 = OMsm2(1,:);  


Hm(vrbs_obs.infl2Q_spf,[infl, pbar, s]) = OMsm2;

                                    
Hm(vrbs_obs.infl12Q_liv, [infl, pbar, s]) = (1/2).*(OMsm1 + OMsm2);

Hm(vrbs_obs.infl12Q_livtrue, [infl, pbar, s]) = (1/2).*(OMsm1 + OMsm2);


Hm([vrbs_obs.infl vrbs_obs.infl1Q_spf vrbs_obs.infl2Q_spf ...
    vrbs_obs.infl12Q_liv vrbs_obs.infl12Q_livtrue],end-4:end) = ...
    eye(5);


Hm(vrbs_obs.infl12Q_liv,end) = 1; % The long series of livingston forecasts has two observetion errors! 


H = 4*Hm'; % Hamilton notation


% Options
 
 Ns = 1000; % number of particles
 

%% [2] Prediction with Kalman filter and initial weights

% Shorten the detamat

Y_data_short = Y_dataB(1:5,:);


% Define matrices storing filtered states and variances

%  xi_tt_mat = zeros(size(Fsm,2),sample_size);
%  
%  Ptt_mat = zeros([size(Fsm),sample_size]);
%  
 
 xitt_draws = NaN(size(Fsm,2),Ns,sample_size);
 
 k_g_draws = NaN(Ns,sample_size);
 
 WW = NaN(Ns,sample_size);
 
 Lxitt_draws = NaN(Ns,1);


 
 % Initial conditions


 xi_0 = zeros(size(Fsm,2),1);
 
 P_0 = 1/10*eye(size(Fsm,2));
 
 
 
 
 for j = 1:sample_size

isobs = find(~isnan(Y_data_short(:,j)));     


% 1. Compute x_tt and P_tt 

% disp('kalman update')
% tic

[xi_tt,P_tt,eps,OM_inv,kb] = Kalman_updateNL1(xi_0,P_0,H,R,muc,isobs,Y_data_short(:,j));


% Draw state N times

% One way...
% [U,D,V] = svd(P_tt);
% 
% xi_tt_mat(:,j) = xi_tt + U*sqrt(D)*V'*randn(size(F,2),1);


xitt_draws(:,:,j) = mvnrnd(xi_tt,P_tt,Ns)';



% Compute determinant and inverse of Ptt [Do I need that?]

% invPtt = P_tt\eye(11); 
% 
% lndetPtt = log(det(P_tt));


% Compute weights (anyway to make this faster?)

for hj = 1:Ns

% Draws for the gain

 sw = (abs((1-param.gammap)*(param.Tpi-1)*xitt_draws(pbar,hj,j)) ...
      <= param.nu*param.STDfeM);
  

k_g_draws(hj,j) = (k_g + 1)*sw  + (1/param.g)*(1-sw);


% Lik of the draw

Lxitt_draws(hj) = -(1/2)*(xitt_draws(:,hj,j)-xi_tt)'*invPtt*(xitt_draws(:,hj,j)-xi_tt);


end % ends weights loop

% Assemble Lik

% Lxitt_draws = exp(Lxitt_draws - (1/2)*ones(Ns,1).*lndetPtt - (11/2)*log(2*pi));

Lxitt_draws = exp(Lxitt_draws);

WW(:,j) = Lxitt_draws./sum(Lxitt_draws);


% Update F matrix


    % Gain update
  
  sw = (abs((1-param.gammap)*(param.Tpi-1)*xi_tt(pbar)) ...
      <= param.nu*param.STDfeM);
  

   k_g = (k_g + 1)*sw  + (1/param.g)*(1-sw);

   

   % Update matrix
   

Fsm(infl,f) = (1-param.gammap)*param.Tpi*(1/k_g);

Fsm(pbar,f) = (1/k_g);

Fsm(f,f) = (1-param.gammap)*(param.Tpi-1)*(1/k_g);


% 3. Updating rules

xi_1 =Fsm*xi_tt;

P_1 = Fsm*P_tt*Fsm'+Q;


% Update params (probably not needed: change notation?)

xi_0 = xi_1; P_0 = P_1;
   

 end % sample loop



%% [4] Smoothing 


xiTT  = NaN(size(Fsm,2),sample_size);

k_g_TT = NaN(sample_size);


 % Draw last state
 
 sdraw = find(mnrnd(1,WW(:,end)) == 1);


 xiTT(:,end) = xitt_draws(:,sdraw,end);
 

 k_g_TT(end) = k_g_draws(sdraw,end);
 
 
% Algorithm 
 
for js = sample_size-1:-1:1
    
   
    for jns = 1:Ns
        
  % Compute p(xi'|xi(i))
    
    % Updated Fsm
    
    FsmS = Fsm;
    
    
   % Update matrix
   

    FsmS(infl,f) = (1-param.gammap)*param.Tpi*(1/k_g_draws(jns,js));

    FsmS(pbar,f) = (1/k_g_draws(jns,js));

    FsmS(f,f) = (1-param.gammap)*(param.Tpi-1)*(1/k_g_draws(jns,js));

    fmean = FsmS*xitt_draws(:,jns,js);
    
    
   % Lik 
    
    
  Lf_draws(jns) = exp(-(1/2)*(xiTT(:,js+1)-fmean)'*invQsm*(xiTT(:,js+1)-fmean));
  
  
    
    end % end Ns loop
    
    
    % computes weights
    
   WWf(:,js) = (WW(:,js).*Lf_draws)./sum(WW(:,js).*Lf_draws);
   
    
   % Draw last state
 
 sdraw = find(mnrnd(1,WWf(:,js)) == 1);
  
 
 xiTT(:,js) = xitt_draws(:,sdraw,js);
 
 k_g_TT(js) = k_g_draws(sdraw,js);
    
end % end smoother recursion   
    