

tic;

X_draws = X_draws(:,discard+1:end);

ndraws = size(X_draws,2);

drawsel = randperm(ndraws);

n_draws_swl = 1000;

x_draws_pred = NaN(size(X_draws,1),n_draws_swl);

xi_TT_mat = NaN(k,T,min(n_draws_swl,ndraws));

ypredB_mat = NaN(vrbs_obsB.n_obsvables,T,min(n_draws_swl,ndraws));

PredShocks = NaN(2,T,min(n_draws_swl,ndraws));

ypred_BNOobserrB = NaN(vrbs_obsB.n_obsvables,T,min(n_draws_swl,ndraws));

ypredB_fcsterrors =  NaN(T-1,min(n_draws_swl,ndraws));

constant_gain = NaN(T,min(n_draws_swl,ndraws));

draw_states = 1;



% Run Kalman filter given the initial distribution
for d = 1:min(n_draws_swl,ndraws),

    d
    draw = drawsel(d);
    
% Parameters  
    
    x = X_draws(:,draw);
    
    x_draws_pred(:,d) = x; % saves the parameters draw 

  paramB = EstparamB_fun(x,vrbsB,paramest,MShokB,SIM_regB);   
  
  
% State space

  VCV_eps = paramB.VCV_eps;
  
  [FB,QB,~] = State_SpaceB(vrbsB,paramB,MShokB,VCV_eps);

    
% Compute observation equation
 
  [HB,H_NOobserrB,mucB,RB,~] = H_CPI_fun(paramB,SIM_regB,vrbs_obsB,vrbsB);

 
% Initialization of Kalman filter
  
   [xi_0B,P_0B,kiniB] = KF_initializeB_fun(paramB,vrbsB,vrbs_obsB,Y_data_iniB,FB,QB);
 
 
     [LikB,xi_TT_out,Ftt_out,P_TT_out,~,~] = ...
   LikelihoodNL_preds(xi_0B,P_0B,HB,RB,mucB,FB,QB,Y_dataB,sample_sizeB,traning_sampleB,paramB,vrbsB,draw_states); 

 
    xi_TT_mat(:,:,d) = xi_TT_out;
    
    
   mucB_mat =  repmat(mucB,1,size(xi_TT_out,2));

   ypred_BNOobserrB(:,:,d) = mucB_mat + H_NOobserrB'*xi_TT_out;

   ypredB_mat(:,:,d) = mucB_mat + HB'*xi_TT_out;
   
  
   constant_gain(:,d) = Ftt_out(vrbsB.pibar,vrbsB.fe,:);
   
    % Forecast errors
    
    ypredB_fcsterrors(:,d) = ypred_BNOobserrB(vrbs_obsB.infl,2:end,d) - ...
                             ypred_BNOobserrB(vrbs_obsB.infl1Q_spf,1:end-1,d);
   
    
    % Filtered (une-sided) innovations (st, mut)
    
    
    PredShocks(:,:,d) = xi_TT_out([vrbsB.phiT,vrbsB.muT],:);
    

  
end
