
function [X_draws,Logpost_draws,acc_ratio] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    timestamp, MetropolisName,letssaveit)

 % Find the right path
if letssaveit
    
pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Results'];
if isunix, pathslash = '/'; else pathslash = '\'; end                
    
end


%% Metropolis



draw = 2;

count_accept = 0;

count_reject = 0;

 
 
    
   
   
 X_draws = xmode; clear xmode;
  
 logpost_olddraw = fvalmode; clear fvalmode;
 
 Logpost_draws = logpost_olddraw;

 
 
     
if  newmode == 1; 
 
 csquareini = 0;
 
end


 if isempty(provided_sigscale)

 sigscale = priors.sigscale;

 else
     
 sigscale = provided_sigscale;    
 
end   


npara = length(X_draws);


while draw < ndraws+1,    
    
    
    outside_bounds = 1;
      
       while outside_bounds,
        
      if draw == 2
      
         csquare1 = csquareini;  
      
      else
          
          csquare1 = csquare;
      end
      
          
      % New draw
 
          X_draws(:,draw) = X_draws(:,draw-1) + csquare1*(sigscale*randn(npara,1));



% Checks boundaries

 x = X_draws(:,draw);

 paramB = EstparamB_fun(x,vrbsB,paramest,MShokB,SIM_regB);   

   
 kiniB = param_const_fun(paramB);
 

 
  if kiniB == 1 
           
            outside_bounds = 1;      
  else
            
            outside_bounds = 0;
  end;

      end;
    
 
 % Compute Posterior
 
 % State space

  VCV_eps = paramB.VCV_eps;
  
  [FB,QB,~] = State_SpaceB(vrbsB,paramB,MShokB,VCV_eps);
  
  
 
  
  % Compute observation equation
 
  [HB,~,mucB,RB,~] = H_CPI_fun(paramB,SIM_regB,vrbs_obsB,vrbsB);

  

 
  % Initialization of Kalman filter
  
   [xi_0B,P_0B,kiniB] = KF_initializeB_fun(paramB,vrbsB,vrbs_obsB,Y_data_iniB,FB,QB);
   
  
   
   if kiniB == 1 
 
     logpost_newdraw = 100e20; 
     
   else
     
       
  LikB = LikelihoodNL(xi_0B,P_0B,HB,RB,mucB,FB,QB,Y_dataB,sample_sizeB,traning_sampleB,paramB,vrbsB);
  
  
 
  LogLIK = LikB;
     
      
  % Priors
  
  % logsumpriorsB = prior_eval(paramB,priors,Jtrans);
 logsumpriorsB = priorEval_fun(paramB,priors,Jtrans);
    
  logsumpriors = logsumpriorsB;
  
    
  logpost_newdraw =  LogLIK + logsumpriors;
    
       
       
   end
   
  
      Logpost_draws(draw) = logpost_newdraw;
    
   
    
    if newmode == 1 || csquareini ~= csquare
    
    if draw == 2
        
        logpost_olddraw = logpost_newdraw;
        Logpost_draws(draw-1) = logpost_newdraw;
        
    end
        
    end % new mode
    
    
   
    
    
      acc_prob = min(1,exp(logpost_newdraw-logpost_olddraw));
    
      accept = binornd(1,acc_prob); 
    
   
    
    if ~accept,
        
        draw = draw - 1;
        
        count_reject = count_reject + 1;
    
    else
        
        logpost_olddraw = logpost_newdraw;
        
        count_accept = count_accept + 1;
    end;
    
    draw = draw + 1;
    
    acc_ratio = count_accept/(count_accept + count_reject);
    
    
    
    
    if mod(draw,100) == 0,
    
        disp(draw);
        
        disp(acc_ratio);
    
    end;
    
    if mod(draw,25000) == 0 && letssaveit,
        
     save([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [timestamp, MetropolisName]]);
        
    end;
    
        
end; % while draw < ndraws,    

if letssaveit,
        
     save([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [timestamp, MetropolisName]]);
        
 end;

