

%% Run metropolis chain


% right path

pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Results'];
if isunix, pathslash = '/'; else pathslash = '\'; end

load([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [REStimedetails,MetropolisName,'Cov','LongChain']], 'X_draws', 'Logpost_draws','csquare');

 nxd = 3; discard = round(size(X_draws,2)/nxd);


% Compute Logpost and sigscale provided

X_drawsini = X_draws(:,discard+1:end);


% Select mode and sigscale                                        
[~, b] = max(Logpost_draws);
        
fvalmode = Logpost_draws(b);
    
xmode = X_draws(:,b);

provided_sigscale = real(sqrtm(cov(X_drawsini')));

MetropolisNameChain = [MetropolisName,'Chain',filetag];
    
ndraws = 150000; letssaveit = 1; 

newmode = 0;

csquareini = 3*csquare;


[X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisNameChain,letssaveit); 

                
                