function [] = Main_Bayes_funv1(n_rounds,n_ests,Model,iter)

%clear all; %clc




% Data

% US Baseline

[vrbs_obsB, Y_obsB, Y_dataB,Y_data_iniB, sample_sizeB,traning_sampleB,EstsamplestB,EstsamplendB]  = set_YdataCPIfun;



% % Specs
%   
% n_rounds = 5;
% 
% n_ests = 1;
% 
% iter = 50;
% 
% 
%  % Model
%  
%  % Choose Model: 1. Baseline; 2. Gauss (2014); 3. Kostyshyna (2012) [Kushner and Yin 1995]
%  
% Model = 3;



% Saving the results

timestamp_raw = datestr(now);
 
timestamp = [timestamp_raw(1:11) '_' timestamp_raw(13:14), timestamp_raw(16:17)];



filetag = ['_', num2str(iter)]; 


name = '_CPI';

cmts = ['_Model',num2str(Model)]; 
 
EstimationName = ['ERes',name,cmts,filetag];

MetropolisName = ['Metro',name,cmts];

MetropolisNameChain = ['Metro',cmts,filetag];

REStimedetails = timestamp(1:16); % if you the whole package at once 

REStimedetails = '08-Jan-2016_1801'; % Date of modal estimate. To be used for producing the full estimation package 



% Options 
 
test_priors = 0;


find_mode = 1;


% HessianLoop (this also computes the mode parameters)

% timestamp: to load estimation results. Only type the date
                                     % at the beginning of the filename
 % NOTE: check that 'n_mats' is set to correspond to the number of saved
                                     % estimation results matrices
n_mats = [];  

if iter == n_mats
                                     
HessianLoop = 1;  

else
    
HessianLoop = 0;

end

run_Metropolis = 0; % to run Metropolis, make sure 'REStimedetails' is defined

multiple_chains = 0; % requires initial draws from run_Metroposis


Assemble_Chains = 0;

Print_Posteriors = 0;


% Saved draws you wanna plot
 
 % If you have not run multiple chains....
 Saved_Metropolis = [REStimedetails,MetropolisName,'Cov','LongChain'];

 
 % Set name of the booklet containtg the figures:

 Postfigname = [REStimedetails,'PosteriorFigs',cmts];

 print_indiv = 0; % set ==1 to save individual figs 


Predictions = 0;

simulate = 0; % Require Predictions == 1

Smooth = 0; % Require Predictions == 1



makeplots = 0;




% Initialize random number for this session

s = RandStream('mt19937ar','Seed','shuffle');
          RandStream.setGlobalStream(s);


% parameters to be estimated and initial conditions

 
[paramest, x0] = SetParamest_fun(Model);    
 
 
  % Define model vars and priors

 priors = DefinePriors_fun(paramest.Model);

 
 if test_priors == 1;
     
 plot_priors(priors);

 end
  

 
% Define_Model_estimation

 [vrbsB, MShokB,SIM_regB] = Define_Model_CPIfun(vrbs_obsB.nobs_shocks);

 
  

 
 if find_mode == 1
     
     Jtrans = 0;
     
     Find_mode
  
 end
 

 
if HessianLoop == 1
    
    
    RunLoop
    
    
    sigscaleHess

    
    
end


if run_Metropolis == 1

    
%  setup


Jtrans = 1;


MainMetropolis



end



if multiple_chains
    
    

    try
    
Jtrans = 1;
        
Metropolis_chain 
    
    catch ME
        
     disp('no initial draws found to compute the chain')
      
    end  

end  




if Assemble_Chains == 1
    
    % NOTE: there will always be five chains
    
    
    flnme = [REStimedetails,MetropolisName,'Chain','_'];
   

    try
    
    [All_chains, All_Logpost_chains,psRhat] = ConvergenceTestv2(flnme);

    
    catch ME
        
        disp('no files available for assembling chains!')
        
        
    end  
    
pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Results'];
if isunix, pathslash = '/'; else pathslash = '\'; end  

save([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [REStimedetails,'MetroAllchains',name,'us',cmts]], 'psRhat', 'All_chains','All_Logpost_chains');
    
end


if Print_Posteriors %|| Predictions
    
  % close all;
   
pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Results'];
if isunix, pathslash = '/'; else pathslash = '\'; end  


try
    
     All_draws = All_chains; All_Logpost_draws = All_Logpost_chains;
     
     
catch ME
    
    try 
    
    load([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [REStimedetails,'MetroAllchains',name,'us',cmts]], 'All_chains','All_Logpost_chains');
    
     All_draws = All_chains; All_Logpost_draws = All_Logpost_chains;
    
     
     catch ME
         
load([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    Saved_Metropolis], 'X_draws','Logpost_draws');

   All_draws = X_draws'; All_Logpost_draws = Logpost_draws;
   
   
     end
   
     
end

end

if Print_Posteriors
    
% Path to save figures

figpath = [datapath, pathslash,...
    'Figures',pathslash,'FiguresPosteriors',pathslash];




for j = 1:size(priors.estimated,1)


    parameter = char(priors.estimated(j,:));
    
    fg = figure('visible','off');
    
    if eval(['priors.',parameter,'.trans']) == 1
        
    [a b] = hist(exp(All_draws(:,eval(['paramest.',parameter]))),100);    
        
    else
    
    [a b] = hist(All_draws(:,eval(['paramest.',parameter])),100);
    
    end
    
     bar(b,a/sum(a));
    
     hold on
    
    for i = 1:length(b),
        pdf(i) = eval([eval(['priors.',parameter,'.dist']),'(',num2str(b(i)),',',num2str(eval(['priors.',parameter,'.m1'])),',',num2str(eval(['priors.',parameter,'.m2'])),')']);
    end;
    
    plot(b,pdf/sum(pdf),'r--')
    
    title(parameter);
    
    ng = (parameter); 
    
   
    if print_indiv == 1
    
    namesinglefig_eps = [REStimedetails([1:2 4:6 8:11]),cmts,char(strcat(ng,'.eps'))];
    
    namesinglefig_pdf = [REStimedetails([1:2 4:6 8:11]),cmts,char(strcat(ng,'.pdf'))];
    
    
    print(gcf, '-dpsc', '-r300', [figpath,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [figpath,'\',namesinglefig_pdf]);
    
   % print(char(strcat(ng,'.eps')),'-depsc2');   print(char(strcat(ng,'.pdf')),'-dpdf');   % 

    end
    
    
    
    if j == 1
        
     print(gcf, '-dpsc', '-r300', [figpath,'\',Postfigname,'.ps'])
    
    else
        
     print(gcf, '-dpsc', '-r300','-append', [figpath,'\',Postfigname,'.ps'])
      
    end   
     
    clear pdf

end;

   CreateTable(All_draws',All_Logpost_draws,priors); 
   
end



%% Predictions

if Predictions == 1
    

%Modal filtered series
% X_draws = All_draws';
% 
% 
% % Discard initial sample:     
%  nxd = 10000; discard = round(size(X_draws,2)/nxd);
% 
% 
% 
% %Select mode                                         
% [~, b] = max(All_Logpost_draws);
%         
% fvalmode = All_Logpost_draws(b);

%xmode = X_draws(:,b);

% Model 2
xmode = [0.5951
    0.0117
   60.6537
    0.3858
    0.1281
    0.9891
    0.8247
   -2.4774
   -1.0494
   -1.2117
   -3.1545
   -3.8249
   -2.6474
   -3.0405];

% Model 3

xmode = [0.5246
    0.0006
    0.0644
    0.1330
    0.9461
    0.8938
   -2.4356
   -0.9827
   -1.3534
   -3.1919
   -3.8890
   -2.6387
   -3.0213];



%% Compute filtered series under modal distribution

 
 Mode_pred;

return
if Smooth
    
    Main_Smooth

    return
    
end    


  
    
[k, T] = size(xi_TT_out);
    

%% Compute full distribution (marginal)

  
ParamPost_preds;





 %% Save
  
Predpath = [datapath, pathslash,...
    'EstimationResults',pathslash,'Predictions',pathslash];

    

try
 save([Predpath,...
     [REStimedetails,'PredsAllchains',cmts]], 'xi_TT_mat', 'ypred_BNOobserrB','ypredB_mat','constant_gain',...
                                              'ypred_BNOobserrBmode','ypredBmode','gain_mode','pistar_mode','ypredB_fcsterrors','PredShocks','x_draws_pred');

catch ME
    
    disp('could not save properly')

end


  

end



if makeplots == 1
    
%% load

pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Results'];
if isunix, pathslash = '/'; else pathslash = '\'; end  


Predpath = [datapath, pathslash,...
    'EstimationResults',pathslash,'Predictions',pathslash];
     

FigPredpath = [datapath, pathslash,... 
    'Figures',pathslash,'FiguresPredictions',pathslash]; 


% Load Predictions

try
 load([Predpath,...
     [REStimedetails,'PredsAllchains',cmts]], 'xi_TT_mat', 'ypred_BNOobserrB','ypredB_mat','ypredBmode','constant_gain','ypredB_fcsterrors','PredShocks');

catch ME
    
    disp('could not load properly')

end



 close all     
 
 MakePlots
 
 
end
    
 

    
    

%% OLDER

% % plots
% 
% if makeplots == 1
%    
%  figure;
%    sample_plot = 1955+0.25*size(Y_data_iniB,2):1/4:2014.75;
% 
%  plot(sample_plot,ypredB_mode(1,:),'k--','Color',[0.494117647409439 0.494117647409439 0.494117647409439])
% 
%  hold on;
%    plot(sample_plot,Y_obsB(vrbs_obsB.infl1Q_spf,:)','b-','LineWidth',2)
%     plot(sample_plot,Y_obsB(vrbs_obsB.infl2Q_spf,:)','m-','LineWidth',2)
%      plot(sample_plot,Y_obsB(vrbs_obsB.infl12Q_liv,:)','bo')
%     plot(sample_plot,Y_obsB(vrbs_obsB.infl12Q_livtrue,:)','mo')
%   
%     
% 
%  hold off
%  xlim([1955.75,2015.25])
% ylim([-2.0;15])
% 
% ng = 'US_inflation0';  
%       print(char(strcat(ng,'.eps')),'-depsc2');   print(char(strcat(ng,'.pdf')),'-dpdf');
% Crappy_infl_pic
% 
% %Crappy_gain_pic
%     
% end

% ALTERNATIVE SIMLATIONS
% % %iniconds = [xi_TT_out([vrbsB.infl vrbsB.pibar vrbsB.fe vrbsB.phi],2); squeeze(Ftt_out(vrbsB.pibar,vrbsB.fe,1))]; % starts in period to (exl. initial conds)
% % iniconds = [xi_TT_out([vrbsB.infl ],2); ...
% %     xi_TT_out([vrbsB.pibar],2);...
% %       xi_TT_out([vrbsB.fe vrbsB.phi],2);... 
% %     squeeze(Ftt_out(vrbsB.pibar,vrbsB.fe,1))]; % starts in period to (exl. initial conds)
% 
% %ComputeShocks
% 




% "Filtered Shocks"
%Y_siml = Simulation(paramB,[eps_t(3:end);mu_t(3:end)],iniconds);

% Simulation
% iniconds = [0;.10;.2;0;0.05];
% eps_t = std(xi_TT_out([vrbsB.phiT],2:end))*randn(1,239);
% mu_t = std(xi_TT_out([vrbsB.muT],2:end))*randn(1,239);
% mut(1) =mu_t(1); for j=2:239; mut(j)=0.25*mut(j-1)+mu_t(j);end
% mu_t = mut;
% 
% Y_siml = Simulation(paramB,[eps_t(1:end);mu_t(1:end)],iniconds);

%    Y_mat(1:2,:) = 4*paramB.pibar + 4*Y_siml(1:2,:);
%    Y_mat(3:4,:) = 4*Y_siml(3:4,:);
%    Y_mat(5,:) = Y_siml(5,:);


