

%% PRODUCES FULL CYCLE OF METROPOLIS



%% Step 1: Use Hessian


pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Results'];
if isunix, pathslash = '/'; else pathslash = '\'; end

load([datapath,pathslash,...
    'EstimationResults',pathslash,'Mode',pathslash,...
    [REStimedetails,'Mode_','us']], 'xmode', 'fvalmode','sigscaleHess');
  
% Uncomment if the mu parameter in the calculations of the Hessian 
 % (Compute_Hessianinv.m) is fixed to the mean
 
std_nu = 0.04; % close to prior std

sigscaleHess(paramest.nu,paramest.nu) = std_nu;


newmode = 1;


% Fine-tune csquare

% Define parameters
csquare_ini = 0.50;
 csquare_ini2 = 0.70;
csquare_select = csquare_ini;
multfactor = 0.95; % goes down in steps of 0.03...
largepercfactor = 3*(1-0.95); % for very large misses in the acc_prob
distz = 1;
limcount = 50;
targetacc = 0.28; % target acceptance rate
toler = 0.04; % tolerance from target acceptance rate
toler0 = 0.13;  % switches the number of draws
toler2 = 0.09; % switches the number of draws
toler3 = 0.08; % for minor correction to csquare (see below)
tolerX = 0.14; % tolerane for big change in csquare
countft = 0;
didnotwork = 0; % flag after we evaluate minor correction (see below)
ndrawsexplore = 300; % initial number of iterations to rule out crazy accept.
ndrawsiter = 1500; % fine-tuning of the acceptance rate
ndrawsiter0 = 750; % fine-tuning of the acceptance rate
ndrawsinterm = 40000; %n. of draws for intermediate chain
ndrawsfinal = 80000; %n. of draws for final chain
ninter = 1; % number of intermediate iterations

% Start looping


csquare = csquare_ini/multfactor;
ndraws = ndrawsexplore;
letssaveit = 0;

 while countft < limcount && distz  > toler || ndraws ~= ndrawsiter;
            
            csquare = csquare * multfactor;
            
            
            disp(['current cquare =',num2str(csquare)]);
            %disp(csquare)
            
            %countft
                 
  
    [X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,sigscaleHess,xmode,fvalmode,...
                    csquare,[],ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisName,letssaveit);
             
                
                
         countft = countft+1;
         
       if abs(acc_prob-targetacc) < distz 
                distz  = abs(acc_prob-targetacc);
                csquare_select = csquare;
                acc_select = acc_prob;
       end
       
       if abs(acc_prob-targetacc) > tolerX
           
           csquare = csquare*(1 + sign((acc_prob-targetacc))*largepercfactor)/multfactor;
           
       end
       
       if abs(acc_prob-targetacc) < toler0
           
           ndraws = ndrawsiter0; 
           
       end
       
           
       if abs(acc_prob-targetacc) < toler2
           
           ndraws = ndrawsiter;
           
       end 
           
       
 end
 
 if countft == limcount
     
     disp('Could not find acc rate: I will stop here'); 
     MetropolisNameFail = 'FAILED';
     
      save([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [REStimedetails, MetropolisNameFail]],'acc_prob');
     
    return

 end
 
 
% Compute chain


ndraws = ndrawsinterm;
letssaveit = 1; MetropolisNameHess = [MetropolisName,'Hess'];



 [X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,sigscaleHess,xmode,fvalmode,...
                    csquare_select,[],ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisNameHess,letssaveit);
                
                
%% Step 2-3: Use VCV of the draws


newmode = 0;


for iterate = 1:ninter


nxd = 2; discard = round(size(X_drawsn,2)/nxd);


% Compute Logpost and sigscale provided

X_drawsini = X_drawsn(:,discard+1:end);


% Select mode and sigscale                                        
[~, b] = max(Logpost_drawsn);
        
fvalmode = Logpost_drawsn(b);
    
xmode = X_drawsn(:,b);

provided_sigscale = real(sqrtm(cov(X_drawsini')));



% Fine-tune csquare

 % Sub-Step 1: check acceptance rate under previous selected csquare
 
csquare = csquare_select;

csquareini = csquare; 

ndraws = ndrawsiter;

letssaveit = 0;


[X_drawsn,Logpost_drawsn,acc_probN] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisName,letssaveit);
                
                
 if abs(acc_probN-targetacc) < toler
     
     
  ndraws = ndrawsinterm;

  letssaveit = 1; MetropolisNameCov = [MetropolisName,'Cov',num2str(iterate)];
  
 

 [X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisNameCov,letssaveit);
                
                
 elseif abs(acc_probN-targetacc) <= toler3
     
   % Here we consider two sub-cases
   
     % Case 1: Small deviations from the acceptance rate obtainen with
     % Hessian
     
              
          csquare = csquare + sign(acc_probN-targetacc)*0.05; csquareini = csquare;
              
           ndraws = ndrawsiter; letssaveit = 0;
           
      
    
       [X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisName,letssaveit);         
                
                
                
           
         if abs(acc_prob-targetacc) < toler
             
             ndraws = ndrawsinterm; letssaveit = 1; 
             
             MetropolisNameCov = [MetropolisName,'Cov',num2str(iterate)];

          
               [X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisNameCov,letssaveit);       
                
         else
             
             didnotwork = 1;
           
         end
           
 end % ends if, elseif loop
         
 
   % Case 2: Large deviations from the acceptance rate obtained with
   %         Hessian. In this case we start again from the beginning
     
     
  if  abs(acc_probN-targetacc) > toler3 || didnotwork
     
     csquare_ini = csquare_ini2;
     
     ndraws = ndrawsexplore;
     
     csquare = csquare_ini/multfactor; csquareini = csquare;
     
     letssaveit = 0; countft = 0;
          
      
       while countft < limcount && distz  > toler || ndraws ~= ndrawsiter;
            
            csquare = csquare * multfactor; csquareini = csquare;
            
             disp(['current cquare =',num2str(csquare)]);
            
                 
 [X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisName,letssaveit); 
                
            
         countft = countft+1;
         
       if abs(acc_prob-targetacc) < distz 
                distz  = abs(acc_prob-targetacc);
                csquare_select = csquare;
                acc_select = acc_prob;
       end
       
        if abs(acc_prob-targetacc) > tolerX
           
           csquare = csquare*(1 + sign((acc_prob-targetacc))*largepercfactor)/multfactor;
           
       end
       
        if abs(acc_prob-targetacc) < toler0
           
           ndraws = ndrawsiter0;
           
       end
       
       
       if abs(acc_prob-targetacc) < toler2
           
           ndraws = ndrawsiter;
       end 
           
       
       end % while loop
 
 if countft == limcount
     
     disp('Could not find acc rate: I will stop here'); 
     MetropolisNameFail = 'FAILED';
     
      save([datapath,pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [REStimedetails, MetropolisNameFail]],'acc_prob');
     
    return
     
 end
     
                
 % Compute chain


ndraws = ndrawsinterm; letssaveit = 1; 
             
MetropolisNameCov = [MetropolisName,'Cov',num2str(iterate)];

csquare = csquare_select; csquareini = csquare;

[X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisNameCov,letssaveit); 
     
  end   % toler3 loop
 
 
  
     

end % ends iterations


  %% Step 4: final iteration
  
  
  
  nxd = 2; discard = round(size(X_drawsn,2)/nxd);


% Compute Logpost and sigscale provided

X_drawsini = X_drawsn(:,discard+1:end);


% Select mode and sigscale                                        
[~, b] = max(Logpost_drawsn);
        
fvalmode = Logpost_drawsn(b);
    
xmode = X_drawsn(:,b);

provided_sigscale = real(sqrtm(cov(X_drawsini')));

MetropolisNameCovL = [MetropolisName,'Cov','LongChain'];
  
  
  ndraws = ndrawsfinal; letssaveit = 1; 


[X_drawsn,Logpost_drawsn,acc_prob] = ...
                    Metropolis_fun(newmode,provided_sigscale,xmode,fvalmode,...
                    csquare,csquareini,ndraws,Jtrans,paramest,priors,...
                    vrbsB,  vrbs_obsB,  MShokB,  SIM_regB,  Y_dataB,  Y_data_iniB,  sample_sizeB,   traning_sampleB,...
                    REStimedetails, MetropolisNameCovL,letssaveit); 



