


%%%% CONSTRUCTS THE LIKELIHOOD

function [L_fun,xi_tt_mat,Ftt_mat,Ptt_mat,xi_tl_mat,Ptl_mat] = ...
   LikelihoodNL_preds(xi_0,P_0,H,R,muc,F,Q,Y_vec,sample_size,traning_sample,param,vrbs,draw_states) 
                         

  Ft = F; % note: Ft requires the time-varying coefficients on vrbs.fe (done below)
  
  k_p = 1/param.ini_g; % initial gain
  
  
  if param.Model == 3;
      
  Vk = param.ini_Vk; % K algorithm

  end

  
  
% Initial value of the Likelihood

L_fun = 0;

% Define matrices storing filtered states and variances
 xi_tt_mat = zeros(size(F,2),sample_size);
 Ftt_mat = zeros([size(F),sample_size]);
 Ptt_mat = zeros([size(F),sample_size]);
 xi_tl_mat = xi_tt_mat;
 Ptl_mat = Ptt_mat;
 
 
% Construct the Likelihood

for j = 1:sample_size

isobs = find(~isnan(Y_vec(:,j)));     




% 1. Compute x_tt and P_tt 

% disp('kalman update')
% tic

[xi_tt,P_tt,eps,OM_inv,kb] = Kalman_updateNL1(xi_0,P_0,H,R,muc,isobs,Y_vec(:,j));




if draw_states == 0
    
xi_tt_mat(:,j) = xi_tt;

else

[U,D,V] = svd(P_tt);

xi_tt_mat(:,j) = xi_tt + U*sqrt(D)*V'*randn(size(F,2),1);
    
end
    
Ptt_mat(:,:,j) = P_tt;



if kb == 1
     
  L_fun =  100e20; return

end



% toc

% 2. Compute gt+1 and updated Ft 


E_rr = abs((1-param.gammap)*(param.Tpi-1)*xi_tt(vrbs.pibar))/param.STDfeM;


if param.Model == 1
    
% Marcet and Nicolini (2003)

sw = (E_rr <= param.nu);
  

 k_p = (k_p + 1)*sw  + (1/param.g)*(1-sw);
 

end


if param.Model == 2
    
    
% % Gauss (2014)   
%    
% gG = param.gmns + param.nu*(param.iota*E_rr/(1+param.iota*E_rr)); 
%  
% sw = (gG < param.gplus);
%    
% k_p = (1/gG)*sw  + (1/param.gplus)*(1-sw);

% Flexible Marcet and Nicolini

gG = (exp(-(abs(E_rr)-(-(1-param.nu)))^-param.iota)/(1/param.gplus));

k_p = (1/gG);


end


if param.Model == 3

% Kostyshyna (2012) [Kushner and Yin 1995]


Vk = (1-1/k_p)*Vk + xi_tt(vrbs.fe);


gK = 1/k_p + param.nu*xi_tt(vrbs.fe)*Vk;

sw = (gK > param.gmns && gK < param.gplus);

swp = (gK > param.gplus);


k_p = (1/gK)*sw + ...
    (1-sw)*(swp*(1/param.gplus) + (1-swp)*(1/param.gmns)); 

end



Ft([vrbs.infl vrbs.pibar vrbs.fe],vrbs.fe) = ...
       (1/k_p)*[(1-param.gammap)*param.Tpi
                                         1
           -(1-param.Tpi)*(1-param.gammap)];


Ftt_mat(:,:,j) = Ft;



% 3. Updating rules

xi_1 =Ft*xi_tt;



P_1 = Ft*P_tt*Ft'+Q;


xi_tl_mat(:,j) = xi_1;

Ptl_mat(:,:,j) = P_1;



% 4. Evaluates likelihood

if j > traning_sample

    
L_fun = L_fun-0.5*log((det(H(:,isobs)'*P_0*H(:,isobs)+R(isobs,isobs))))-0.5*eps'*OM_inv*eps;

%save TESTv1 xttTest1 attest
%disp(L_fun);disp(j);pause
end


% Update params (probably not needed: change notation?)

xi_0 = xi_1; P_0 = P_1;

end