
function [xi_0,P_0,kini] = KF_initializeB_fun(param,vrbs,vrbs_obs,Y_data_ini,F,Q)

 %% Initialization of Kalman filter
 
 kini = 0;
  
   % Initial conditions for gain and MSEs
    
    k_pini = 1/param.ini_g; 
    
    
 
 
  % Initial conditions
  
      xi_01 = zeros(size(F,2),1); 

     
      xi_01(vrbs.infl)  = Y_data_ini(vrbs_obs.infl,end)./4;
      
      
      xi_0 = xi_01; 
     

 
 

     
     % Precision matrix
     
  if param.Pini == 0
     
     P_0 = (1/param.mult)*eye(size(F,2)); 
     
     
     else

         Fp = F;
         
         Fp([vrbs.infl vrbs.pibar vrbs.fe],vrbs.fe) = ...
             (1/k_pini)*[(1-param.gammap)*param.Tpi
             1
             -(1-param.Tpi)*(1-param.gammap)];
         
         P_0 = mult*(Fp*real(lyapcsd(Fp,Q))*Fp'+Q);
         
         
    end
   
     
      
%   TEST P-Matrix: 

%            [Rj,pchol] = chol(P_0); %% checking the mat is positive definite
%            
%            %disp(pchol)
%            %           pause
%            keyboard
%            if pchol > 0   
%                
%                kini = 1; return
%                
%            end
          
      





