

function [H,H_NOobserr,mu,R,obscoeff] = H_CPI_fun(param,SIM_reg,vrbs_obs,vrbs)
         
%% Observation equation



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%
%%%%% NOTE: this function has to be modified manually if the forecasting model
%%%%% changes!
%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

OMEGA_c = param.OMEGA_c;


% 2Y-ahead

 Kpow2Y58 = 0;   
 
for jj = 5:8
  
    Kpow2Y58 = Kpow2Y58 + OMEGA_c^jj;
    
end



% 510Y-ahead
 Kpow510Y2140 = 0; 
  

for jj = 21:40
    
    Kpow510Y2140 = Kpow510Y2140 + OMEGA_c^jj;
    
end


% NOTE: all variables are expressed in annualized terms (mult. by 4)

obscoeff = 4;


% Mean
         
 mu = obscoeff*param.pibar*ones(vrbs_obs.n_obsvables,1);
 

 
% xit 
      
Hm = zeros(vrbs_obs.n_obsvables, vrbs.n_var_ss);


                          
                               
Hm(vrbs_obs.infl,vrbs.infl) = 1; 


OMc1 = OMEGA_c(vrbs.infl,:);


Hm(vrbs_obs.infl1Q_spf,SIM_reg.posX_vec) = OMc1;


OMEGA_c2 = OMEGA_c^2; 

OMc2 = OMEGA_c2(vrbs.infl,:);

Hm(vrbs_obs.infl2Q_spf,SIM_reg.posX_vec) = OMc2;

                                    
Hm(vrbs_obs.infl12Q_liv, SIM_reg.posX_vec) = (1/2).*(OMc1 + OMc2);

Hm(vrbs_obs.infl12Q_livtrue, SIM_reg.posX_vec) = (1/2).*(OMc1 + OMc2);



                                    
OMEGA_c3 = OMEGA_c^3; 

Hm(vrbs_obs.infl3Q_spf,SIM_reg.posX_vec) = OMEGA_c3(vrbs.infl,:);


OMEGA_c4 = OMEGA_c^4; 


Hm(vrbs_obs.infl4Q_spf,SIM_reg.posX_vec) = OMEGA_c4(vrbs.infl,:);




Hm(vrbs_obs.infl2Y_bcff,SIM_reg.posX_vec) = (1/4).*...
                                   Kpow2Y58(vrbs.infl,:);
                                   
                                 

Hm(vrbs_obs.infl510Y_bcff,SIM_reg.posX_vec) = (1/20).*...
                                  Kpow510Y2140(vrbs.infl,:);
                                  

Hmno = Hm; % no observation errors


% Add observation errors
                               
Hm([vrbs_obs.infl vrbs_obs.infl1Q_spf vrbs_obs.infl2Q_spf ...
    vrbs_obs.infl12Q_liv vrbs_obs.infl12Q_livtrue],end-vrbs.n_obs_shocks+1:end) = ...
    eye(vrbs.n_obs_shocks);


Hm(vrbs_obs.infl12Q_liv,end) = 1; % The long series of livingston forecasts has two observetion errors! 


H = obscoeff*Hm'; % Hamilton notation

H_NOobserr = obscoeff*Hmno';

% Observation errors (not used)

R = zeros(vrbs_obs.n_obsvables,vrbs_obs.n_obsvables); 
