
function param = EstparamB_fun(x,vrbs,paramest,MShok,SIM_reg)


% Model

param.Model = paramest.Model;


% Initial connds.

param.Pini = 0; % set ==0 for eye and == 1 for initial P consistent with F,Q
param.mult = 10; % scaling P0|0



% Structural

param.pibar = x(paramest.pibar); %2.5/4; % quarterly ss inflation

param.gammap = x(paramest.gammap);

param.Tpi = x(paramest.Tpi);

param.rho_phi = x(paramest.rho_phi);



% Learning alghoritm

param.nu = x(paramest.nu);



if paramest.Model == 1
 
param.g = x(paramest.g);
        
param.ini_g = param.g;%0.025;% x(paramest.ini_g);%.025; % initial gain
% NOTE: could also use param.g as default in the baseline model


% Stability condition under constant gain

param.absDTpi = abs((param.g)*(1-param.gammap)*(param.Tpi-1)+1);

param.iota = NaN; 

param.gplus = NaN; 

param.gmns = NaN;
        
param.ini_Vk = NaN; % K time varying gain algorithm


end


if paramest.Model == 3
    
% G and K time-varying gains

param.ini_g = x(paramest.ini_g);

param.absDTpi = abs((param.ini_g)*(1-param.gammap)*(param.Tpi-1)+1);

param.gplus = 0.6; 

param.gmns = 0.01;
        
param.ini_Vk = paramest.ini_Vk; % K time varying gain algorithm

param.g = NaN;

param.iota = NaN;    


end



if paramest.Model == 2

param.iota = x(paramest.iota); % curvature in the adjustment function    
    
% G and K time-varying gains

param.gplus =x(paramest.gplus); 

param.gmns = 0.01;

param.g = param.gplus;

param.absDTpi = abs((param.gplus)*(1-param.gammap)*(param.Tpi-1)+1);

param.ini_Vk = NaN; % K time varying gain algorithm

param.ini_g =  NaN;


end



% NOTE: adjust the gain in the condition, as a function of the updating...



% Matrix for agents' forecasting

param.OMEGA_c = zeros(SIM_reg.n_eq);

param.OMEGA_c(vrbs.infl,vrbs.infl) = param.gammap;

param.OMEGA_c(vrbs.infl,vrbs.pibar) = 1 - param.gammap;

param.OMEGA_c(vrbs.infl,vrbs.phi) = param.rho_phi;

param.OMEGA_c(vrbs.phi,vrbs.phi) = param.rho_phi;

param.OMEGA_c(vrbs.pibar,vrbs.pibar) = 1;



% VCV of shocks 

param.n_phi = exp(x(paramest.n_phi));

param.n_muT = exp(x(paramest.n_muT));

param.oe1B = exp(x(paramest.oe1B));

param.oe2B = exp(x(paramest.oe2B));

param.oe3B = exp(x(paramest.oe3B));

param.oe4B = exp(x(paramest.oe4B));

param.oe5B = exp(x(paramest.oe5B));


Sig_diag_vec = zeros(vrbs.n_shocks+vrbs.n_obs_shocks,1); 


Sig_diag_vec([MShok.n_phi MShok.n_muT MShok.n_obshock]) = ...
    [param.n_phi;param.n_muT;param.oe1B;param.oe2B;param.oe3B;param.oe4B;param.oe5B];

Sig_lower_tril = diag(Sig_diag_vec);


param.VCV_eps = Sig_lower_tril*Sig_lower_tril';


% MSE from model-consistent forecast
param.STDfeM = sqrt(param.VCV_eps(MShok.n_phi,MShok.n_phi) + ...
                 param.VCV_eps(MShok.n_muT,MShok.n_muT));



