
function [vrbs, MShok,SIM_reg] = Define_Model_CPIfun(nobs_shocks)

%% Defines variables and others 


% Model variables

vrbs.infl = 1;
vrbs.phi = 2;
vrbs.pibar = 3;

% NOTE: do not change the ordering of the first 3 variables!
%       it corresponds to agents' forecasting model (OMEGA_c)

n_Omega_c = 3;

vrbs.fe = n_Omega_c+1;

% Innovations
vrbs.phiT = n_Omega_c+2;
vrbs.muT = n_Omega_c+3;

vrbs.n_var = n_Omega_c+3;


%% shocks

MShok.n_phi = 1;
MShok.n_muT = 2;

vrbs.n_shocks = 2;

% Observation shocks

vrbs.n_obs_shocks = nobs_shocks; % needs to be consistent with the data
% obs shocks (in state-space model) 


MShok.n_obshock = vrbs.n_shocks+1:1:(vrbs.n_shocks + vrbs.n_obs_shocks); % short-horizon forecasts + CPI


% State Space
vrbs.n_var_ss = vrbs.n_var + vrbs.n_obs_shocks;


% Agents regression

SIM_reg.posX_vec = [vrbs.infl;vrbs.phi;vrbs.pibar]; %% agents' forecasting model (OMEGA_c)

SIM_reg.pos_vec  = [vrbs.infl]; % independent variable(s) in xi_tt

SIM_reg.n_eq = length(SIM_reg.pos_vec);
                                                             
SIM_reg.n_x = length(SIM_reg.posX_vec); 




