
function priors = DefinePriors_fun(Model)

% DEFINE PRIORS on estimated params



% Introduce struct: ex: priors.gammap.m.v

priors.gammap.dist = 'betapdf';
%mu = 1/2; sigma2 = 1/12; % Sept 11
mu = 0.5; sigma2 = 0.07; % current

[alpha, beta] = our_betasolve(mu,sigma2);
priors.gammap.m1 = alpha; % prior mean
priors.gammap.m2 = beta; % prior std
priors.gammap.trans = 0; % no transformation
priors.gammap.mean = mu;
priors.gammap.std = sqrt(alpha*beta/((alpha+beta)^2*(alpha+beta+1)));


priors.rho_phi.dist = 'betapdf';
%mu = 0.7; sigma2 = 0.15^2; % Most recent
mu = 0.6; sigma2 = 0.2^2; 
[alpha, beta] = our_betasolve(mu,sigma2);
priors.rho_phi.m1 = alpha; % prior mean
priors.rho_phi.m2 = beta; % prior std
priors.rho_phi.trans = 0; % no transformation
priors.rho_phi.mean = mu; 
priors.rho_phi.std = sqrt(alpha*beta/((alpha+beta)^2*(alpha+beta+1)));
%priors.rho_phi.mean = alpha/(alpha+beta);


priors.Tpi.dist = 'betapdf';
%mu = 1/2; sigma2 = 1/12; %Sept 11
mu = 0.5; sigma2 = 0.07; % current

[alpha, beta] = our_betasolve(mu,sigma2);
priors.Tpi.m1 = alpha; % prior mean
priors.Tpi.m2 = beta; % prior std
priors.Tpi.trans = 0; % no transformation
priors.Tpi.mean = mu;
priors.Tpi.std = sqrt(alpha*beta/((alpha+beta)^2*(alpha+beta+1)));
%priors.rho_phi.mean = alpha/(alpha+beta);

if Model == 1

priors.nu.dist = 'gampdf';

mu = 0.05; sigma2 = 0.04^2; % current

priors.nu.m1 = mu^2/sigma2; % shape param
priors.nu.m2 = sigma2/mu; % scale param
priors.nu.trans = 0; % transformation via exp
priors.nu.mean = mu;
priors.nu.std = sqrt(sigma2);


elseif Model == 2

    
% priors.nu.dist = 'gampdf';
% 
% %mu = 0.1; sigma2 = 0.05^2; % current
% mu = 0.05; sigma2 = 0.04^2; % current
% 
% priors.nu.m1 = mu^2/sigma2; % shape param
% priors.nu.m2 = sigma2/mu; % scale param
% priors.nu.trans = 0; % transformation via exp
% priors.nu.mean = mu;
% priors.nu.std = sqrt(sigma2);
    

priors.nu.dist = 'betapdf';
%mu = 1/2; sigma2 = 1/12; % Sept 11
mu = 0.5; sigma2 = 0.07; % current

[alpha, beta] = our_betasolve(mu,sigma2);
priors.nu.m1 = alpha; % prior mean
priors.nu.m2 = beta; % prior std
priors.nu.trans = 0; % no transformation
priors.nu.mean = mu;
priors.nu.std = sqrt(alpha*beta/((alpha+beta)^2*(alpha+beta+1)));

    
elseif Model == 3

    
priors.nu.dist = 'gampdf';

mu = 0.05; sigma2 = 0.04^2; % current

priors.nu.m1 = mu^2/sigma2; % shape param
priors.nu.m2 = sigma2/mu; % scale param
priors.nu.trans = 0; % transformation via exp
priors.nu.mean = mu;
priors.nu.std = sqrt(sigma2);
        
end    


priors.g.dist = 'gampdf';
%mu = 0.10; sigma2 = 0.05^2; % Sept 11
mu = 0.10; sigma2 = 0.09^2;  

priors.g.m1 = mu^2/sigma2; % shape param
priors.g.m2 = sigma2/mu; % scale param
priors.g.trans = 0; % transformation via exp
priors.g.mean = mu;
priors.g.std = sqrt(sigma2);


priors.ini_g.dist = 'our_igampdf';
mu = 0.05; sigma2 = 0.05^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.ini_g.m1 = alpha; % prior mean
priors.ini_g.m2 = beta; % prior std
priors.ini_g.trans = 0; % transformation via exp
if alpha >2
priors.ini_g.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.ini_g.std = NaN;
end
priors.ini_g.mean = mu;

priors.ini_Vk.dist = 'normpdf';
mu = 0.0/4; sigma2 = 10^2;
priors.ini_Vk.m1 = mu; % prior mean
priors.ini_Vk.m2 = sigma2; % prior std
priors.ini_Vk.trans = 0; % transformation via exp
priors.ini_Vk.mean = mu;
priors.ini_Vk.std = sqrt(sigma2);

priors.iota.dist = 'gampdf';
%mu = 0.10; sigma2 = 0.05^2; % Sept 11
mu = 70; sigma2 = 20^2;  

priors.iota.m1 = mu^2/sigma2; % shape param
priors.iota.m2 = sigma2/mu; % scale param
priors.iota.trans = 0; % transformation via exp
priors.iota.mean = mu;
priors.iota.std = sqrt(sigma2);

priors.gplus.dist = 'gampdf';
%mu = 0.10; sigma2 = 0.05^2; % Sept 11
mu = 0.10; sigma2 = 0.09^2;  

priors.gplus.m1 = mu^2/sigma2; % shape param
priors.gplus.m2 = sigma2/mu; % scale param
priors.gplus.trans = 0; % transformation via exp
priors.gplus.mean = mu;
priors.gplus.std = sqrt(sigma2);


priors.pibar.dist = 'normpdf';
mu = 2.0/4; sigma2 = 0.3^2;
priors.pibar.m1 = mu; % prior mean
priors.pibar.m2 = sigma2; % prior std
priors.pibar.trans = 0; % transformation via exp
priors.pibar.mean = mu;
priors.pibar.std = sqrt(sigma2);


priors.n_phi.dist = 'our_igampdf';
mu = 0.5; sigma2 = 4^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.n_phi.m1 = alpha; % prior mean
priors.n_phi.m2 = beta; % prior std
priors.n_phi.trans = 1; % transformation via exp
if alpha >2
priors.n_phi.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.n_phi.std = NaN;
end
priors.n_phi.mean = mu;

priors.n_muT.dist = 'our_igampdf';
mu = 0.5; sigma2 = 4^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.n_muT.m1 = alpha; % prior mean
priors.n_muT.m2 = beta; % prior std
priors.n_muT.trans = 1; % transformation via exp
if alpha >2
priors.n_muT.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.n_muT.std = NaN;
end
priors.n_muT.mean = mu;

priors.oe1B.dist = 'our_igampdf';
mu = 0.1; sigma2 = 1^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.oe1B.m1 = alpha; % prior mean
priors.oe1B.m2 = beta; % prior std
priors.oe1B.trans = 1; % transformation via exp
if alpha >2
priors.oe1B.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.oe1B.std = NaN;
end
priors.oe1B.mean = mu;


priors.oe2B.dist = 'our_igampdf';
mu = 0.1; sigma2 = 1^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.oe2B.m1 = alpha; % prior mean
priors.oe2B.m2 = beta; % prior std
priors.oe2B.trans = 1; % transformation via exp
if alpha >2
priors.oe2B.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.oe2B.std = NaN;
end
priors.oe2B.mean = mu;


priors.oe3B.dist = 'our_igampdf';
mu = 0.1; sigma2 = 1.0^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.oe3B.m1 = alpha; % prior mean
priors.oe3B.m2 = beta; % prior std
priors.oe3B.trans = 1; % transformation via exp
if alpha >2
priors.oe3B.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.oe3B.std = NaN;
end
priors.oe3B.mean = mu;


priors.oe4B.dist = 'our_igampdf';
mu = 0.1; sigma2 = 1^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.oe4B.m1 = alpha; % prior mean
priors.oe4B.m2 = beta; % prior std
priors.oe4B.trans = 1; % transformation via exp
if alpha >2
priors.oe4B.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.oe4B.std = NaN;
end
priors.oe4B.mean = mu;



priors.oe5B.dist = 'our_igampdf';
mu = 0.1; sigma2 = 1^2;
[alpha, beta] = our_igamsolve(mu,sigma2);
priors.oe5B.m1 = alpha; % prior mean
priors.oe5B.m2 = beta; % prior std
priors.oe5B.trans = 1; % transformation via exp
if alpha >2
priors.oe5B.std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
else
priors.oe5B.std = NaN;
end
priors.oe5B.mean = mu;


% priors.oe1Cus.dist = 'our_igampdf';
% mu = 0.1; sigma2 = 1.0^2;
% [alpha, beta] = our_igamsolve(mu,sigma2);
% priors.oe1Cus.m1 = alpha; % prior mean
% priors.oe1Cus.m2 = beta; % prior std
% priors.oe1Cus.trans = 1; % transformation via exp
% 
% priors.oe2Cus.dist = 'our_igampdf';
% mu = 0.1; sigma2 = 1^2;
% [alpha, beta] = our_igamsolve(mu,sigma2);
% priors.oe2Cus.m1 = alpha; % prior mean
% priors.oe2Cus.m2 = beta; % prior std
% priors.oe2Cus.trans = 1; % transformation via exp
% 
% priors.oe3Cus.dist = 'our_igampdf';
% mu = 0.1; sigma2 = 1^2;
% [alpha, beta] = our_igamsolve(mu,sigma2);
% priors.oe3Cus.m1 = alpha; % prior mean
% priors.oe3Cus.m2 = beta; % prior std
% priors.oe3Cus.trans = 1; % transformation via exp


% LIST OF PRIORS


% priors.estimated = strvcat('pibar','nu','g','ini_ginv','gammap','Tpi','rho_phi','n_phi',...
%     'n_muT','oe1B','oe2B','oe3B','oe4B','oe5B');

if Model == 1
    
% Baseline
priors.estimated = strvcat('pibar','nu','g','gammap','Tpi','rho_phi','n_phi',...
    'n_muT','oe1B','oe2B','oe3B','oe4B','oe5B');


priors.sigscale = diag([priors.pibar.std;priors.nu.std;priors.g.std;priors.gammap.std;...
                   priors.Tpi.std;priors.rho_phi.std;priors.n_phi.std;...
                   priors.n_muT.std;priors.oe1B.std;priors.oe2B.std;...
                   priors.oe3B.std;priors.oe4B.std;priors.oe5B.std]);



priors.names = {'$\pi$';'$\nu$';'$g$';'$\gamma_p$';'$T_\pi$';'$\rho_\phi$';...
                '$\sigma_\phi$';'$\sigma_\mu$';
                '$oe_1$'; '$oe_2$'; '$oe_3$'; '$oe_4$'; '$oe_5$';};

priors.distnames = {'Normal';'Gamma';'Gamma';'Beta';'Beta';'Beta';...
                    'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma'};

elseif Model == 2


% Gauss (2014) with fixed gmnus

priors.estimated = strvcat('pibar','nu','iota','gplus','gammap','Tpi','rho_phi','n_phi',...
    'n_muT','oe1B','oe2B','oe3B','oe4B','oe5B');

priors.sigscale = diag([priors.pibar.std;priors.nu.std;priors.iota.std;priors.gplus.std;priors.gammap.std;...
                    priors.Tpi.std;priors.rho_phi.std;priors.n_phi.std;...
                    priors.n_muT.std;priors.oe1B.std;priors.oe2B.std;...
                    priors.oe3B.std;priors.oe4B.std;priors.oe5B.std]);

priors.names = {'$\pi$';'$\nu$';'$\iota$';'$gplus$';'$\gamma_p$';'$T_\pi$';'$\rho_\phi$';...
                '$\sigma_\phi$';'$\sigma_\mu$';
                '$oe_1$'; '$oe_2$'; '$oe_3$'; '$oe_4$'; '$oe_5$';};

priors.distnames = {'Normal';'Gamma';'Gamma';'Gamma';'Beta';'Beta';'Beta';...
                    'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma'};

    
    
 % If want to estimat lowerbar g
 
% priors.estimated = strvcat('pibar','nu','g','gammap','Tpi','rho_phi','n_phi',...
%     'n_muT','oe1B','oe2B','oe3B','oe4B','oe5B');
% 
% priors.names = {'$\pi$';'$\nu$';'$g$';'$\gamma_p$';'$T_\pi$';'$\rho_\phi$';...
%                 '$\sigma_\phi$';'$\sigma_\mu$';
%                 '$oe_1$'; '$oe_2$'; '$oe_3$'; '$oe_4$'; '$oe_5$';};
% 
% priors.distnames = {'Normal';'Gamma';'Gamma';'Beta';'Beta';'Beta';...
%                     'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma'};


elseif Model == 3   
    
% Kostyshyna (2012) [Kushner and Yin 1995]

priors.estimated = strvcat('pibar','nu','ini_g','ini_Vk','gammap','Tpi','rho_phi','n_phi',...
    'n_muT','oe1B','oe2B','oe3B','oe4B','oe5B');


priors.sigscale = diag([priors.pibar.std;priors.nu.std;priors.ini_g.std;priors.ini_Vk.std;priors.gammap.std;...
                   priors.Tpi.std;priors.rho_phi.std;priors.n_phi.std;...
                   priors.n_muT.std;priors.oe1B.std;priors.oe2B.std;...
                   priors.oe3B.std;priors.oe4B.std;priors.oe5B.std]);


priors.names = {'$\pi$';'$\nu$';'$g_ini$';'$Vk_ini$';'$\gamma_p$';'$T_\pi$';'$\rho_\phi$';...
                '$\sigma_\phi$';'$\sigma_\mu$';
                '$oe_1$'; '$oe_2$'; '$oe_3$'; '$oe_4$'; '$oe_5$';};

priors.distnames = {'Normal';'Gamma';'Gamma';'Norm';'Beta';'Beta';'Beta';...
                    'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma';'IGamma'};

end    
                
                
% NOT CURRENTLY USED                
% % SiGscale for new mode. Use variance of the priors
% 
% priors.sigscale = diag([priors.pibar.std;priors.nu.std;priors.g.std;priors.gammap.std;...
%                    priors.Tpi.std;priors.rho_phi.std;priors.n_phi.std;...
%                    priors.n_muT.std;priors.oe1B.std;priors.oe2B.std;...
%                    priors.oe3B.std;priors.oe4B.std;priors.oe5B.std]);


               



