
%clear
function [] = CreateTable(X_draws,Logpost_draws,priors)   
%priors = DefinePriors_fun;

% CurrentDraws ='13-Sep-2015_1440Metro_CPI_USPini0_2';
% 
% %% Posteriors
% 
% load(CurrentDraws, 'X_draws', 'Logpost_draws');

nxd = 3; discard = round(size(X_draws,2)/nxd);


% Tranform X_draws when needed

X_drawsT = X_draws;

meanPriors = NaN(size(priors.estimated,1),1);

stdPriors = NaN(size(priors.estimated,1),1);


for j = 1:size(priors.estimated,1)
   
    
    param = char(priors.estimated(j,:));
    
    
    X_drawsT(j,:) = eval(['priors.',param,'.trans'])*exp(X_drawsT(j,:))...
                    +(1 - eval(['priors.',param,'.trans']))*X_drawsT(j,:);
                
                
    meanPriors(j) = eval(['priors.',param,'.mean']);
    
    stdPriors(j) = eval(['priors.',param,'.std']);
    
end    

% Select mode

[~, b] = max(Logpost_draws);
        
fvalmode = Logpost_draws(b);
    
xmode = X_drawsT(:,b);


PosteriorTab = xmode;


% Mean and Standard Deviation

PosteriorTab = [PosteriorTab mean(X_drawsT,2) std(X_drawsT,0,2)];

% Median and percentiles

PosteriorTab = [PosteriorTab prctile(X_drawsT,[5,50,95],2)];


%% Priors

allData = [meanPriors stdPriors PosteriorTab];







%% Format Table


headerLine1 = {'', 'Prior', NaN, NaN,'Posterior',NaN,NaN,NaN,NaN,NaN}; % Nan is like a merge
headerLine2 = {'', 'Dist.', 'Mean', 'Std','Mode','Mean','Std','5\%','Median','95\%'};
header = [headerLine1; headerLine2];
style1 = 'll';

style2 = repmat('c',1,size(header,2)-2);

style = [style1 style2];
style = [style(1:4),'|',style(5:end)];



paramNames = priors.names;
distNames  = priors.distnames;
data       = num2cell(allData);
tableBody  = [paramNames distNames data];



WriteTeXTable1(NaN, header, style, tableBody)

f = fopen('TablePriorsPosteriors.txt', 'w');
WriteTeXTable1(f, header, style, tableBody)
fclose(f)












