
function [All_draws, All_Logpost_draws,psRhat] = ConvergenceTestv2(SavedResults)

%% Convergence tests

pth = pwd;
ind = strfind(pth,'Code');
datapath = [pth(1,1:ind-1),'Results'];
if isunix, pathslash = '/'; else pathslash = '\'; end  


% Setup

nChain = 5;


initFD = 50000; % burnin;

% Load chains


%save([timestamp, MetropolisName]);
for j = 1:nChain
    
   
load([datapath, pathslash,...
    'EstimationResults',pathslash,'Metropolis',pathslash,...
    [SavedResults,num2str(j)]], 'X_draws','Logpost_draws');


 LambdaS(:,:,j) = X_draws';
 
 LogpostMat(:,j) = Logpost_draws';
 

 if j == 1
     
     NDraw = size(X_draws,2)*nChain;
     
 end
 
  clear X_draws Logpost_draws

end


 %  % all draws stuck in lambdaS (3D)

 % Calculating covariance matrices for each chain
       % VarCov=cov(LambdaS(round(length(LambdaS)/2):end,:));
 
       for ch=1:nChain
            eval(['VarCov.Ch',int2str(ch),'=cov(LambdaS(initFD:end,:,ch));'])
        end

        % Calculating convergence criterion by potential scale reduction, GCSR p. 296 f
        psrn = NDraw/nChain-initFD+1;
        for ch=1:nChain
            S2(:,ch) = diag(cov(LambdaS(initFD:end,:,ch)));
            psibar(:,ch) = sum(LambdaS(initFD:end,:,ch))'/psrn;
        end
        psrW = mean(S2,2);
        psrB = psrn*diag(cov(psibar'));
        psRhat = sqrt(((psrn-1)/psrn*psrW + psrB/psrn)./psrW);

        % psRhat < 1.01
        
        
   % Stack all together (in this shameful way)
   
   nparam = size(LambdaS,2);
   
   All_draws = NaN(size(LambdaS(initFD:end,:,:),1)*nChain,nparam);
   
   for jj = 1:nparam
   
   All_draws(:,jj) = [squeeze(LambdaS(initFD:end,jj,1)); squeeze(LambdaS(initFD:end,jj,2)); ...
                      squeeze(LambdaS(initFD:end,jj,3)); squeeze(LambdaS(initFD:end,jj,4)); ...
                      squeeze(LambdaS(initFD:end,jj,5))];
        
   end
   
   All_Logpost_draws =   [LogpostMat(initFD:end,1);LogpostMat(initFD:end,2);
                          LogpostMat(initFD:end,3);LogpostMat(initFD:end,4);
                          LogpostMat(initFD:end,5)];
   
 
                      
%% GRAVEYARD        
                      
%   % Plot priors and posteriors
%   
%   
%  % priors = DefinePriors_fun;
% 
%   
%  
% close all;
% 
% for j = 1:size(priors.estimated,1)
% 
%     
%     parameter = char(priors.estimated(j,:));
%     
%     figure;
%     
%     if eval(['priors.',parameter,'.trans']) == 1
%         
%     [a b] = hist(exp(All_draws(:,j)),100);    
%         
%     else
%     
%     [a b] = hist(All_draws(:,j),100);
%     
%     end
%     
%      bar(b,a/sum(a));
%     
%      hold on
%      
%     
%             
%     
% 
%     for i = 1:length(b),
%         pdf(i) = eval([eval(['priors.',parameter,'.dist']),'(',num2str(b(i)),',',num2str(eval(['priors.',parameter,'.m1'])),',',num2str(eval(['priors.',parameter,'.m2'])),')']);
%     end;
%     
%     plot(b,pdf/sum(pdf),'r--')
%     
%     
%     
%     title(parameter);
%     
%     ng = (parameter);  
%       print(char(strcat(ng,'.eps')),'-depsc2');   print(char(strcat(ng,'.pdf')),'-dpdf');   % 
% 
%     
%     
%     clear pdf
% 
% end;



   
   
        
% %         % Print table with Convergence test
% %         NAME= 'Potential scale raduction estimate. The parameters refer to their jacobian transforms.';
% %         RowLabel = 'log(zeta) log(sigmaY) log(sigman) v1';
% %         for j=2:kstar-1
% %             RowLabel = [RowLabel,' v',int2str(j)];
% %         end
% %         for j=0:p1
% %             RowLabel = [RowLabel,' delta',int2str(j)];
% %         end
% %         for j=0:p2
% %             RowLabel = [RowLabel,' rho',int2str(j)];
% %         end
% %         ColLabel = 'PSR';
% %         printmat([psRhat],NAME,RowLabel,ColLabel);

