
clear

countries = cell(12,1);
countries{1} = 'canada';
countries{2} = 'france';
countries{3} = 'germany';
countries{4} = 'italy';
countries{5} = 'japan';
countries{6} = 'norway';
countries{7} = 'australia';
countries{8} = 'spain';
countries{9} = 'sweden';
countries{10} = 'portugal';
countries{11} = 'UnitedKingdom';
countries{12} = 'usa';

% Select country
 country_select = 3; % Country
country = countries{country_select};

countryfile = [country,'.xlsx'];

% Import data



% Prices
   
  % sample starts in 1954.75, ends 2017.75
    
[Data_untr Data_str Data_cell] = xlsread(countryfile,country);


CPIinflation = 4*Data_untr(:,3)'; 


% Unemployment and flows

%[Data_untr Data_str Data_cell] = xlsread('ustarJune2017.xlsx','Unemployment');

Unemployment = Data_untr(:,1)' + Data_untr(:,2)';
% s_rate = Data_untr(:,3)';
% f_rate = Data_untr(:,2)';

utrend = Data_untr(:,1)';

% Slack

%[Data_untr Data_str Data_cell] = xlsread('ustarJune2017.xlsx','Slack');

caput  = Data_untr(:,4)'; 
ISMmfg = NaN(1,length(caput));

% Detrend caput with 'linear' trend

[caput_trend,~] = hpfilter(caput,500000000);

caput_detrend = caput- caput_trend';

% Surveys

%[Data_untr Data_str Data_cell] = xlsread('ustarJune2017.xlsx','Surveys');

CPI1Q  =  NaN(1,length(caput));
CPI12Q =  NaN(1,length(caput));
CPI14Q =  4*Data_untr(:,7)';
CPI510Y = 4*Data_untr(:,8)';
u14Q    = NaN(1,length(CPI1Q)); % not filled yet

% Now prepare estimates of utrend based on the flows
%
% These have to be restricted to a sample starting in 1967

% utrend_sample_ind = find(1954.75:1/4:2017.75 >= 1967);
% 
% [sh,~] = hpfilter(s_rate(utrend_sample_ind),50000);
%  fm = nanmean(f_rate);
% %[fm,~] = hpfilter(f_rate(utrend_sample_ind),200000);
% utrend(utrend_sample_ind) = 100*(sh'./(sh'+fm'));
% disp('done')
% Save Dataset for observation equation

sampleJapan = 1968:1/4:2017.75;

save DataMat_germany Unemployment sampleJapan CPIinflation caput_detrend...
     ISMmfg CPI1Q CPI12Q CPI14Q CPI510Y u14Q utrend

 return
% Figures 

figure;plot(1968.25:1/4:2017.75,CPIinflation,'k-')
figure;plot(1968.25:1/4:2017.75,Unemployment,'k-')
figure;plot(1968.25:1/4:2017.75,caput,'k-')
figure;plot(1968.25:1/4:2017.75,utrend,'k-')
figure;plot(1968.25:1/4:2017.75,CPI14Q,'kd')
hold on;plot(1968.25:1/4:2017.75,CPI510Y,'rd') 

return 
 % Plots

 % separation rate

 figure('Units','centimeters','Position',[26.5642 14.2081 11.8167 10.1125])
 plot(1967:1/4:2017,s_rate(utrend_sample_ind))
 hold on;plot(1967:1/4:2017,sh,'r')
 xlim([1967,2017])
 
 ng = 'US_s_h'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);
    
    
figure('Units','centimeters','Position',[26.5642 14.2081 11.8167 10.1125])
 plot(1967:1/4:2017,f_rate(utrend_sample_ind))
 hold on;plot(1967:1/4:2017,fm*ones(length(f_rate(utrend_sample_ind)),1),'r')
%  hold on;plot(1967:1/4:2017,fm,'r')

 xlim([1967,2017])
 
 ng = 'US_f_h'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);    

    
figure('Units','centimeters','Position',[26.5642 14.2081 11.8167 10.1125])
 plot(1967:1/4:2017,utrend(utrend_sample_ind))
 hold on;plot(1967:1/4:2017,fm*ones(length(f_rate(utrend_sample_ind)),1),'r')
 xlim([1967,2017])
 
 ng = 'US_f_h'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);      
    
return 


% For Aysegul







[sh,~] = hpfilter(Data_untr(:,5),50000);
hold on;plot(sh,'r')

% Fancy
dates_num = datenum(Data_str(3:end,1),'yyyy-QQ');
dates = cellstr(datestr(dates_num,'yyyy:QQ'));

% plot(dates_num,rand(201,1))
% datetick
% datetick('x','yyyy-QQ')
%find(dates_num==datenum('1980:Q1','yyyy:QQ'))

% Not Fancy

% sample: 1967.25:1/4:2017;


% Preparing estimate of utrnd based on flows

% 1. detrended s, mean f

figure;plot(Data_untr(:,5))
[sh,~] = hpfilter(Data_untr(:,5),50000);
hold on;plot(sh,'r')

figure;plot(Data_untr(:,4))
[sfll,~] = hpfilter(Data_untr(:,4),500000000);
hold on;plot(sfll,'r')

%figure;plot(Data_untall(:,4))
sfm = mean(Data_untr(:,4));
plot(sfm*ones(length(Data_untr(:,4)),1),'b--')
hold off;

utrendl = 100*(sh./(sh+sfll));
figure;plot(Data_untr(:,1))
hold on;plot(utrendl,'r')

utrendm = 100*(sh./(sh+sfm));
%plot(Data_untr(:,1))
hold on;plot(utrendm,'b--')
hold off

% Adding the guys

figure;plot(Data_untr(:,5) + Data_untr(:,4))
% Save


%save DataMat_LaubachMay2017 Data_untr sh sfll sfm utrendl utrendm





