
%clear
%function [] = CreateTable(X_select_draws_all,xmode,priors)   
%priors = DefinePriors_fun;

% CurrentDraws ='13-Sep-2015_1440Metro_CPI_USPini0_2';
% 
% %% Posteriors
% 
% load(CurrentDraws, 'X_draws', 'Logpost_draws');

%nxd = 3; discard = round(size(X_draws,2)/nxd);

%load FirstTest

load UstarPriceWage X_draws_fulls

% Priors

priorsT = priors;

% Add Slope of Phillips curve
priorsT.kappab.shape = 'NaN';priorsT.kappab.mean  = NaN;      priorsT.kappab.std  = NaN;      

% priors on variances 
PriorsCF.Psix = 0.15^2*5;
PriorsCF.df_x = 3;
 
PriorsCF.Psimu = 1;
PriorsCF.df_mu = 3;
 
PriorsCF.SC0pist = 0.15^2*5;
PriorsCF.df0pist = 3;
PriorsCF.SC0oe_pi12q_pi = 0.1*5; %Mode
PriorsCF.df0oe_pi12q_pi = 3;
PriorsCF.SC0oe_pi510Y_pi = 0.001*5;
PriorsCF.df0oe_pi510Y_pi = 3;


% MH_select = [1 2 3 4 5 6 10 18:22];
%  
% CF_select = [7 8 9 11 12 13:17 23:27];
params_select = [1:12 22 28];

namesPriors=fieldnames(priorsT);

nPriors = length(params_select);

paramNames = cell(nPriors,1);

%paramNames = namesPriors;
         
         paramNames{1} = '$a_{x,1}$';
         paramNames{2} = '$a_{x,2}$';
         paramNames{3} ='$\alpha$';
         paramNames{4} ='$\gamma$';
         paramNames{5} ='$\rho_{u^{*}}$';
         paramNames{6} ='$\rho_{\mu}$';
         paramNames{7} ='$\sigma_{x}$';
         paramNames{8} ='$\sigma_{\mu}$';
         paramNames{9} ='$\sigma{\pi^{*}}$';
         paramNames{10} ='$\sigma_{u^{*}}$';
         paramNames{11} = '$\sigma_{o,\pi^{510Y}}$';
         paramNames{12} ='$\sigma_{o,\pi^{12Q}}$';
         %paramNames{13} = '$\sigma_{o,W}$';
         paramNames{13} ='$g_{w}$';
         paramNames{14} ='$\kappa$';
 
%nPriors=size(namesPriors,1);

Pmean = NaN(nPriors,1);
Pstd = NaN(nPriors,1);

% Tranform X_draws when needed

%X_drawsT = X_draws;
X_drawsT = X_draws_fulls(params_select(1:end-1),:);
X_drawsT(14,:) = (1-X_drawsT(3,:)).*(1-X_drawsT(3,:).*0.99)./X_drawsT(3,:);
% From std to variance
X_drawsT([7 8 9 11 12],:) = X_drawsT([7 8 9 11 12],:).^2;


meanPriors = NaN(nPriors,1);

stdPriors = NaN(nPriors,1);

distNames = cell(nPriors,1);

for j = 1:nPriors
    
    meanPriors(j) = priorsT.(namesPriors{params_select(j)}).mean;
    stdPriors(j) = priorsT.(namesPriors{params_select(j)}).std;
    
    % Overwrite if it is prior on variance
    if j == 7
       meanPriors(j) = PriorsCF.Psix; stdPriors(j) = 0; %Replace with `--' in text
       elseif j == 8
         meanPriors(j) = PriorsCF.Psimu; stdPriors(j) = 0;   
        elseif j == 9
            meanPriors(j) = PriorsCF.SC0pist; stdPriors(j) = 0; 
          elseif j ==  11
             meanPriors(j) = PriorsCF.SC0oe_pi510Y_pi; stdPriors(j) = 0; 
            elseif j ==  12 
               meanPriors(j) = PriorsCF.SC0oe_pi12q_pi; stdPriors(j) = 0; 
     end
    
    switch priorsT.(namesPriors{params_select(j)}).shape;
        
        case 'normpdf'
       
    distNames{j} = 'Normal';
    
        case 'betapdf'
            
    distNames{j} = 'Beta';                
        
        case 'gampdf'
    
    distNames{j} = 'Gamma';
    
        case 'invgampdf'

    distNames{j} = 'InvGamma';
    
        case 'NaN'
    distNames{j} = '--';        
        
            
    end
    
end  
    
    
%     param = char(priors.estimated(j,:));
%     
%     
%     X_drawsT(j,:) = eval(['priors.',param,'.trans'])*exp(X_drawsT(j,:))...
%                     +(1 - eval(['priors.',param,'.trans']))*X_drawsT(j,:);
%                 
%                 
%     meanPriors(j) = eval(['priors.',param,'.mean']);
%     
%     stdPriors(j) = eval(['priors.',param,'.std']);
    
%end    

% Select mode

% [~, b] = max(Logpost_draws);
%         
% fvalmode = Logpost_draws(b);
%     
% xmode = X_drawsT(:,b);


%PosteriorTab = xmode;


% Mean and Standard Deviation

%PosteriorTab = [xmode mean(X_drawsT,2) std(X_drawsT,0,2)];
%PosteriorTab = [xmode mean(X_drawsT,2)];
PosteriorTab = mean(X_drawsT,2);

% Percentiles

PosteriorTab = [PosteriorTab prctile(X_drawsT,[5,95],2)];


%% Priors

allData = [meanPriors stdPriors PosteriorTab];

data       = num2cell(allData);
tableBody  = [paramNames distNames data];

%save DataBok3 tableBody





%% Format Table

%load DataBok % this loads tableBody

% headerLine1 = {'', 'Prior', NaN, NaN,'Posterior',NaN,NaN,NaN}; % Nan is like a merge
% headerLine2 = {'', 'Dist.', 'Mean', 'Std','Mode','Mean','5\%','95\%'};

headerLine1 = {'', 'Prior', NaN, NaN,'Posterior',NaN,NaN}; % Nan is like a merge
headerLine2 = {'', 'Dist.', 'Mean', 'Std','Mean','5\%','95\%'};


header = [headerLine1; headerLine2];
style1 = 'll';

style2 = repmat('c',1,size(header,2)-2);

style = [style1 style2];
style = [style(1:4),'|',style(5:end)];



% paramNames = priors.names;
% distNames  = priors.distnames;

NameTable = ['TablePriorsPosteriors',[timestamp, EstimationName],'.txt'];


WriteTeXTable1(NaN, header, style, tableBody)

f = fopen(NameTable, 'w');
WriteTeXTable1(f, header, style, tableBody)
fclose(f)












