
 function [X_drawsPriors] = drawsPriors(priors,params_index,params_fixed,ndraws)


namesPriors=fieldnames(priors);
nPriors=size(namesPriors,1);
X_drawsPriors = NaN(nPriors,ndraws);

namesParams=fieldnames(params_index);
nParams=size(namesParams,1);

xcount = 0;

for pnames=1:nParams
    
      if ~params_fixed(params_index.(namesParams{pnames}))
          
          xcount = xcount +1;
          
     switch priors.(namesParams{pnames}).shape; 
    
         case 'normpdf'
         
      X_drawsPriors(xcount,:) = priors.(namesParams{pnames}).mean +...
                                priors.(namesParams{pnames}).std *...
                                randn(1,ndraws);
        
         case 'betapdf'
             
      X_drawsPriors(xcount,:) = betarnd(priors.(namesParams{pnames}).m1,...
                                priors.(namesParams{pnames}).m2,1,ndraws);
                            
         case 'gampdf'
     
      X_drawsPriors(xcount,:) = gamrnd(priors.(namesParams{pnames}).m1,...
                                priors.(namesParams{pnames}).m2,1,ndraws);        
      
        case 'invgampdf'
        
            ij = 1;
            
           while ij < ndraws
               
               idraw = 1./gamrnd(priors.(namesParams{pnames}).m1,...
                       1/priors.(namesParams{pnames}).m2);
                   
               if idraw < 3    
     X_drawsPriors(xcount,ij) = idraw;
                ij = ij+1;
               end
           end
                            
     end
         
         
   end% if fixed

end% nparams



