function [params, params_index, params_fixed,trspec,bounds] = setParamsLaubach3(learning)

% This function outputs the params structure, which contains initialized values 
% of the model paramseters as well as derived steady-state values.

params_index.a_x1 = 1;      params(params_index.a_x1,1)       = 1.6;    params_fixed(params_index.a_x1,1) = 0;    
trspec(params_index.a_x1,:) = [2	1E-5	0	1]; bounds(params_index.a_x1,:) = [1E-5 50.999];

params_index.a_x2 = 2;      params(params_index.a_x2,1)       = -0.7;    params_fixed(params_index.a_x2,1) = 0;   
trspec(params_index.a_x2,:) = zeros(1,4); bounds(params_index.a_x2,:) = [-50.999 50.999];

params_index.beta = 3;      params(params_index.beta,1)     = 0.99;       params_fixed(params_index.beta,1) = 1;    
trspec(params_index.beta,:) = [1	1E-5	.99	1];  bounds(params_index.beta,:) = [1E-5 0.999];

params_index.kappa = 4;      params(params_index.kappa,1)     = 0.87;       params_fixed(params_index.kappa,1) = 0;   
trspec(params_index.kappa,:) = [2	1E-5	0	1]; bounds(params_index.kappa,:) = [1E-5 50.999];

params_index.a_pi1 = 5;     params(params_index.a_pi1,1)      = 0.2;       params_fixed(params_index.a_pi1,1) = 0;      
trspec(params_index.a_pi1,:) = [1	1E-5	.99	1]; bounds(params_index.a_pi1,:) = [1E-5 0.989];

params_index.rho_u = 6;      params(params_index.rho_u,1)     = 0.985;       params_fixed(params_index.rho_u,1) = 0;  
trspec(params_index.rho_u,:) = [1	1E-5	.998	1]; bounds(params_index.rho_u,:) = [1E-5 0.996];

params_index.rho_ze = 7;      params(params_index.rho_ze,1)     = 0.36;       params_fixed(params_index.rho_ze,1) = 0;  
trspec(params_index.rho_ze,:) = [1	1E-5	.99	1]; bounds(params_index.rho_ze,:) = [1E-5 0.989];


%%
rs = 7;

%% Standard deviation of shocks
params_index.sigma_x = rs+1;    params(params_index.sigma_x,1)    = 0.2;       params_fixed(params_index.sigma_x,1) = 0; 
trspec(params_index.sigma_x,:) = [2	1E-5	0 1]; bounds(params_index.sigma_x,:) = [1E-5 50.999];

params_index.sigma_pi = rs+2;  params(params_index.sigma_pi,1)  = 1.15;       params_fixed(params_index.sigma_pi,1) = 0; 
trspec(params_index.sigma_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_pi,:) = [1E-5 50.999];

params_index.sigma_pistar = rs+3;  params(params_index.sigma_pistar,1)  = 0.25;       params_fixed(params_index.sigma_pistar,1) = 0; 
trspec(params_index.sigma_pistar,:) = [2	1E-5	0 1]; bounds(params_index.sigma_pistar,:) = [1E-5 50.999];

params_index.sigma_ustar = rs+4;  params(params_index.sigma_ustar,1)  = 0.11;    params_fixed(params_index.sigma_ustar,1) = 0; 
trspec(params_index.sigma_ustar,:) = [2	1E-5	0 1]; bounds(params_index.sigma_ustar,:) = [1E-5 50.999];

params_index.sigma_ze = rs+5;        params(params_index.sigma_ze,1)        = 0.2;  params_fixed(params_index.sigma_ze,1) = 1;  
trspec(params_index.sigma_ze,:) = [2	1E-5	0 1]; bounds(params_index.sigma_ze,:) = [1E-5 50.999];

params_index.sigma_oe_pi14q_pi = rs+6;   params(params_index.sigma_oe_pi14q_pi,1)   = 0.15;   params_fixed(params_index.sigma_oe_pi14q_pi,1) = 1; 
trspec(params_index.sigma_oe_pi14q_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi14q_pi,:) = [1E-5 50.999];

params_index.sigma_oe_pi510Y_pi = rs+7;  params(params_index.sigma_oe_pi510Y_pi,1)   = 0.035;   params_fixed(params_index.sigma_oe_pi510Y_pi,1)  = 0; 
trspec(params_index.sigma_oe_pi510Y_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi510Y_pi,:) = [1E-5 50.999];

params_index.sigma_oe_pi12q_pi = rs+8;     params(params_index.sigma_oe_pi12q_pi,1)     = 0.36;   params_fixed(params_index.sigma_oe_pi12q_pi,1)  = 0;  
trspec(params_index.sigma_oe_pi12q_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi12q_pi,:) = [1E-5 50.999];

params_index.sigma_oe_utr = rs + 9;   params(params_index.sigma_oe_utr,1) = 0.5;  params_fixed(params_index.sigma_oe_utr,1)  = 0; 
trspec(params_index.sigma_oe_utr,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_utr,:) = [1E-5 50.999];

params_index.sigma_oe_utr2 = rs + 10;   params(params_index.sigma_oe_utr2,1) = 0.5;  params_fixed(params_index.sigma_oe_utr2,1)  = 0; 
trspec(params_index.sigma_oe_utr2,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_utr2,:) = [1E-5 50.999];

params_index.sigma_oe_utr3 = rs + 11;   params(params_index.sigma_oe_utr3,1) = 0.5;  params_fixed(params_index.sigma_oe_utr3,1)  = 0; 
trspec(params_index.sigma_oe_utr3,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_utr3,:) = [1E-5 50.999];

params_index.sigma_oe_utr4 = rs + 12;   params(params_index.sigma_oe_utr4,1) = 0.5;  params_fixed(params_index.sigma_oe_utr4,1)  = 0; 
trspec(params_index.sigma_oe_utr4,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_utr4,:) = [1E-5 50.999];

params_index.sigma_oe_utr5 = rs + 13;   params(params_index.sigma_oe_utr5,1) = 0.5;  params_fixed(params_index.sigma_oe_utr5,1)  = 0; 
trspec(params_index.sigma_oe_utr5,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_utr5,:) = [1E-5 50.999];

params_index.theta2 = rs + 14; params(params_index.theta2,1) = 0.5;  params_fixed(params_index.theta2,1)  = 0; 
trspec(params_index.theta2,:) = zeros(1,4); bounds(params_index.theta2,:) = [-50.999 50.999];

params_index.theta3 = rs + 15; params(params_index.theta3,1) = 0.5;  params_fixed(params_index.theta3,1)  = 0; 
trspec(params_index.theta3,:) = zeros(1,4); bounds(params_index.theta3,:) = [-50.999 50.999];

params_index.theta4 = rs + 16; params(params_index.theta4,1) = 0.5;  params_fixed(params_index.theta4,1)  = 0; 
trspec(params_index.theta4,:) = zeros(1,4); bounds(params_index.theta4,:) = [-50.999 50.999];

params_index.theta5 = rs + 17; params(params_index.theta5,1) = 0.5;  params_fixed(params_index.theta5,1)  = 0; 
trspec(params_index.theta5,:) = zeros(1,4); bounds(params_index.theta5,:) = [-50.999 50.999];

params_index.gamma_w = rs + 18;      params(params_index.gamma_w,1) = 0.36; params_fixed(params_index.gamma_w,1)  = 0; 
trspec(params_index.gamma_w,:) = [2	1E-5	0 1]; bounds(params_index.gamma_w,:) = [1E-5 50.999];

params_index.rho_utr = rs + 19;      params(params_index.rho_utr,1) = 0.2; params_fixed(params_index.rho_utr,1)  = 0; 
trspec(params_index.rho_utr,:) = zeros(1,4); bounds(params_index.rho_utr,:) = [-50.999 50.999];

params_index.rho_utr2 = rs + 20;      params(params_index.rho_utr2,1) = 0.2; params_fixed(params_index.rho_utr2,1)  = 0; 
trspec(params_index.rho_utr2,:) = zeros(1,4); bounds(params_index.rho_utr2,:) = [-50.999 50.999];

params_index.rho_utr3 = rs + 21;      params(params_index.rho_utr3,1) = 0.2; params_fixed(params_index.rho_utr3,1)  = 0; 
trspec(params_index.rho_utr3,:) = zeros(1,4); bounds(params_index.rho_utr3,:) = [-50.999 50.999];

params_index.rho_utr4 = rs + 22;      params(params_index.rho_utr4,1) = 0.2; params_fixed(params_index.rho_utr4,1)  = 0; 
trspec(params_index.rho_utr4,:) = zeros(1,4); bounds(params_index.rho_utr4,:) = [-50.999 50.999];

params_index.rho_utr5 = rs + 23;      params(params_index.rho_utr5,1) = 0.2; params_fixed(params_index.rho_utr5,1)  = 0; 
trspec(params_index.rho_utr5,:) = zeros(1,4); bounds(params_index.rho_utr5,:) = [-50.999 50.999];

params_index.cov_ax = rs + 24;      params(params_index.cov_ax,1) = 0; params_fixed(params_index.cov_ax,1)  = 1; 
trspec(params_index.cov_ax,:) = zeros(1,4); bounds(params_index.cov_ax,:) = [-50.999 50.999];

end

