

function [Y_main,Y_main_all,vrbs_obs,nobs,trainingSampleLength,Y_pre,startSample,endSample] = getDataLaubach3(~)


%% Loads and prepared data

% get indices for observables
[vrbs_obs,nobs] = defineObservables();

%load DataMat_LaubachFeb2018 utrend
%load Joint_estimationlptauf ubar
load UbarStats ubar_mean
load EXtra2 lrm
%load Wage nomwage
%load Wage15 nomwage
load Wageall nomwage
%load Michexp Mich_exps
ubar_mean = [NaN(length(1948:1/4:1959.75),1);ubar_mean];

load CEGSData_mat_6 Y1

% current sample for the Dataset
full_sample = 1948:1/4:2018.5;

Y_main_all = NaN(nobs+1,length(full_sample));
Y_main_all(vrbs_obs.u,:) = Y1(:,1);
Y_main_all(vrbs_obs.pi,:) = Y1(:,3);
%Y_main_all(vrbs_obs.piw,:) = nomwage;
Y_main_all(vrbs_obs.piw:vrbs_obs.piw5,:) = nomwage';
Y_main_all(vrbs_obs.exp12q_pi,:) = nanmean([Y1(:,7) Y1(:,8)],2); %uncomment for baseline
Y_main_all(vrbs_obs.exp510y_pi,:) = nanmean([Y1(:,9) lrm],2); %uncomment for baseline
Y_main_all(nobs+1,:) = ubar_mean; % last term, not in the observation equation

% Select variables to be used in estimation      
Y_main = Y_main_all;
%Y_main(vrbs_obs.piw2:vrbs_obs.piw5,:) = NaN;
   
% Restrict Sample
startSample = 1960;
endSample = 2018.5;  
sampos = find(full_sample >= startSample & full_sample <= endSample); 
trainingSampleLength = 4;

Y_pre = 0; Y_main = Y_main(:,sampos)'; Y_main_all = Y_main_all(:,sampos)';
 
 