
function [systemMats, lambda] = defineFullModelv1(vrbs,shocks,ModelDim,params,params_index)

% Initialize canonical-form matrices (which we will later populate)
% Note: these matrices include extra entries for the lags, required for
% Reds-Solds. 

[beta, theta_w, sigma, phi_n, b, xi_w, iota_w, gamma_1, iota_p, alpha, theta_p, xi_a, delta, phi_pi,...
    rho_i, phi_x, pi, by_ratio, rho, rho_tau, phi_taul, phi_taux, gamma, gy_ratio, rho_gamma, rho_theta_w, ...
    rho_theta_p, rho_g, rho_xi, rho_pistar, rho_m, rho_mu, rho_tau_hat, rho_b, sigma_gamma, sigma_theta_w, ...
    sigma_theta_p, sigma_g, sigma_xi, sigma_pistar, sigma_m, sigma_mu, sigma_tau_hat, sigma_b, sigma_oe_w, ...
    R, P_m, sy_ratio, R_K, ik_ratio, S, w_r, kN_ratio, yN_ratio, yk_ratio, iy_ratio, ck_ratio, cy_ratio, ...
    wc_ratio, xi_v, xi_vv, tauy_ratio, F_y_ratio, xi_p, xi_I, c_1w, c_2w, c_3w] = getparamsv1(params, params_index);

nvar = ModelDim.nvar;
nshock = ModelDim.nshock;
nlag = ModelDim.nlag;

systemMats.A0=zeros(nvar,nvar);
systemMats.A1=zeros(nvar,nvar);
systemMats.A2=zeros(nvar,nvar);
systemMats.A3=zeros(nvar,nvar);
systemMats.A4=zeros(nvar,nvar);
systemMats.A5=zeros(nvar,nvar);
systemMats.A6=zeros(nvar,nvar);
systemMats.A7=zeros(nvar,nvar);
systemMats.A8=zeros(nvar,nshock);


%% Households
% set number of variables
households.nvar  = 4;
households.nstate= 2;

% assign indices to relevant state variables
households.c       = 1;
households.w_r     = 2;
households.w_r_lag = 3;
households.d       = 4;

households.choice={'c','w_r'};

% delta: variables outside households' control

% delta_C = households.c; delta_w = households.w_r; delta_d = households.d-1; % NOT USED

% Define Psi_0 and Psi_1 matrices
households.Psi_0 = zeros(households.nvar,households.nvar);
households.Psi_1 = zeros(households.nvar,households.nvar);

households.Psi_0(households.c, households.c)            = sigma / (1 - b*gamma^(-1));
households.Psi_0(households.c,households.w_r)           = xi_v * theta_w;
households.Psi_0(households.w_r,households.w_r)         = -xi_w^(-1) * beta*gamma^(1-sigma);
households.Psi_0(households.w_r_lag,households.w_r_lag) = 1;
households.Psi_0(households.d, households.d)            = 1/cy_ratio;

households.Psi_1(households.c, households.c)            = sigma / (1 - b*gamma^(-1));
households.Psi_1(households.c,households.w_r)           = xi_v * theta_w;
households.Psi_1(households.w_r, households.c)          = 1 / (1 - b*gamma^(-1));
households.Psi_1(households.w_r,households.w_r)         = -c_1w;
households.Psi_1(households.w_r,households.w_r_lag)     = xi_w^(-1);
households.Psi_1(households.w_r_lag,households.w_r)     = 1;
households.Psi_1(households.d, households.c)            = -1;
households.Psi_1(households.d, households.w_r)          = wc_ratio  * (1 - theta_w);
households.Psi_1(households.d, households.d)            = beta^(-1) * gamma^(sigma - 1)/cy_ratio;


% get decision rule
[households.Dk, households.Dd1,  households.Dd2,  households.Lambda] = getDecision(households.Psi_0, households.Psi_1, households.nstate);


% Reduce size of households.Dd2 to eliminate the third column corresponding to
% households.w_r_lag

households.Dd2 = households.Dd2(:,[1 2 4]);


households.D_lambda1=households.Dd1*[households.Dd2(1,:);zeros(1,households.nvar-1)];
households.D_lambda2=households.Dd1*[zeros(1,households.nvar-1);households.Dd2(2,:)];
lambda_1=households.Lambda(1,1);
lambda_2=households.Lambda(2,2);


% here we check the coefficient on P_m(t-1) equals zero, as this is not one
% of our state variables

identity_1 = (households.Dk(1,2) - (households.D_lambda1(1,3) + households.D_lambda2(1,3))*beta^(-1)*gamma^(sigma-1)/cy_ratio) * by_ratio;
identity_2 = (households.Dk(2,2) - (households.D_lambda1(2,3) + households.D_lambda2(2,3))*beta^(-1)*gamma^(sigma-1)/cy_ratio) * by_ratio;


if identity_1>1e-10 || identity_2>1e-10 
    error('The coefficient on P_m(t-1) does not equal zero. This is likely caused by some error in the household decision rule you have defined.');
end


for l=1:2 % loop through choice variables
%for l=1:1 % loop through choice variables; TEST: only consumption function 
    
    systemMats.A0(vrbs.(households.choice{l}), vrbs.(households.choice{l})) = 1;
    systemMats.A7(vrbs.(households.choice{l}),vrbs.w_r) = households.Dk(l,1);
    systemMats.A7(vrbs.(households.choice{l}),vrbs.b_m) = households.Dk(l,2)*P_m;
    
    
    for  i = 1:2 % loop through eigenvalues
        
        % get D-matrix and lambda value associated with ith eigenvector
        evalc(['D = households.D_lambda' num2str(i)]);
        evalc(['lambda = lambda_' num2str(i)]);
       
        
        
        
        % Contemporaneous terms
        
        
        %P_C (delta_C)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)        = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)         + D(l,1) * xi_v * theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)          = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)           + D(l,1) * xi_v;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.c)          = systemMats.A0(vrbs.(households.choice{l}), vrbs.c)           - D(l,1) * sigma * b * gamma^(-1) / (1 - b * gamma^(-1)) * (1 - lambda^(-1));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)       - D(l,1) * (sigma * ((1-rho_gamma) / (1 - b * gamma^(-1)) - rho_gamma));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.xi)         = systemMats.A0(vrbs.(households.choice{l}), vrbs.xi)          - D(l,1) * (rho_xi - 1);
        systemMats.A7(vrbs.(households.choice{l}), vrbs.c)          = systemMats.A7(vrbs.(households.choice{l}), vrbs.c)           - D(l,1) * (sigma * b * gamma^(-1) / (1 - b * gamma^(-1)));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.R)          = systemMats.A0(vrbs.(households.choice{l}), vrbs.R)           - D(l,1);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     - D(l,1);
        
        %P_w (delta_w)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)    + D(l,2) * c_3w * theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)      + D(l,2) * c_3w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)     + D(l,2) * (xi_w^(-1) * (1+beta*gamma^(1-sigma)*iota_w) - lambda^(-1) * xi_w^(-1) * iota_w);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)  = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)  + D(l,2) * (c_2w - xi_w^(-1) * beta * gamma^(1-sigma) * rho_gamma - lambda^(-1) * xi_w^(-1) * iota_w);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)= systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)+ D(l,2) * (1/(theta_w-1));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.c)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.c)      + D(l,2) * lambda^(-1) * b * gamma^(-1) / (1-b*gamma^(-1));
        systemMats.A7(vrbs.(households.choice{l}), vrbs.c)      = systemMats.A7(vrbs.(households.choice{l}), vrbs.c)      - D(l,2) * b * gamma^(-1) / (1-b*gamma^(-1));
        systemMats.A7(vrbs.(households.choice{l}), vrbs.pi)     = systemMats.A7(vrbs.(households.choice{l}), vrbs.pi)     + D(l,2) * xi_w ^(-1) * iota_w;
        systemMats.A7(vrbs.(households.choice{l}), vrbs.gamma)  = systemMats.A7(vrbs.(households.choice{l}), vrbs.gamma)  + D(l,2) * xi_w ^(-1) * iota_w;
        
        %P_d (delta_d)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.P_m)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.P_m)   - D(l,3) * beta^(-1) * gamma^(sigma - 1) * by_ratio / cy_ratio*rho*beta*gamma^(-sigma);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)    + D(l,3) * beta^(-1) * gamma^(sigma - 1) * by_ratio / cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) + D(l,3) * beta^(-1) * gamma^(sigma - 1) * by_ratio / cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   - D(l,3) * wc_ratio * theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     - D(l,3) * wc_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.Gamma) = systemMats.A0(vrbs.(households.choice{l}), vrbs.Gamma) - D(l,3)/cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.tau)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.tau)   + D(l,3)/cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1) * by_ratio / cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1) * by_ratio / cy_ratio;

        
        % Discounted forecasts
        
        %P_C (delta_C)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)     + D(l,1)*sigma*b*gamma^(-1)*lambda^(-1)/(1-b*gamma^(-1))*(1-lambda^-1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma) + D(l,1)*lambda^(-1)*sigma*((1-rho_gamma)/(1-b*gamma^(-1)) - rho_gamma);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)    - D(l,1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)   + D(l,1)*xi_v*theta_w*(1-lambda^(-1));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)     + D(l,1)*(1-lambda^(-1))*xi_v;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.xi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.xi)    + D(l,1)*lambda^(-1)*(rho_xi - 1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)     + D(l,1)*lambda^(-1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)     + D(l,1)*lambda^(-1);
        
        %P_w (delta_w)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     - D(l,2)*lambda^(-1)*c_3w*theta_w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       - D(l,2)*lambda^(-1)*c_3w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       - D(l,2)*lambda^(-2)*b*gamma^(-1)/(1-b*gamma^(-1));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      - D(l,2)*(lambda^(-1)*xi_w^(-1)*(1+beta*gamma^(1-sigma)*iota_w) - lambda^(-2)*xi_w^(-1)*iota_w - xi_w^(-1)*beta*gamma^(1-sigma));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   - D(l,2) * (lambda^(-1) * (c_2w - xi_w^(-1)*beta*gamma^(1-sigma)*rho_gamma) - lambda^(-2)*xi_w^(-1)*iota_w);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) - D(l,2) * lambda ^(-1)/(theta_w-1);
        
        %P_d (delta_d)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)     + D(l,3)*lambda^(-2)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)     + D(l,3)*lambda^(-2)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)    - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma) - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)   + D(l,3)*lambda^(-1)*wc_ratio*theta_w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)     + D(l,3) *lambda^(-1)*wc_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.Gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.Gamma) + D(l,3) *lambda^(-1)/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.tau)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.tau)   - D(l,3) *lambda^(-1)/cy_ratio;
        
    end
    
end

%% static wage equation (flex wages): TEST

% systemMats.A0(vrbs.w_r, vrbs.w_r) = c_1w + c_3w*theta_w;
% systemMats.A0(vrbs.w_r, vrbs.N) = c_3w;
% systemMats.A0(vrbs.w_r, vrbs.c) = -1 / (1-b*gamma^(-1));
% systemMats.A7(vrbs.w_r, vrbs.c) = - b*gamma^(-1)/ (1-b*gamma^(-1));




%% Firm's Decision Rule (capital accumulation and investment)
firms=struct;

% set number of variables
firms.nvar  = 3;
firms.nstate= 1;

% assign indices to relevant state variables
firms.i     = 1;
firms.P_k   = 2;
firms.i_lag = 3;

% Define Psi_0 and Psi_1 matrices
firms.Psi_0 = zeros(firms.nvar,firms.nvar);
firms.Psi_1 = zeros(firms.nvar,firms.nvar);

firms.Psi_0(firms.i,firms.i)          = -beta*gamma^(1-sigma);
firms.Psi_0(firms.P_k,firms.P_k)      = beta*gamma^(-sigma)*(1-delta);
firms.Psi_0(firms.i_lag,firms.i_lag)  = 1;

firms.Psi_1(firms.i,firms.i)          = -(1+beta*gamma^(1-sigma));
firms.Psi_1(firms.i,firms.P_k)        = xi_I;
firms.Psi_1(firms.i,firms.i_lag)      = 1;
firms.Psi_1(firms.P_k,firms.P_k)      = 1;
firms.Psi_1(firms.i_lag,firms.i)      = 1;

firms.choice={'i','P_k'};


% get decision rule
[firms.Dk, firms.Dd1, firms.Dd2, firms.Lambda] = getDecision(firms.Psi_0,firms.Psi_1,firms.nstate);


% Reduce size of firms.Dd2 to eliminate the third column corresponding to
% firms.i_lag

firms.Dd2 = firms.Dd2(:,[1 2]);



firms.D_lambda4=firms.Dd1*[firms.Dd2(1,:);zeros(1,firms.nvar-1)];
firms.D_lambda5=firms.Dd1*[zeros(1,firms.nvar-1);firms.Dd2(2,:)];
lambda_4=firms.Lambda(1,1);
lambda_5=firms.Lambda(2,2);

   
for l=1:2 % loop through choice variables
    
    systemMats.A0(vrbs.(firms.choice{l}),vrbs.(firms.choice{l}))=1;
    systemMats.A7(vrbs.(firms.choice{l}),vrbs.i)=firms.Dk(l);
    
    for i= 4:5 % loop through eigenvalues        
        
        % get D-matrix and lambda value associated with ith eigenvector
        evalc(['D=firms.D_lambda' num2str(i)]);
        evalc(['lambda=lambda_' num2str(i)]);
        
        
        %delta_I
        systemMats.A0(vrbs.(firms.choice{l}),vrbs.mu)    = systemMats.A0(vrbs.(firms.choice{l}),vrbs.mu)     - D(l,1)*xi_I;
        systemMats.A0(vrbs.(firms.choice{l}),vrbs.gamma) = systemMats.A0(vrbs.(firms.choice{l}),vrbs.gamma)  - D(l,1)*(beta*gamma^(1-sigma)*rho_gamma-1);
        
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.mu)     = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.mu)    +D(l,1)/lambda*xi_I;
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.gamma)  = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.gamma) +D(l,1)/lambda*(beta*gamma^(1-sigma)*rho_gamma-1);
        
        %delta_K
        systemMats.A0(vrbs.(firms.choice{l}),vrbs.R)  = systemMats.A0(vrbs.(firms.choice{l}),vrbs.R) - D(l,2);
        systemMats.A0(vrbs.(firms.choice{l}),vrbs.b_shock)  = systemMats.A0(vrbs.(firms.choice{l}),vrbs.b_shock) - D(l,2);
        
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R_k) = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R_k) - D(l,2)*(1-beta*gamma^(-sigma)*(1-delta));
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R)   = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R)   + D(l,2)/lambda;
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.b_shock)   = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.b_shock)   + D(l,2)/lambda;
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.pi)  = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.pi)  - D(l,2);
    end
end


%% Bonds decision rule
lambda_6 = 1/(rho*beta*gamma^(-sigma));

systemMats.A0(vrbs.P_m,vrbs.P_m) = systemMats.A0(vrbs.P_m,vrbs.P_m) +1;
systemMats.A0(vrbs.P_m,vrbs.R)   = systemMats.A0(vrbs.P_m,vrbs.R) +1;
systemMats.A0(vrbs.P_m,vrbs.b_shock)   = systemMats.A0(vrbs.P_m,vrbs.b_shock) +1;

systemMats.A6(vrbs.P_m,vrbs.R) = systemMats.A6(vrbs.P_m, vrbs.R) - rho*beta*gamma^(-sigma);
systemMats.A6(vrbs.P_m,vrbs.b_shock) = systemMats.A6(vrbs.P_m, vrbs.b_shock) - rho*beta*gamma^(-sigma);


%% Firm's decision rule (intermediate inputs)

% analytic solution: (we will use this to check that the algorithmic
% solution is correct)
lambda_3 = 1/(gamma_1 * beta * gamma^(1-sigma));

systemMats.A0(vrbs.pi, vrbs.pi)      = 1 + beta * gamma^(1-sigma) * iota_p * (1-gamma_1);
systemMats.A7(vrbs.pi, vrbs.pi)      = iota_p;
systemMats.A0(vrbs.pi, vrbs.w_r)     = - xi_p * (1 - alpha);
systemMats.A0(vrbs.pi, vrbs.R_k)     = - xi_p * alpha;
systemMats.A0(vrbs.pi, vrbs.theta_p) = xi_p/(theta_p - 1);

systemMats.A3(vrbs.pi, vrbs.w_r)     = xi_p*gamma_1*beta*gamma^(1-sigma)*(1-alpha);
systemMats.A3(vrbs.pi, vrbs.R_k)     = xi_p*gamma_1*beta*gamma^(1-sigma)*alpha;
systemMats.A3(vrbs.pi, vrbs.theta_p) = - xi_p*gamma_1*beta*gamma^(1-sigma) /(theta_p - 1);
systemMats.A3(vrbs.pi, vrbs.pi)      = beta*gamma^(1-sigma)*(1-gamma_1)*(1-iota_p*gamma_1*beta*gamma^(1-sigma));

% % algorithmic solution 
% firms_intermediate = struct;
% 
% %set number of variables
% firms_intermediate.nvar   = 2;
% firms_intermediate.nstate = 1;
% 
% %assign indices to relevant state variables
% firms_intermediate.P      = 1;
% firms_intermediate.P_lag  = 2;
% 
% % Define Psi_0 and Psi_1 matrices
% firms_intermediate.Psi_0 = zeros(firms_intermediate.nvar,firms_intermediate.nvar);
% firms_intermediate.Psi_1 = zeros(firms_intermediate.nvar,firms_intermediate.nvar);
% 
% firms_intermediate.Psi_0(firms_intermediate.P,firms_intermediate.P)         = -beta*gamma^(1-sigma);
% firms_intermediate.Psi_0(firms_intermediate.P,firms_intermediate.P_lag)     = 1 + xi_p + beta*gamma^(1-sigma);
% firms_intermediate.Psi_0(firms_intermediate.P_lag,firms_intermediate.P_lag) = 1;
% 
% firms_intermediate.Psi_1(firms_intermediate.P,firms_intermediate.P_lag)     = 1;
% firms_intermediate.Psi_1(firms_intermediate.P_lag,firms_intermediate.P)     = 1;
% 
% % get decision rule
% [firms_intermediate.Dk, firms_intermediate.Dd1, firms_intermediate.Dd2, firms_intermediate.Lambda] = getDecision(firms_intermediate.Psi_0,firms_intermediate.Psi_1,firms.nstate);
% firms_intermediate.D_lambda3=firms_intermediate.Dd1*[firms_intermediate.Dd2(1,:);zeros(1,firms_intermediate.nvar)];
% firms_intermediate.D_lambda3 = firms_intermediate.D_lambda3(1,1);
% lambda_3=firms_intermediate.Lambda(1,1);
% 
% systemMats.A0(vrbs.pi, vrbs.pi) = (1 - iota_p*lambda_3^(-1)+ beta * gamma^(1-sigma)*iota_p);
% systemMats.A7(vrbs.pi, vrbs.pi) = iota_p;
% systemMats.A0(vrbs.pi, vrbs.w_r) =  - xi_p * (1 - alpha);
% systemMats.A0(vrbs.pi, vrbs.R_k) =  - xi_p * alpha;
% systemMats.A0(vrbs.pi, vrbs.theta_p) = xi_p/(theta_p - 1);
% systemMats.A3(vrbs.pi, vrbs.pi) = -((lambda_3^(-1) - iota_p*lambda_3^(-2) - beta * gamma^(1-sigma) + beta*gamma^(1-sigma)*lambda_3^(-1)*iota_p));
% systemMats.A3(vrbs.pi, vrbs.w_r) = xi_p * lambda_3^(-1) * (1 - alpha);
% systemMats.A3(vrbs.pi, vrbs.R_k) = xi_p * lambda_3^(-1) * alpha;
% systemMats.A3(vrbs.pi, vrbs.theta_p) = -xi_p * lambda_3^(-1)/(theta_p - 1);

%% Static Equilibrium Conditions %%

%% N - Jump
systemMats.A0(vrbs.N, vrbs.R_k) = -(1 + F_y_ratio) * alpha * xi_a^(-1);
systemMats.A7(vrbs.N, vrbs.k) = (1 + F_y_ratio) * alpha;
systemMats.A0(vrbs.N, vrbs.gamma) = (1 + F_y_ratio) * alpha;
systemMats.A0(vrbs.N, vrbs.N) = -(1 + F_y_ratio)*(1-alpha);
systemMats.A0(vrbs.N, vrbs.y) = 1;

%% R - State
systemMats.A0(vrbs.R,vrbs.R) = 1;
systemMats.A7(vrbs.R,vrbs.R) = rho_i;
systemMats.A0(vrbs.R,vrbs.pistar) = -(1-rho_i)*(1-phi_pi);
systemMats.A0(vrbs.R,vrbs.pi) = -(1-rho_i)*phi_pi;
systemMats.A0(vrbs.R,vrbs.c) = -(1-rho_i)*phi_x*cy_ratio;
systemMats.A0(vrbs.R,vrbs.i) = -(1-rho_i)*phi_x*iy_ratio;
systemMats.A0(vrbs.R,vrbs.g) = -(1-rho_i)*phi_x*gy_ratio;
systemMats.A7(vrbs.R,vrbs.c) = -(1-rho_i)*phi_x*cy_ratio;
systemMats.A7(vrbs.R,vrbs.i) = -(1-rho_i)*phi_x*iy_ratio;
systemMats.A7(vrbs.R,vrbs.g) = -(1-rho_i)*phi_x*gy_ratio;
systemMats.A0(vrbs.R,vrbs.gamma) = -(1-rho_i)*phi_x;
systemMats.A0(vrbs.R,vrbs.m) = -1;

%% tau - State
systemMats.A0(vrbs.tau,vrbs.tau) = 1;
systemMats.A7(vrbs.tau,vrbs.tau) = rho_tau;
systemMats.A7(vrbs.tau,vrbs.b_m) = (1-rho_tau)*phi_taul*(1+rho*P_m);
systemMats.A0(vrbs.tau,vrbs.P_m) = -(1-rho_tau)*phi_taul*rho*by_ratio;
systemMats.A0(vrbs.tau,vrbs.c) = -(1-rho_tau)*phi_taux*cy_ratio;
systemMats.A0(vrbs.tau,vrbs.i) = -(1-rho_tau)*phi_taux*iy_ratio;
systemMats.A0(vrbs.tau,vrbs.g) = -(1-rho_tau)*phi_taux*gy_ratio;
systemMats.A7(vrbs.tau,vrbs.c) = -(1-rho_tau)*phi_taux*cy_ratio;
systemMats.A7(vrbs.tau,vrbs.i) = -(1-rho_tau)*phi_taux*iy_ratio;
systemMats.A7(vrbs.tau,vrbs.g) = -(1-rho_tau)*phi_taux*gy_ratio;
systemMats.A0(vrbs.tau,vrbs.gamma) = -(1-rho_tau)*phi_taux;
systemMats.A0(vrbs.tau,vrbs.tau_shock) = -1;

%% R_k - Jump
systemMats.A0(vrbs.R_k, vrbs.R_k) = (xi_a^(-1) + 1);
systemMats.A7(vrbs.R_k, vrbs.k) = -1;
systemMats.A0(vrbs.R_k, vrbs.N) = -1;
systemMats.A0(vrbs.R_k, vrbs.gamma) = -1;
systemMats.A0(vrbs.R_k, vrbs.w_r) = -1;

%% Gamma - Jump
systemMats.A0(vrbs.Gamma, vrbs.Gamma) = 1;
systemMats.A0(vrbs.Gamma, vrbs.y) = -1;
systemMats.A0(vrbs.Gamma, vrbs.N) =   cy_ratio*wc_ratio;
systemMats.A0(vrbs.Gamma, vrbs.w_r) = cy_ratio*wc_ratio;
systemMats.A0(vrbs.Gamma, vrbs.R_k) = R_K*gamma^-1/yk_ratio/xi_a;
systemMats.A0(vrbs.Gamma, vrbs.i)   = ik_ratio / yk_ratio;

%% b_m - State
systemMats.A0(vrbs.b_m, vrbs.b_m) = P_m;
systemMats.A7(vrbs.b_m, vrbs.b_m) = beta^(-1)*gamma^(sigma - 1)*P_m;
systemMats.A0(vrbs.b_m, vrbs.pi) = beta^(-1)*gamma^(sigma - 1)*by_ratio;
systemMats.A0(vrbs.b_m, vrbs.gamma) = beta^(-1)*gamma^(sigma - 1)*by_ratio;
systemMats.A0(vrbs.b_m, vrbs.P_m) = -(rho/gamma - 1)*by_ratio;
systemMats.A0(vrbs.b_m, vrbs.tau) = 1;
systemMats.A0(vrbs.b_m, vrbs.g) = -gy_ratio;

%% k - State
systemMats.A0(vrbs.k,vrbs.k)=1;
systemMats.A7(vrbs.k,vrbs.k)=(1-delta)*gamma^(-1);
systemMats.A0(vrbs.k,vrbs.gamma)=(1-delta)*gamma^(-1);
systemMats.A0(vrbs.k,vrbs.mu)=-ik_ratio;
systemMats.A0(vrbs.k,vrbs.i)=-ik_ratio;

%% y - Jump
systemMats.A0(vrbs.y, vrbs.y) = 1;
systemMats.A0(vrbs.y, vrbs.c) = -cy_ratio;
systemMats.A0(vrbs.y, vrbs.i) = -iy_ratio;
systemMats.A0(vrbs.y, vrbs.g) = -gy_ratio;
systemMats.A0(vrbs.y, vrbs.R_k) = -R_K * gamma^(-1) / yk_ratio * xi_a^(-1);

%% SHOCKS %%

%% TFP shock
systemMats.A0(vrbs.gamma,vrbs.gamma)=1;
systemMats.A7(vrbs.gamma,vrbs.gamma)=rho_gamma;
systemMats.A8(vrbs.gamma,shocks.gamma)=sigma_gamma;

%% labor supply shock
systemMats.A0(vrbs.theta_w,vrbs.theta_w)=1;
systemMats.A7(vrbs.theta_w,vrbs.theta_w)=rho_theta_w;
systemMats.A8(vrbs.theta_w,shocks.theta_w)=sigma_theta_w;

%% Investment shock
systemMats.A0(vrbs.mu,vrbs.mu)=1;
systemMats.A7(vrbs.mu,vrbs.mu)=rho_mu;
systemMats.A8(vrbs.mu,shocks.mu)=sigma_mu;

%% government spending shock
systemMats.A0(vrbs.g,vrbs.g)=1;
systemMats.A7(vrbs.g,vrbs.g)=rho_g;
systemMats.A8(vrbs.g,shocks.g)=sigma_g;

%% preferences shock
systemMats.A0(vrbs.xi,vrbs.xi)=1;
systemMats.A7(vrbs.xi,vrbs.xi)=rho_xi;
systemMats.A8(vrbs.xi,shocks.xi)=sigma_xi;

%% Inflation target shock
systemMats.A0(vrbs.pistar,vrbs.pistar)=1;
systemMats.A7(vrbs.pistar,vrbs.pistar)=rho_pistar;
systemMats.A8(vrbs.pistar,shocks.pistar)=sigma_pistar;

%% cost-push shock
systemMats.A0(vrbs.theta_p,vrbs.theta_p)=1;
systemMats.A7(vrbs.theta_p,vrbs.theta_p)=rho_theta_p;
systemMats.A8(vrbs.theta_p,shocks.theta_p)=sigma_theta_p;

%% policy shock
systemMats.A0(vrbs.m,vrbs.m)=1;
systemMats.A7(vrbs.m,vrbs.m)=rho_m;
systemMats.A8(vrbs.m,shocks.m)=sigma_m;

%% tax shock
systemMats.A0(vrbs.tau_shock,vrbs.tau_shock)=1;
systemMats.A7(vrbs.tau_shock,vrbs.tau_shock)=rho_tau_hat;
systemMats.A8(vrbs.tau_shock,shocks.tau)=sigma_tau_hat;

%% B shock
systemMats.A0(vrbs.b_shock,vrbs.b_shock)=1;
systemMats.A7(vrbs.b_shock,vrbs.b_shock)=rho_b;
systemMats.A8(vrbs.b_shock,shocks.b)=sigma_b;

%% Remove lag variables as states (they are not necessary)
if nlag>0
    remove_inds=nvar-nlag+1:nvar;
end

systemMats.A0(remove_inds,:)=[];systemMats.A0(:,remove_inds)=[];
systemMats.A1(remove_inds,:)=[];systemMats.A1(:,remove_inds)=[];
systemMats.A2(remove_inds,:)=[];systemMats.A2(:,remove_inds)=[];
systemMats.A3(remove_inds,:)=[];systemMats.A3(:,remove_inds)=[];
systemMats.A4(remove_inds,:)=[];systemMats.A4(:,remove_inds)=[];
systemMats.A5(remove_inds,:)=[];systemMats.A5(:,remove_inds)=[];
systemMats.A6(remove_inds,:)=[];systemMats.A6(:,remove_inds)=[];
systemMats.A7(remove_inds,:)=[];systemMats.A7(:,remove_inds)=[];
systemMats.A8(remove_inds,:)=[];

% save 6 discount factors as one vector
lambda=[lambda_1 lambda_2 lambda_3 lambda_4 lambda_5 lambda_6];


