
 clear; %close all;
%function [Results] = Main_estimation(iter)
%iter = 5;
% Only if used as a function

% Initialize random number for this session

s = RandStream('mt19937ar','Seed','shuffle');
          RandStream.setGlobalStream(s);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Options and Settings                                                %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Specs: choose Model
% Note: each model is defined as a set of model-specific functions stored
%       in the folder "Modelspecs".

% Model name list (so far):
% BGG: model with financial frictions
% SW: Smets and Wouters 2007
% SWSp: SW + spreads
% mySW: Smets and Wouters no real rigidities
% mySWLearn: add learning


 Mspec = 'Laubach3'; % foundations revision
% Mspec = 'BGGTS';      % Term structure paper

learning = 0; % Set zero to use RE model
type = NaN;
trend = 1; % set == 2 for linear trend in f; 
           % set == 1 for mean of f;

% Session: using saved results?
newfilename = 1; % set 1 for you are not using any save data 
                  savenew = 0; % set if newfilename == 1
                 % 1. Baseline
                     
                 % 2. Baseline (trend est with flat priors)
                     %timestamp = '01-Feb-2019_0136'; % diff prior+est rho_u 
                 % 2b Baseline with zero indexation
                   %  timestamp = '21-Feb-2019_0159'; %59 is the copy wirh discarted copies
                   %  timestamp = '22-Feb-2019_1144'; % estimating wage mean
                  %timestamp = '25-Feb-2019_0040'; % estimating wage mean
                  timestamp = '25-Feb-2019_0049'; % estimating wage mean
                 % 4. No trend; no expectations
                 
                 % 3. No expectations
                                  % Saving/loading specs: file names
                  filetag = []; 
                  %filetag = ['_', num2str(iter)]; %used for multiple rounds of Lik maximization 
 % NOTE: this needs to change. fileteg can be redifined as:
 %       filetag = [filetag,'_', num2str(iter)]; is boundle ==1
 %       then EstimationName is (re-)defined down in the code.
                  name = Mspec;
                  %cmts = ['survey_BKS'];%['Freesigpi','L',num2str(learning),'']; 
                  cmts = ['survey'];%['Freesigpi','L',num2str(learning),'']; 
                 % Note: used for the Nocapital spec
                 %cmts = ['TestLoosepriorsGapsince1983',''];
                 
                 EstimationName = [name,cmts,filetag]; 
                  % Note: filename is given by [timestamp,EstimationName].
   

% Operations 

Printpriors = 0; % displays and print priors

Showparams = 1; % displays paramteres names and values on screen
                % Note: shows calibrated params or the mode if results were
                % saved
%545
Mode = 0;
    iter = 2; % comment if used for multiple rounds of Lik maximization 
    n_ests = 3;
    randomize = 1; % random initial conditions
    use_previous = 0; % use previous estimate. Need to give a filename
        previous_estimate_name = ['04-Jan-2019_2232Laubach2survey'];

Gibbs = 0;

MPlots = 1;


Mode_boundle = 0; % This boundles modes from different cluster runs and picks the highest        
     SavedResults = '10-Jul-2017_1738Laubachnosurvey_'; % files' name
     nmats = 100; % number of cluster runs

Hessian = 0;

Metropolis = 0;
    useCovdraws = 0;
    csquare_proposed = 0.60;%base:0.5; %old %0.13;%0.15;%0.35;%0.25; % leave empty if using csquare associated to 
                             %  saved empirical covariance of draws
    ndraws = 150000;
    finetune = 0; % finetune csquare
    

    Printposteriors = 0; % Print posterior distributions and compares with priors

PosteriorsTable = 0; % XX To be added

% Stats and Preds
    
Stats = 0;
    groupShock = 0; % Select if you want to group shocks or use individual (nonzero) shocks
                    % Note: these are model-sepcifics and set in 'SelectVariablesGroups' file
                    %       in ModelSpecs folder.                    
    Mode_onlyStats = 1;
    ImpResp = 0;
        ImpHor = 100;
    VarDec = 1;
         nsim = 101; % total forecast horizons for conditional variance
         list_periods = [1,2,4,8,15,25,35,40,100]; % identify the fct horizons to be plotted/in Tables. 
         CondVarFigs = 1;
         UncVarianceTable = 0;  % XX To be added
         CondVarianceTable = 0; % XX To be added
         HPVarianceTable = 0;   % XX To be added

        
Preds = 0;
    groupShock = 0; % Select if you want to group shocks or use individual (nonzero) shocks
                    % Note: these are model-sepcifics and set in 'SelectVariablesGroups' file
                    %       in ModelSpecs folder.                    
    Mode_onlyPreds = 0;
          ShockDec = 0;
          ShockDecFigs = 0;
    CarterKohn = 1;
          PredsFigs = 0; % XX To be added
          
          
Stability  = 0; % only used for the "foundations" revision


    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Set up and add paths
addpath Model Priors IRFs Estimation VarDecShockDec FiltersSmoothers Temp_files...
        
cpath = pwd;
if isunix, pathslash = '/'; else pathslash = '\'; end
 ind = strfind(cpath, 'Code');
 spath = [cpath(1,1:ind-1),'Save', pathslash];
 dpath = [cpath(1,1:ind-1),'Data', pathslash,'Data_',Mspec, pathslash];
 Modelspecpath = [cpath,pathslash,'Modelspecs',pathslash];
 
 AddModel = [Modelspecpath,Mspec,'files'];
 
 addpath(AddModel);
 
 % add Data to datapath
 Dataadd = dpath(1:end-1);
 addpath(Dataadd);    
    
 
 %Saved results 
 
if newfilename 
timestamp_raw = datestr(now); 
timestamp = [timestamp_raw(1:11) '_' timestamp_raw(13:14), timestamp_raw(16:17)];


 % Import data
[Y_main,Y_main_all,vrbs_obs,nobs,trainingSampleLength,Y_pre,startSample,endSample] = eval(['getData',Mspec,'(trend)']);


%% Define model variables and parameters

[vrbs, shocks,shocks_oe, ModelDim] = eval(['defineVariables',Mspec,'()']);


Sml.vrbsL = vrbs;

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % This is specific for this model
% % Create selection matrix to compute forecasts the observation equation
% ftil_select = [S.vrbsL.x,S.vrbsL.x_L1,S.vrbsL.pi,S.vrbsL.pi_L1,S.vrbsL.pi_L2,S.vrbsL.pi_L3,S.vrbsL.pist];
% fum_select = [S.vrbsL.x;S.vrbsL.x_L1;S.vrbsL.ustar;S.vrbsL.utrend;S.vrbsL.g];
% 
% Sf = zeros(length(ftil_select),ModelDim.nvar);
% Sm = zeros(length(fum_select),ModelDim.nvar);
% 
% 
% F_til = F(ftil_select,ftil_select);
% F_um = F(fum_select,fum_select);





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 





% Add nobs to model dim structure
 
 ModelDim.nobs = nobs;

 
% set parameters values
[params, params_index, params_fixed,trspec,bounds] = eval(['setParams',Mspec,'(learning)']);



% get parameters to be estimated
[params_estimated_index, params_estimated] = setEstimatedParamsv1(params, params_index, params_fixed);

% get priors
priors = eval(['definePriors',Mspec,'(params_fixed, params_index)']);

if savenew
    
save([spath,'Mode',pathslash,[timestamp, EstimationName]],...
     'Y_main','Y_main_all','Y_pre','vrbs_obs','trainingSampleLength','vrbs',  'shocks','shocks_oe', 'ModelDim',...
     'Sml','params', 'params_index', 'params_fixed','trspec','bounds',...
     'params_estimated_index', 'params_estimated',...
     'priors');
end 


else % newfilename
    
% Loads all results available for this run    
% Note: if you re-run estimation and predictions results will be
% overwwritten

load([spath,'Mode',pathslash,[timestamp, EstimationName]]);


end % closes newfilename loop


%%%%%%%%%%%%%%%%%%%% RUN CODE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if Printpriors
    
    testPriors(priors);
    
end   


if Showparams
    
    try
     
    if exist('xmode','var')
        
     params(params_estimated_index) = xmode;
    
    else
        
    disp('no estimates found: show parameters in setparams file');
    
    end
    
    
    ShowParams(params,params_index);
    
    
    catch ME
    
    disp('Problem!: Parameters not found');    
        
    end
    
end    

% Find mode

if Mode

findMode; % XX might want to re-run the function if opt did not converge (like DSGE)

end


if Mode_boundle
    
findMode_bundle
    
end    

if Gibbs
Compute_Gibbs2       
end    

if MPlots
Make_Plots
CreateTableWages
end

if Hessian
   
ComputeHessian;
   
end


if Metropolis

ComputeMetropolis

end


if Stats
 
    Compute_statsv1
    
end    


if Preds
   
Compute_Preds    

end    


if Printposteriors
    
 PrintPosteriorsDist
 
end   


if Stability

mainStab
% TEMP
%  params(params_estimated_index) = xmode;
%  
%  
%  % Choose parameters
%  
%  params(params_index.by_ratio) = 4*2.5;
%   %params(params_index.sigma) = 4;
%  % params(params_index.b) = 0;
%   params(params_index.xi_wT) = 0.75;
% %   params(params_index.iota_w) = 0;
% %   params(params_index.iota_p) = 0;
%  params(params_index.phi_pi) = 1.73;
% % params(params_index.rho_i) = 0;
%  params(params_index.phi_x) = 0;
%  params(params_index.rho) = 0.97;
% % params(params_index.gammaT) = 0; 
%     
%     c_gain.cgain = params(params_index.k_g) ;
%     
%     c_gain.cgainEstab = 0;
% [max_eig,eig_vec_0,eig_vec_c,flag_solve] = solveModel_stab(Mspec,params,params_index,vrbs,shocks,ModelDim,type,learning,Sml,c_gain);

    
end
