% function kalman_smoother.m performs the Kalman smoothing given the
% estimated states and their variances delivered by the Kalman filter

function [xi_smoothed,P_smoothed] = kalman_smoother(F_mat, xi_TT_out,P_TT_out,xi_TL_out,P_TL_out)



% Kalman smoother recursions (following Hamilton 1994, pp. 394-397)
T = size(xi_TT_out,2);
ny = size(xi_TT_out,1);
xi_smoothed = NaN(ny,T);
P_smoothed = NaN(ny,ny,T);

xi_smoothed(:,T) = xi_TT_out(:,T);
P_smoothed(:,:,T) = P_TT_out(:,:,T);

for t = T-1:-1:1
    
    
    %%%%%%%%
    [u,s,v] = svd(P_TL_out(:,:,t));

md = min(size(s));
    bigev = find(diag(s(1:md,1:md))>1e-6);
    sigpropdim = length(bigev);

% sigproplndet = 0;

for i = 1:md
    if i > sigpropdim
        s(i,i) = 0;
    else
        s(i,i)    = 1/s(i,i);
%         sigproplndet = sigproplndet+log(s(i,i));
    end
end

invP_TL_out = v*s*u';

    
    %%%%%%%
    
    
  %  J(:,:,t) = P_TT_out(:,:,t)*F_mat'*pinv(P_TL_out(:,:,t));
    J(:,:,t) = P_TT_out(:,:,t)*F_mat'*invP_TL_out;
    
    xi_smoothed(:,t) = xi_TT_out(:,t) + J(:,:,t)*(xi_smoothed(:,t+1)-xi_TL_out(:,t));
    
    P_smoothed(:,:,t) = P_TT_out(:,:,t) + J(:,:,t)*(P_smoothed(:,:,t+1)-P_TL_out(:,:,t));
   
end;


