

%% Carter and Kohn

X_draws = X_draws(:,discard+1:end);

ndraws = size(X_draws,2);

drawsel = randperm(ndraws-discard);

n_draws_swl = 1000;

xi_TT_mat = NaN(k,T,min(n_draws_swl,ndraws));

ypredB_mat = NaN(vrbs_obsB.n_obsvables,T,min(n_draws_swl,ndraws));

ypred_BNOobserrB = NaN(vrbs_obsB.n_obsvables,T,min(n_draws_swl,ndraws));


% Run Kalman filter given the initial distribution
for d = 1:min(1000,ndraws),

    d
    draw = drawsel(d);
    
    
% Parameters  
    
    x = X_draws(:,draw);


 paramB = EstparamB_fun(x,vrbsB,paramest,MShokB,SIM_regB);   
  
  
% State space

  VCV_eps = paramB.VCV_eps;
  
   [FB,QB,ScB] = State_SpaceRE(vrbsB,paramB,MShokB,VCV_eps);
 
    
% Compute observation equation
 
  [HB,H_NOobserrB,mucB,RB,~] = H_CPI_fun(paramB,SIM_regB,vrbs_obsB,vrbsB);

 
% Initialization of Kalman filter
  
    [xi_0B,P_0B,kiniB] = KF_initializeB_fun(paramB,vrbsB,vrbs_obsB,Y_data_iniB,FB,QB);

 
    
       [~,xi_TT_out,P_TT_out,~,~] = ...
   Likelihood_preds(xi_0B,P_0B,HB,RB,mucB,FB,QB,Y_dataB,sample_sizeB,traning_sampleB,0); 

 

    xi_TT = xi_TT_out(:,end);
    
    P_TT = P_TT_out(:,:,end);        

    % Draw from N(F_TT,P_TT)
   % xi_TT_draw = mvnrnd(xi_TT,P_TT);
   
[U,D,V] = svd(P_TT);

xi_TT_draw = xi_TT + U*sqrt(D)*V'*randn(size(FB,2),1);
    
% Draw from p(F_T|Y_T,params) according to Carter and Kohn('94)
    % Iterate backwards to obtain F_tt and P_tt for t = T-1 to 1, save F's
    % and P's for all steps, then draw from these to obtain F_t's
    % Case of singular Q (see Kim & Nelson pp 195-196)
    
    xi_t = zeros(k,T);
    
    xi_t(:,end) = xi_TT_draw;
    
    for t = T-1:-1:1,
        
        xi_tt = xi_TT_out(:,t);
        
        P_tt = P_TT_out(:,:,t);
        
        P_star_inv = pinv(FB*P_tt*FB' + QB); %CHANGE THIS!!
        
        xi_ttxitplus1 = xi_tt + P_tt*FB'*P_star_inv*(xi_t(1:k,t+1) - FB*xi_tt);     
        
        P_ttPtplus1 = P_tt - P_tt*FB'*P_star_inv*FB*P_tt;     
        
        %xi_t(:,t) = mvnrnd(xi_ttxitplus1,P_ttPtplus1)';
        
        [U2,D2,V2] = svd(P_ttPtplus1);

         xi_t(:,t) = (xi_ttxitplus1 + U2*sqrt(D2)*V2'*randn(size(FB,2),1));
        
        
    end;
    
    xi_TT_mat(:,:,d) = xi_t;
    
    mucB_mat =  repmat(mucB,1,size(xi_TT_out,2));

   ypred_BNOobserrB(:,:,d) = mucB_mat + H_NOobserrB'*xi_t;

   ypredB_mat(:,:,d) = mucB_mat + HB'*xi_t;
    
 
end % for draw = 1:100
 
