
% COMPUTE FILTERED STATE AND SHOCK DECOMPOSITION




if Mode_onlyPreds
    
    if (exist('xmode','var'))
        
        
        %% Computes smoothed predictions
        
       
        params(params_estimated_index) = xmode;
        
        
        [Lik,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat,F_til,Sc_til,Q_til,Hm_til,F,Sc,Hm,M,R] = Ext_KalmanFilter(Mspec,params,params_index,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,type,learning,Sml,Y_main,trainingSampleLength);
        
        
        % Smoother
        
        [xi_TT_mat,~] = kalman_smoother(F_til, xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat);
        
        
        % De-meaned data (reproduced)
        
        DmY = Hm_til'*xi_TT_mat + M*Y_main(:,end)';
        
        
        
        % Extract filtered shocks
        
        Filtered_shocks = xi_TT_mat(size(F_til,1) - ModelDim.nshock + 1:end,:);
        
        % Initial state
        
        Initial_state = xi_TT_mat(1:size(F_til,1) - ModelDim.nshock,1);
        
        
        % Save (for plotting/counterfactuals)

        save([spath,...
            'Mode',pathslash,...
            [timestamp, EstimationName]],'xi_TT_mat','Filtered_shocks','Initial_state','-append');
                                                                      
        if ShockDec
            
        %% Compute shock decomposition (Mode only)
        
        % Select observables and states for plots/tables
        [namesVrbs_obs,namesVrbs,nonzeroshocklist,Group,groupNames] = eval(['SelectVarsGroupShocks',Mspec,'()']);
        
        [list_vrbs_obs,list_vrbs,Shock_groups,namesVrbs_obs,namesVrbs,nonzeroshock_ind,groupNames] = ...
            DefineListsGroupsShocks(Sml.vrbsL,vrbs_obs,shocks,namesVrbs_obs,namesVrbs,nonzeroshocklist,Group,groupNames,groupShock);
        
        [statesDec_mat, obsDec_mat] = ShockDec_fun1(Filtered_shocks,Initial_state,ModelDim.nshock,F,Sc,Hm,Shock_groups);
        
        if ShockDecFigs
        plotShocks1( statesDec_mat , obsDec_mat,DmY , xi_TT_mat,list_vrbs_obs,list_vrbs,namesVrbs_obs,namesVrbs,groupNames);
        end
        
        end
        
    else
        
        disp('Preds: xmode not found'); return
        
    end % ends if exists mode
    
    
else % Uses posterior distribution
    
    % Run Carter and Khon
    if (exist('X_select_draws','var'))
    
    [xi_TT_matCk,ypred_matCk] = CarterKohnv3(Mspec,params,params_index,params_estimated_index,vrbs,vrbs_obs,shocks,shocks_oe,...
                                ModelDim,type,learning,Sml,Y_main,trainingSampleLength,X_select_draws);    
    
%     % Extract filtered shocks
%         
%         Filtered_shocksCk = xi_TT_matCk(size(F_til,1) - ModelDim.nshock + 1:end,:,:);
%         
%         % Initial state
%         
%         Initial_stateCk = xi_TT_mat(1:size(F_til,1) - ModelDim.nshock,1,:);                        
                            
%     save([spath,...
%             'Mode',pathslash,...
%             [timestamp, EstimationName]],'xi_TT_matCk','ypred_matCk','Filtered_shocksCk','Initial_stateCk','-append');
%    
    save([spath,...
            'Mode',pathslash,...
            [timestamp, EstimationName]],'xi_TT_matCk','ypred_matCk','-append');

        
    else
       disp('Carter and Kohn: Selected posterior draws not found'); return 
    end
    
    
    
end  % ends onlyPreds



