function [T_Z_updated, T_epsilon_updated] = extendStateSpace(T_0, T_Z, T_epsilon,S,K,nlearn)

% This function creates extended state space matrix
% get all variables (excluding lagged variables)
nvar = size(T_0, 1);
ndrift = size(S.Som,2);
nferr = size(S.Sz,1);




T_Z_updated = [T_Z                        T_0*S.Som           T_0*S.Som*K           
    zeros(ndrift, nvar)                 eye(ndrift)            K
    zeros(nferr, nvar)         S.Sz*(T_0 - eye(nvar))*S.Som  S.Sz*(T_0 - eye(nvar))*S.Som*K];

T_epsilon_updated = [T_epsilon; zeros(ndrift, size(T_epsilon, 2)); S.Sz*T_epsilon] ;

