         
function [X_draws,xi_TT_matCk,ypred_matCk,Logpost_draw,accept,accept_var,p_acc,p_acc_var] = ...
                    Gibbs_draw2(sigscale,x,csquare,MH_select,CF_select,...
                    Mspec,priors,PriorsCF,params,params_index,params_estimated_index,...
                    bounds,trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml, type,learning,Y_main,Y_pre,trainingSampleLength)
%% Main Gibbs
 
 % State Space
params(params_estimated_index) = x; npara = length(x(MH_select));
X_draws = x;
 
KFold = Obj_fun_postMH(x,priors,0,Mspec,params,params_index,params_estimated_index,...
                                      trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml,type,learning,Y_main,Y_pre,trainingSampleLength);
logpost_old = KFold.OBJ;
xi_0 = KFold.xi_0; P_0 = KFold.P_0; sel_stat = KFold.sel_stat;
P0sr_stat_old = KFold.P0sr_stat_mew;
  
                                  
T = size(Y_main,1);

% Insert x0 in th inputs here
% MH Step                                  
outside_bounds = 1;
      
   while outside_bounds                                 


 X_draws(MH_select) = x(MH_select) + csquare*(sigscale*randn(npara,1));  
  
%  keyboard
    % parameters' bounds
boundsflag = sum(X_draws > bounds(params_estimated_index,2)) + ...
             sum(X_draws < bounds(params_estimated_index,1));
 

% Computes posterior
if boundsflag == 0
KFnew = Obj_fun_postMH(X_draws,priors,0,Mspec,params,params_index,params_estimated_index,...
                                      trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml,type,learning,Y_main,Y_pre,trainingSampleLength);
logpost_new = KFnew.OBJ;
P0sr_stat_new = KFnew.P0sr_stat_mew; 

else       
 logpost_new = -10e20;    
end 


% Check boundaries                                   
  if logpost_new > -10e10 && boundsflag == 0          
            outside_bounds = 0;      
  else          
            outside_bounds = 1;
  end

   end %while loop
  
p_acc = min(1,exp(logpost_new-logpost_old));
accept = binornd(1,p_acc); 

    if ~accept        
     X_draws(MH_select) = x(MH_select);  
     Logpost_draw = logpost_old;
     KF = KFold;
     
    else
     Logpost_draw = logpost_new;
     P0sr_stat_old = P0sr_stat_new;
     KF = KFnew;
    end

% Smoother
[xi_TT_matCk,xiS_0,ypred_matCk] = CarterKohnvLW(Mspec,params,params_index,params_estimated_index,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,type,learning,Sml,Y_main,trainingSampleLength,X_draws,KF);

 xtdraw = [xiS_0(vrbs.x); xi_TT_matCk(vrbs.x,:)'];
 xtdrawL = [xiS_0(vrbs.x_L); xi_TT_matCk(vrbs.x_L,:)'];
 
 mutdraw = [xiS_0(vrbs.mu);xi_TT_matCk(vrbs.mu,:)'];
 
 % NOTE: X_draws(1,2) corrspond to ax1,ax2 (check the order is correct)
 S = (xtdraw(2:end) - X_draws(1)*xtdraw(1:end-1)- X_draws(2)*xtdrawL(1:end-1))'*...
     (xtdraw(2:end) - X_draws(1)*xtdraw(1:end-1)- X_draws(2)*xtdrawL(1:end-1)) + PriorsCF.Psix;  
 sig_x = iwishrnd(S,PriorsCF.df_x + T);
 
 % NOTE: X_draws(6) corrsponds to rho_ze (check the order is correct)
 S = (mutdraw(2:end) - X_draws(6)*mutdraw(1:end-1))'*(mutdraw(2:end) - X_draws(6)*mutdraw(1:end-1)) + PriorsCF.Psimu;  
 sig_mu = iwishrnd(S,PriorsCF.df_mu + T);
 
 % In this version we sample jointly the residuals from xt and mut
 
 
 S = diff(xi_TT_matCk(vrbs.pistar,:)')'*diff(xi_TT_matCk(vrbs.pistar,:)') + PriorsCF.SC0pist;
 sig_pist = iwishrnd(S,PriorsCF.df0pist + T);
 
 S = (xi_TT_matCk(vrbs.oe_pi12q_pi,:)')'*xi_TT_matCk(vrbs.oe_pi12q_pi,:)' + PriorsCF.SC0oe_pi12q_pi;
 sig_oe_pi12q_pi = iwishrnd(S,PriorsCF.df0oe_pi12q_pi + T);
 
 S = (xi_TT_matCk(vrbs.oe_pi510Y_pi,:)')'*xi_TT_matCk(vrbs.oe_pi510Y_pi,:)' + PriorsCF.SC0oe_pi510Y_pi;
 sig_oe_pi510Y_pi = iwishrnd(S,PriorsCF.df0oe_pi510Y_pi + T);

 % In this version we sample the measurement error from a VAR

 [rho_utr,sig_oe_utr] = BVARs(xi_TT_matCk(vrbs.oe_utr,:)', 1, 0, PriorsCF.PSIutr,PriorsCF.df_utr, PriorsCF.lambdautr,1, 1); 
 [rho_utr2,sig_oe_utr2] = BVARs(xi_TT_matCk(vrbs.oe_utr2,:)', 1, 0, PriorsCF.PSIutr,PriorsCF.df_utr, PriorsCF.lambdautr,1, 1); 
 [rho_utr3,sig_oe_utr3] = BVARs(xi_TT_matCk(vrbs.oe_utr3,:)', 1, 0, PriorsCF.PSIutr,PriorsCF.df_utr, PriorsCF.lambdautr,1, 1); 
 [rho_utr4,sig_oe_utr4] = BVARs(xi_TT_matCk(vrbs.oe_utr4,:)', 1, 0, PriorsCF.PSIutr,PriorsCF.df_utr, PriorsCF.lambdautr,1, 1); 
 [rho_utr5,sig_oe_utr5] = BVARs(xi_TT_matCk(vrbs.oe_utr5,:)', 1, 0, PriorsCF.PSIutr,PriorsCF.df_utr, PriorsCF.lambdautr,1, 1); 


% Selected params
% All wages
std_vec = [sqrt(sig_x), sqrt(sig_mu), sqrt(sig_pist),sqrt(sig_oe_pi510Y_pi),sqrt(sig_oe_pi12q_pi),sqrt(sig_oe_utr),...
            sqrt(sig_oe_utr2),sqrt(sig_oe_utr3),sqrt(sig_oe_utr4),sqrt(sig_oe_utr5),rho_utr,rho_utr2,rho_utr3,rho_utr4,rho_utr5];

  X_draws(CF_select) = std_vec;
 
 % disp(X_draws(CF_select))
%  p_acc_var = 1;
%  accept_var = 1;


% compute P0sr_stat_new

params(params_estimated_index) = X_draws;
[F,~,Q] = eval(['add_to_StateSpace',Mspec,'(vrbs,params,params_index,ModelDim.nvar,ModelDim.nshock,ModelDim.noe,shocks,learning,Sml)']);


Q_sr_stat = Q(sel_stat,sel_stat);
 ns = length(sel_stat); 
vecP0_sr_stat = (eye(ns^2)-kron(F(sel_stat,sel_stat),...
                  F(sel_stat,sel_stat)))\Q_sr_stat(:);

P0sr_stat = reshape(vecP0_sr_stat,ns,ns);
P0sr_stat_new = (P0sr_stat + P0sr_stat')/2;
                              

 if ~isnan(P0sr_stat_new)

   rat = mvnpdf(xiS_0(sel_stat(2:12)), xi_0(sel_stat(2:12)), P0sr_stat_new(2:12,2:12))...
        / mvnpdf(xiS_0(sel_stat(2:12)), xi_0(sel_stat(2:12)), P0sr_stat_old(2:12,2:12));
   
  p_acc_var = min(rat,1);
  accept_var = binornd(1,p_acc_var); 
  
  if ~accept_var        
      X_draws(CF_select) = x(CF_select);  
   end
  
  else
     p_acc_var = 0;accept_var=0;
    X_draws(CF_select) = x(CF_select); 
 end  
%  disp('here')
%  disp(X_draws)
