function [ Vt_tot_uncond_obs,Vt_tot_uncond, Vt_ind_uncond_obs,Vt_ind_uncond,V_covar_obs,V_ind_covar_obs,V_ind_covar,V_covar] = UCV(F, Sc, SIG_eps, h, H)

% This function calculates the (time invariant) unconditional variances (for the whole model
% and for each individual shock) and the conditional variances (at each
% time t in h, for the whole model and for each individual shock).


%-------------------------Matrix Initialization---------------------------%

% Total Unconditional Variance:
  
Vt_tot_uncond = vcv(SIG_eps, F, Sc);
Vt_tot_uncond_obs = H'*Vt_tot_uncond* H;

% Unconditional Variances with Individual Shocks:

    % First we create an empty matrix, which gives the unconditional 
    % variance-(covariance) matrix (the first two dimensionS) for each j'th
    % shock (the third dimension). Note that unconditional variances are
    % time invariant, so only three dimensions are needed. We create a
    % corresponding unconditional variance matrix that maps onto states.
    
Vt_ind_uncond = NaN(size(F,1),size(F,1),size(SIG_eps,1));
Vt_ind_uncond_obs = NaN(size(H,2) , size(H,2) , size(SIG_eps,1));

% Total Conditional Variance
    % We create a total conditional varaince matrix (one that will include all
    % the shocks together, that will factor in to later calculations as the
    % divisor when we calculate variance shares:

V_covar = NaN(size(F,1),size(F,1),h); 
V_covar_obs = NaN(size(H,2),size(H,2),h);

% Conditional Variance with Individual Shocks
    % Then create an empty matrix, V_ind_covar that will store the conditional
    % variance-covariance matrix (along the first two dimensions), at time t
    % (the third dimension) for each shock j (the fourth dimension).
    % V_ind_covar_obs will be used to obtain the state variable variance from this equation.

V_ind_covar = NaN( size(F,1) , size(F,1) , h , size(SIG_eps,1) ) ; 
V_ind_covar_obs = NaN( size(H,2) , size(H,2) , h , size(SIG_eps,1) ) ; 

for jj = 2:size(SIG_eps,1)+1
    
%--------------------Initializing the Isolated Shocks-------------------%
    
    SIG_eps_j = zeros(size(SIG_eps,1));
    
    % We Isolate each individual shock:
    SIG_eps_j(jj-1,jj-1) = SIG_eps(jj-1,jj-1);
    
 %-----------------------UNCONDITIONAL VARIANCE---------------------------%
    
    %We calculate the variance under the individual shock and store it in
    %the jj'th matrix of Vt_ind_var:
    
    Vt_ind_uncond(:,:,jj-1) = vcv(SIG_eps_j,F,Sc);
    Vt_ind_uncond_obs(:,:,jj-1) = H' * Vt_ind_uncond(:,:,jj-1) * H;
    
  
 %-----------------------CONDITIONAL VARIANCE---------------------------%
    
 % We create the first entries manually:
    V_ind_covar(:,:,1,jj-1) = Sc * SIG_eps_j * Sc';
    V_covar(:,:,1) = Sc*SIG_eps*Sc';
    
 % Within the loop through each shock, we iterate through time to calculate
 % conditional variance:
    
    for kk = 2:h;
        V_ind_covar(:,:,kk,jj-1) = F * V_ind_covar(:,:,kk-1,jj-1) * F' + Sc * SIG_eps_j * Sc' ;
        V_covar(:,:,kk) = F*V_covar(:,:,kk-1)*F' + Sc * SIG_eps * Sc';
    end
 % Now we map the state variance to the variance of the observables:
    for gg = 1:h   
        V_ind_covar_obs(:,:,gg,jj-1) = H' * (V_ind_covar(:,:,gg,jj-1) )* H;
        V_covar_obs(:,:,gg) = H' * V_covar(:,:,gg) * H;
    end
    
    %end
    
    

end

end

