function [priors_est] = assignPriorParams(priors,params_fixed, params_index)

namesPriors=fieldnames(priors);
nPriors=size(namesPriors,1);

for prior=1:nPriors
    
    % Only add prior if the parameter is estimated
     if params_fixed(params_index.(namesPriors{prior})) == 0 
         
    priors_est.(namesPriors{prior}) = priors.(namesPriors{prior});
    
    mean = priors_est.(namesPriors{prior}).mean;
    std = priors_est.(namesPriors{prior}).std;
    
    switch priors_est.(namesPriors{prior}).shape;
        
        case 'normpdf'
        % distribution paramters are just mean and std
            alpha = mean;
            beta = std;
            
        case 'betapdf'
        % update distribution parameters and std
        
            [alpha, beta] = solveBeta(mean,std^2);
            priors_est.(namesPriors{prior}).std = sqrt(alpha*beta/((alpha+beta)^2*(alpha+beta+1)));
        
        case 'gampdf'
        % update distribution parameters    
            alpha = mean^2/std^2;
            beta = std^2/mean;
        
        case 'invgampdf'
        % update distribution parameters and std
            [alpha, beta] = solveInverseGamma(mean, std^2);
            if alpha >2
                priors_est.(namesPriors{prior}).std = sqrt(beta^2/((alpha-1)^2*(alpha-2)));
            else
                priors_est.(namesPriors{prior}).std = NaN;
            end
            
        case 'unspecified' 
            
            alpha = NaN; beta = NaN;
            
    end
    
    priors_est.(namesPriors{prior}).m1=alpha;
    priors_est.(namesPriors{prior}).m2=beta;
     end
end

end