function [ xi_cfct , xi_cfct_obs ] = counterfact( F_til,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat, Sc_til, SIG_eps, h )
% This function simulates the smoothed path of the economy.


xi_cfct = NaN( size(F,1), h);
xi_cfct_obs = NaN(size(H,2), h);
%Obtain smoothed shock estiamtes.

[xi_mat_smoothed, ~] = kalman_smoother(F_til,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat);

% We isolate the smoothed shocks from the extended xi matrix:
    ind_smooth_shocks = size(xi_mat_smoothed,1) - size(SIG_eps,1) ; 
%     e_smoothed = xi_mat_smoothed(ind_smooth_shocks+1:end,:) ;
    xi_smooth = xi_mat_smoothed(1:ind_smooth_shocks);
    
% Recover the original F and Sc matrices from the extended ones:
     F = F_til(1:ind_smooth_shocks,:);
     Sc = Sc_til(1:ind_smooth_shocks,:);
 

% Initialize the starting values of the state forecast and the observable
% forecast (we'll make them identical to the initial values of the smoothed
% state; everything after that will be the forecast).
     xi_cfct(:,1) = xi_smooth(:,1) % + Sc * e_smoothed(:,1);
     xi_cfct_obs(:,1) = H' * xi_smooth * H ;


 for tt = 2:h
     xi_cfct(:,tt) = F*xi_smooth(:,tt-1);
     xi_cfct_obs(:,tt) = H'*xi_cfct(:,tt)*H ;
 end
 
 

   
end

