function [S] = CreateSelection(vrbs,type,learn,ModelDim)

% This function creates extended state space matrix
% get all variables (excluding lagged variables)
nvar = ModelDim.nvar; %size(T_0, 1);
nlearn = ModelDim.nestimated;
nlag = ModelDim.nlag;
noe = ModelDim.noe;

variables = fields(vrbs); % this gives you the ordering of th variables to be estimated

% construct S: this matrix indicates with a 0 or 1 whether or not a
% variable is "learned" about (i.e., part of nlearn)
Sp = zeros(nvar-nlag, nlearn);

learningVariableIndex = 1;
for variable = 1:nvar-nlag
    if learn.(variables{variable})
        Sp(vrbs.(variables{variable}), learningVariableIndex) = 1;
        learningVariableIndex = learningVariableIndex + 1;
    end
end

S.Som = Sp;
S.Sz = Sp'; % forecast errors correspond to the same variables.

ndrift = size(S.Som,2);

% Define vrbsL

position_shifter = size(S.Som,2)+size(S.Sz,1);  % Shifts lags and observation errors down if learning is active.
                                                           % This because we have
                                                           % added
                                                           % beliefs and forecast
                                                           % errors variables.
                                                           % this is added
                                                           % only to lags
                                                           % and
                                                           % observation
                                                           % errors
for variable = 1:nvar+noe
    
    
    if strcmp(type.(variables{variable}),'lag state') || strcmp(type.(variables{variable}),'oe state');
        
        S.vrbsL.(variables{variable}) = vrbs.(variables{variable}) + position_shifter;
        
    else
        
        S.vrbsL.(variables{variable}) = vrbs.(variables{variable});
        
    end
    
end


% Adding drift estimates
learningVariableIndex = 1;
for variable = 1:nvar-nlag
    if learn.(variables{variable})
        variableL = [variables{variable},'_drift'];
        S.vrbsL.(variableL) = nvar-nlag + learningVariableIndex;      
        learningVariableIndex = learningVariableIndex + 1;
    end
end

% Adding forecast errors

learningVariableIndex = 1;
for variable = 1:nvar-nlag
    if learn.(variables{variable})
        variableL = [variables{variable},'_ferr'];
        S.vrbsL.(variableL) = nvar-nlag+ndrift + learningVariableIndex;      
        learningVariableIndex = learningVariableIndex + 1;
    end
end


