function [] = plotIRFs(allIRFs,vrbs,shocks,nshock,nIterations,spath,savePlots)

% This function takes a matrix containing all impulse response functions
% to produce (and optionally) save these plots. 
% INPUTS
% allIRFs     : a (nshock x nvar x nIterations) matrix containing all impulse
%               response functions
% vrbs        : structure mapping variables to their respective indexes
% shocks      : structure mapping shocks to their respective indexes
% nIterations : number of quarters ahead we wish to plot IRFs
% spath       : path to which we save plots
% savePlots   : indicator for whether or not we wish to save newly plotted
%               IRFs

% Choose variables we wish to plot
plotVarNames={'Output Growth', 'Hours', 'Inflation', 'Interest Rate', 'Consumption','Investment'};
plotVar  ={'y','N','pi','R','c','i'};
nPlotVar=size(plotVar,2);

% get shock names (for saving plots)
shockNames=fields(shocks);

% produce IRF plots, one figure per shock (with subplots for each of
% plotted variables)
for shock=1:nshock
    figure()
    for var_num=1:nPlotVar
        var=vrbs.(plotVar{var_num});
        plotSeries=squeeze(allIRFs(shock,var,:));
        subplot(nPlotVar/2,2,var_num);
        line(1:1:nIterations,plotSeries);
        title(plotVarNames{var_num});
    end
    
    % save figures
    if savePlots
       saveas(gcf, [spath shockNames{shock} '_shock.pdf']);
    end
end
end

