function [allIRFs] = getIRFs(nIterations,shocks,nshock,nvar,D,F,G,H)
% This function is a wrapper for irf.m. It iterates through all shocks,
% computing the IRFs associated with each shock. 

shocksNames=fields(shocks);
allIRFs=NaN(nshock,nvar,nIterations);
for shock=1:nshock
    allIRFs(shock,:,:)= irf(shocks.(shocksNames{shock}), nIterations, D, F, G, H);
end
end

