function [btT,StT]=ksmooth(btt,Stt,bnT,SnT,A,omega)
%[btT StT]=ksmooth(btt,Stt,bnT,SnT,A,omega)
% Smoothing recursion.  State evolution equation is
%    bn=A*bt+e,  Var(e)=omega
%    bt|t ~ N(btt,Stt) -- from Kalman Filter
%    bn|T ~ N(bnT,SnT) -- distribution of bn given full sample. From 
%                         KF if n=T, otherwise from this recursion
%    bt|T ~ N(btT,StT)
% btt and bnT are assumed to be loaded as row vectors and btT is also in
% the same format

% whos A Stt omega
AS=A*Stt;
G=AS*A'+omega;
%****************************
% SAGI=AS'/G;
% line below may slightly slow the routine, but makes it robust vs.
% cases where part or all of the state vector is known with certainty.

[u,s,v] = svd(G);

md = min(size(s));
    bigev = find(diag(s(1:md,1:md))>1e-6);
    sigpropdim = length(bigev);

% sigproplndet = 0;

for i = 1:md
    if i > sigpropdim
        s(i,i) = 0;
    else
        s(i,i)    = 1/s(i,i);
%         sigproplndet = sigproplndet+log(s(i,i));
    end
end

invG = v*s*u';


% SAGI=AS'*pinv(G);
SAGI=AS'*invG;




%*****************************
btT=(SAGI*(bnT'-A*btt'))'+btt;
StT=Stt-SAGI*AS+SAGI*SnT*SAGI';
