

function [L_fun] = ...
   Likelihood(xi_0,P_0,H,R,muc,F,Q,Y_vec,traning_sample) 

 Yobs = Y_vec(1:end-1,:);
 Z = Y_vec(end,:); % ubar is here
 
sample_size = size(Y_vec,2);

% Initial value of the Likelihood

L_fun = 0;


% Construct the Likelihood

for j = 1:sample_size

isobs = find(~isnan(Yobs(:,j)));     


% 1. Compute x_tt and P_tt 


[xi_tt,P_tt,eps,OM_inv,detOM,kb] = Kalman_update(xi_0,P_0,H,R,muc,isobs,Yobs(:,j),Z(j));


if kb == 1
     
  L_fun =  -10e20; return

end



% 3. Updating rules

xi_1 = F*xi_tt;

P_1 = F*P_tt*F'+Q;



% 4. Evaluates likelihood

if j > traning_sample

    
%L_fun = L_fun-0.5*log((det(H(:,isobs)'*P_0*H(:,isobs)+R(isobs,isobs))))-0.5*eps'*OM_inv*eps;
 L_fun = L_fun-0.5*log(detOM)-0.5*eps'*OM_inv*eps;
%    if imag(L_fun) ~=0
%        keyboard
%    end   
end


% Update 

xi_0 = xi_1; P_0 = P_1;

end

