
% THIS computes the Kalman filter on the extended state space which
% includes the structural innovations

function [Lik,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat,F,Q,H,M,R] = KalmanFilter(Mspec,params,params_index,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,type,learning,Sml,Y_main,trainingSampleLength);
         

% State Space (add back lags and observation errors)


[F,~,Q] = eval(['add_to_StateSpace',Mspec,'(vrbs,params,params_index,ModelDim.nvar,ModelDim.nshock,ModelDim.noe,shocks,learning,Sml)']);
 

 sel_stat = [vrbs.pi vrbs.x vrbs.x_L vrbs.mu vrbs.ustar ...
     vrbs.oe_pi510Y_pi vrbs.oe_pi12q_pi vrbs.oe_utr];
  ns = length(sel_stat);
 sel_nonstat = vrbs.pistar;
  nn = length(sel_nonstat);
  

%% Get Measurement Equation

%[H,M,R] = eval(['getMeasurementEquation',Mspec,'(vrbs, vrbs_obs, params,params_index, ModelDim,learning,Sml)']);
[H,M,R] = eval(['getMeasurementEquation',Mspec,'(vrbs, vrbs_obs, params,params_index, ModelDim,learning,Sml,F)']); % laubach2 version

% Initialization of Kalman filter

xi_0 = zeros(size(F,2),1);
xi_0(vrbs.pi) = 2;
xi_0(vrbs.ustar) = 0;
xi_0(vrbs.pistar) = 2;
%xi_0(vrbs.x) = 0;

% More informed initial P0

P_0 = zeros(size(F));
P_0(sel_nonstat,sel_nonstat) = 0.1*eye(nn);

Q_sr_stat = Q(sel_stat,sel_stat);
 
vecP0_sr_stat = (eye(ns^2)-kron(F(sel_stat,sel_stat),...
                  F(sel_stat,sel_stat)))\Q_sr_stat(:);

P0sr_stat = reshape(vecP0_sr_stat,ns,ns);
P0sr_stat_mew = (P0sr_stat + P0sr_stat')/2;
P_0(sel_stat,sel_stat) = P0sr_stat_mew;

% initial ocndition for likelihood
xi_00 = F*xi_0; 
P_00 = F*P_0*F'+Q;


% Kalman filter

[Lik,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat] = Likelihood_preds(xi_00,P_00,H,R,M,F,Q,Y_main',trainingSampleLength);

