
function [OBJ] = Obj_fun_postMH2(x,priors,MIN,Mspec,params,params_index,params_estimated_index,...
                                      trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml,type,learning,Y_main,Y_pre,trainingSampleLength)
                                  
                                  

% x:                initial values of parameters
% priors:           prior distributions
% MIN:              Min/Max Flag
% Jtrans:           Run Metroplis Flag
% Y_dataB:          observables data
% Y_dataB_iniB:     "inital values" of observables data
% sample_sizeB:     sample size
% train_sampleB:    train sample ?
% vrbs_obsB:        observable structure
% params_est:       parameters
% vrbsB:            state variable?
% MShokB:           shock matrix

% nlag = ModelDim.nlag;
% noe = ModelDim.noe;

% Transform parameters to ensure they fall within certain boundaries

if MIN
   
params(params_estimated_index) = trans(x,trspec(params_estimated_index,:)); 

else
    
params(params_estimated_index) = x;

end



%% Get State Equation 

%[T_Z,T_epsilon,~,~,~,~,flag_solve] = solveModelv1(Mspec,params,params_index,vrbs,shocks, ModelDim,type,learning,Sml); %#ok<ASGLU>
    


%   if flag_solve
%    
%      OBJ = 10e20*MIN + (-10e20)*(1-MIN); return
%       
%   else

%  OMz = T_Z(1:ModelDim.nvar-ModelDim.nlag,1:ModelDim.nvar-ModelDim.nlag); %#ok<NASGU>
% % Note: This is needed to build agents' forecasts in the observation
% %       equation. Under learning, the upper corner of the matrix defines
% %       Omega_Z.

      
% State Space (add back lags and observation errors)


[F,~,Q] = eval(['add_to_StateSpace',Mspec,'(vrbs,params,params_index,ModelDim.nvar,ModelDim.nshock,ModelDim.noe,shocks,learning,Sml)']);
 

 sel_stat = [vrbs.pi vrbs.x vrbs.x_L vrbs.mu vrbs.ustar ...
     vrbs.oe_pi510Y_pi vrbs.oe_pi12q_pi vrbs.oe_utr];
  ns = length(sel_stat);
 sel_nonstat = vrbs.pistar;
  nn = length(sel_nonstat);

if max(abs(eig(F(sel_stat,sel_stat)))) > 0.995
    
    OBJ = 10e20*MIN + (-10e20)*(1-MIN);  return

else   

%% Get Measurement Equation

%[H,M,R] = eval(['getMeasurementEquation',Mspec,'(vrbs, vrbs_obs, params,params_index, ModelDim,learning,Sml)']);
[H,M,R] = eval(['getMeasurementEquation',Mspec,'(vrbs, vrbs_obs, params,params_index, ModelDim,learning,Sml,F)']); % laubach2 version

% Initialization of Kalman filter

xi_0 = zeros(size(F,2),1);
xi_0(vrbs.pi) = 2;
xi_0(vrbs.ustar) = 0;
xi_0(vrbs.pistar) = 2;
%xi_0(vrbs.x) = 0;

% More informed initial P0

P_0 = zeros(size(F));
P_0(sel_nonstat,sel_nonstat) = 0.1*eye(nn);

Q_sr_stat = Q(sel_stat,sel_stat);
 
vecP0_sr_stat = (eye(ns^2)-kron(F(sel_stat,sel_stat),...
                  F(sel_stat,sel_stat)))\Q_sr_stat(:);

P0sr_stat = reshape(vecP0_sr_stat,ns,ns);
P0sr_stat_mew = (P0sr_stat + P0sr_stat')/2;
P_0(sel_stat,sel_stat) = P0sr_stat_mew;

% initial ocndition for likelihood
xi_00 = F*xi_0; 
P_00 = F*P_0*F'+Q;

% Evaluate Likelihood

LikB = Likelihood(xi_00,P_00,H,R,M,F,Q,Y_main',trainingSampleLength);
%LikB = Likelihood(xi_0,P_0,H,R,M,F,Q,Y_main',0);

% keyboard
% Evaluate priors




logsumpriorsB = priorEval_fun(params,params_index,priorsMH);



OBJ =  -(LikB + logsumpriorsB)*MIN +...
        (LikB + logsumpriorsB)*(1-MIN);
 
   
  end
  
end

