
%% Main Gibbs

 % MH step: evaluates distribution for 1. kappa; 2. sigma_u; 3. rho_u
 % Closed-form posterior: dgp for x(t); mu(t); observation errors; pistar 
 
 % 1. variable; parameters setup -- usual code
 % 2. Gibbs:
 %  a. initial conditions -- Obj_fun file
 %  b. -----  start loop -----
 %  b1. draw ubar
 %  b1. Kalman filter (Lik funtion)
 %  b2. MH step
 %  b3. smoother
 %  b4. closed-form posterior draw
 %  b5. MH step on intial conditions
 %  b6. Store states and params
 %    ------ end loop  -----
 
 % Define selection vectors: entries from vector x (set_params)
 
 MH_select = [1 2 3 4 5 9];
 
 CF_select = [6 7 8 10 11];
 
 params_estimatedMH_index = [1 2 4 6 7 11]; % index of the parameters in MH
 % Special for MH step (adjust manually)
priorsMH.a_x1 = priors.a_x1;
priorsMH.a_x1 = priors.a_x2;
priorsMH.kappa = priors.kappa;
priorsMH.rho_u = priors.rho_u;
priorsMH.rho_ze = priors.rho_ze;
%priorsMH.sigma_x = priors.sigma_x;
priorsMH.sigma_ustar = priors.sigma_ustar;

 
% MH_select = [3 4 5 7 9];
%  
% CF_select = [1 2 6 8 10 11];
 
 % Priors for parameter drwn in closed-form
 
 PriorsCF.Psix = 0.15^2*5;
 PriorsCF.df_x = 3;
 %PriorsCF.lambdax = 0.5;
 PriorsCF.Psimu = 1;
 PriorsCF.df_mu = 3;
 %PriorsCF.lambdamu = 0.06;
 PriorsCF.SC0pist = 0.15^2*5;
 PriorsCF.df0pist = 3;
 PriorsCF.SC0oe_pi12q_pi = 0.1*5; %Mode
 PriorsCF.df0oe_pi12q_pi = 3;
 PriorsCF.SC0oe_pi510Y_pi = 0.001*5;
 PriorsCF.df0oe_pi510Y_pi = 3;
 
 Ndraws = 4000;disc_draws = 0;
 
 csquare = .25;
 sigscaleGibbs = 1/26;
 
% Initial conditions
X_draws = params_estimated;

%Generate ubar path draws. Loaded ubar variable
load Ubar_mat ubar

n_draws_swl = 1;

% drawsel = randperm(size(ubar,2));
% 
% ubar_draws = ubar(:,drawsel(1:min(n_draws_swl,size(ubar,2))));

Y_main(:,end) = 100*mean(ubar,2);  

%X_draws_mat = []; xi_TT_mat = [];
%load ubar_robust
X_draws_mat = NaN(length(X_draws),Ndraws);
%xi_TT_mat = = NaN(,Ndraws);

for jj = 1:n_draws_swl
    
%Y_main(:,end) = eval(['most_',num2str(jj)]);
%Y_main(:,end) = 100*ubar_draws(:,jj);

% Compute initial conditions

 disp(['initial conditions for ubar draw:',num2str(jj)]);
% findModeGibbs;
% X_draws = xmode;


%X_draws = params_estimated;
 tic
 for jm = 1:Ndraws 
   
 
 %for jn = 1:1000 
[X_draws,xi_TT,Y_pred,Logpost_draw,accept,accept_var,p_acc,p_acc_var] = ...
                    Gibbs_draw(sigscaleGibbs,X_draws,csquare,MH_select,CF_select,...
                    Mspec,priors,priorsMH,PriorsCF,params,params_index,params_estimated_index,params_estimatedMH_index,...
                    bounds,trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml, type,learning,Y_main,Y_pre,trainingSampleLength);
 %end
 
%  eval(['X_draws_mat',num2str(jj),'(:,jm) = X_draws;']);
%  eval(['xi_TT_mat',num2str(jj),'(:,:,jm) = xi_TT;']);
 if jm > disc_draws
 X_draws_mat(:,jm) = X_draws;
 xi_TT_mat(:,:,jm) = xi_TT;
 end
%  X_draws_mat(:,jm) = X_draws; 
%  xi_TT_mat(:,:,jm) = xi_TT;
%  Y_pred_mat(:,:,jm) = Y_pred;

% Display

 P_acc(jm)    = p_acc;
 P_acc_var(jm)= p_acc_var;
    
    if mod(jm,10)==0  % Print to command window
        if jm>1
            if jm <=1000
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate so far: ',num2str(mean(P_acc(1:jm)))])
                disp(['Acceptance rate so far: ',num2str(mean(P_acc_var(1:jm)))])
            elseif jm <10000
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate of the last 1k draws: ',num2str(mean(P_acc(jm-1000+1:jm)))])
                disp(['Acceptance rate of the last 1k draws: ',num2str(mean(P_acc_var(jm-1000+1:jm)))])
            else
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate of the last 10k draws: ',num2str(mean(P_acc(jm-5000+1:jm)))])
                disp(['Acceptance rate of the last 10k draws: ',num2str(mean(P_acc_var(jm-5000+1:jm)))])
            end
        end
        
    end
                
 
 end
 % save('TESTREZ_nopt',['X_draws_mat',num2str(jj)],['xi_TT_mat',num2str(jj)]);
 if jj == 1
xi_TT_allustar = (xi_TT_mat(:,:,:));
%xi_TT_allutrend = squeeze(xi_TT_matCk(vrbs.utrend,:,:));

else
xi_TT_allustar = [xi_TT_allustar,(xi_TT_mat(:,:,:))]; 
%xi_TT_allutrend = [xi_TT_allutrend,squeeze(xi_TT_matCk(vrbs.utrend,:,:))]; 
end 
end
        
%save('TESTALL6', '-v7.3')