

%% PRODUCES FULL CYCLE OF METROPOLIS


% Assign sigscale matrix

if (exist('X_draws','var'))
    
    % Select mode and sigscale                                        
[~, b] = max(Logpost_draws);
        
Logpostmode = Logpost_draws(b);
    
xmode = X_draws(:,b);

provided_sigscale = real(sqrtm(cov(X_draws')));

if isempty(csquare_proposed)
    
csquare_proposed = csquare;

end


elseif (~exist('X_draws','var')) && (exist('sigscaleHess','var'))
    
provided_sigscale = sigscaleHess;  

else
    
% provided_sigscale = []; 
disp('No sigscale!'); return

end % exists    


%% Fine-tune csquare

 if finetune
     
csquare_ini = 0.70;
csquare_select = csquare_ini;
multfactor = 0.95; % goes down in steps of 0.03...
distz = 1;
limcount = 50;
targetacc = 0.38; % target acceptance rate
toler = 0.04; % tolerance from target acceptance rate
countft = 0;
ndrawsiter = 1500; % fine-tuning of the acceptance rate


% Start looping

csquare = csquare_ini/multfactor;


 while countft < limcount && distz  > toler 
            
            csquare = csquare * multfactor;
            
            
            disp(['current cquare =',num2str(csquare)]);
            
            
    [~,~,acc_ratio] = Metropolis_fun(provided_sigscale,xmode,Logpostmode,...
                       csquare,csquare,ndrawsiter,...
                       Mspec,priors,params,params_index,params_estimated_index,...
                       bounds,trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml,type,learning,Y_main,Y_pre,trainingSampleLength);         
                
         countft = countft+1;
         
         
       if abs(acc_prob-targetacc) < distz 
                distz  = abs(acc_prob-targetacc);
                csquare_select = csquare;
                acc_select = acc_prob;
       end
       
       
 end
 
 if countft == limcount
     
     disp('Could not find acc rate: I will stop here'); return

 end
 
 else
     
 csquare_select = csquare_proposed;    
 
 end % finetune
 
 
%% Compute chain

 [X_draws,Logpost_draws,acc_ratio] = ...
                    Metropolis_fun(provided_sigscale,xmode,Logpostmode,...
                    csquare_select,csquare_select,ndraws,...
                    Mspec,priors,params,params_index,params_estimated_index,...
                    bounds,trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml, type,learning,Y_main,Y_pre,trainingSampleLength);
                
 csquare = csquare_select;
 
save([spath,...
    'Mode',pathslash,...
    [timestamp, EstimationName]],'X_draws','Logpost_draws','acc_ratio','csquare','-append');


% Choose a random selection of draws to run statistcs and predictions

n_draws_swl = 5000;
discard = 5000;

X_draws = X_draws(:,discard+1:end);

drawsel = randperm(size(X_draws,2));

X_select_draws = X_draws(:,drawsel(1:min(n_draws_swl,size(X_draws,2))));
                
save([spath,...
    'Mode',pathslash,...
    [timestamp, EstimationName]],'X_select_draws','-append');
                


