
%% Initial setup

clear;


addpath Routines
addpath UseData


Ndraws  =  20000;  % Number of MCMC draws
c_scale = 1/8;
p = 2;            % Number of lags in the VAR for the cycle;
DO_IID  = 0;
DO_RWs = 0;
DO_PLOTS = 1;
SAVE_PLOTS=1;
DO_ESTIMATION = 0;
spec = 'BASEline2';
filename = ['Joint_estimation',spec];

% data : 1960:2018.5 --details in AssembleFlowData file (Data folder)
load FlowsDataMat agg_flows wgts flows
y = 100*[flows agg_flows];
[T,n] = size(y);
n_s = 6;
n_f = 6;



if DO_ESTIMATION
%% Setup model, initial conditions
% See Hamilton Time Series Analysis (1994) for a reference to the
% state-space notation.

% Load initial conditions
 
%% [1] Priors setup
    % VAR
b0           = zeros(2,2*p); % prior on VAR(p) coefficients
lambda       = 2.0;  % Minnesota prior on VAR(p) componenents
Psi          = [0.2 2]; % priors scale on VAR(p) vcv
dfvar        = 4;
% df for the VAR(2) process are fixed to n+2 in the BVARs function [double check]

    % stationary component epsilon
lambdaeps   = 1;%0.4; % Minn prior on stationary component in flows 
lambdaepsf  = 1; % Minn prior on stationary component in flows 
Psiepsl_s   = 0.2; % priors on sigmaeps
Psiepsl_f   = 2; % priors on sigmaeps
df_eps      = 3; % (n+2 degrees of freedon: enough for mean to exist)

    % trends
if DO_RWs    
SC0trs = 2*0.05^2; % prior scale for variance on trends (it is not the mode or the mean)
else
SC0trs = 2*0.01^2; % prior scale for variance on trends (it is not the mode or the mean)    
end    
df0trs = 3; % prior degree of freedon for trends
SC0trf = 2*0.1^2; % prior scale for variance on trends (it is not the mode or the mean)
df0trf = 3;%5*2.0044; % prior degree of freedon for trends

    % theta coeffs
mean_theta = 1;
std_theta = .5; %25;%35;


% [2] State-space matrices
  % load paramters (load from recent result next time!)
  load Rez_alts100 x % from max like opt (check all paramters are consistent with priors)
  x_s = x; clear x
  load Rez_altf100 x
  x_f = x; clear x
  
   % Theta
  Theta_s = [x_s(1);1;x_s(2:n_s-1)]; % Theta(2) is normalized to 1
  Theta_f = [x_f(1);1;x_f(2:n_f-1)]; 
  
  % State Space coeffs
 PSI_s = zeros(n_s); % autocorrelation coeffs. for eps component in s flow
 PSI_f = zeros(n_f); % autocorrelation coeffs. for eps component in f flow
 
 if ~DO_IID
     
 PSI_s(1:n_s,1:n_s) = diag(x_s(3*n_s+1:4*n_s));
 PSI_f(1:n_f,1:n_f) = diag(x_f(3*n_f+1:4*n_f));
 
 end
  if DO_RWs  
      
      Fc = zeros(n_s);
      
  else
      Fc = eye(n_s);
      
  end
      

% F_s = [eye(n_s) eye(n_s) zeros(n_s)
      F_s = [eye(n_s) Fc zeros(n_s)
        zeros(n_s) eye(n_s) zeros(n_s)
        zeros(n_s,2*n_s) PSI_s];
 
 F_f = [eye(n_f) zeros(n_f)
        zeros(n_f,n_f) PSI_f];    
    
  % Var coeffs  
 beta_var = [x_s(4*n_s+1) 0 0 0
             0 x_f(4*n_s+1) 0 x_f(4*n_s+2)];
         
%  beta_var = [0.7329   -0.0096   -0.1374    0.0102
%             -1.0608    1.8796    0.4042   -0.9038]; 

 F_var = [beta_var
          eye(2) zeros(2)];
         
  % A mat (state space)       
 A = zeros(3*n_s+2*n_f+2*p);
        
 A(1:3*n_s,1:3*n_s) = F_s;
 A(3*n_s+1:(3*n_s+2*n_f),3*n_s+1:(3*n_s+2*n_f)) = F_f;
 A((3*n_s+2*n_f)+1:end,(3*n_s+2*n_f)+1:end) = F_var;
 
      
 % V mat (state space)
 
 V = zeros(3*n_s+2*n_f+2*p, 2*n_s+2*n_f+2);
 
 V_s = [eye(n_s) zeros(n_s)
        eye(n_s) zeros(n_s)
        zeros(n_s) eye(n_s)];
    
    
 V_f =  [eye(n_s) zeros(n_s)
        zeros(n_s) eye(n_s)];
    
    
 V_var = [eye(2);zeros(p)];   
    
V(1:3*n_s,1:2*n_s) = V_s;
V(3*n_s+1:(3*n_s+2*n_f),2*n_s+1:(2*n_s+2*n_f)) = V_f;
V((3*n_s+2*n_f)+1:end,(2*n_s+2*n_f)+1:end) = V_var;

  % Shock variances
  
  
  eta_s = 10*exp(x_s(n_s));
  eta_f = 10*exp(x_f(n_f));
  
  SIG_eta = diag([eta_s;eta_f]);
  
%   SIG_eta =  [0.0093   -0.0161
%    -0.0161    0.2541];

  SIG_var = V_var*SIG_eta*V_var';
  SIG_var = (SIG_var + SIG_var')/2;
 
  SIG_s  = zeros(2*n_s); SIG_f  = zeros(2*n_f);
  
  SIG_s(1:n_s,1:n_s) = diag(exp(x_s(n_s+1:2*n_s)));
  
  SIG_s_eps = diag(exp(x_s(2*n_s+1:3*n_s)));
  SIG_s(n_s+1:2*n_s,n_s+1:2*n_s) = SIG_s_eps;
  
  SIG_f(1:n_f,1:n_f)  = diag(exp(x_f(n_f+1:2*n_f)));
  
  SIG_f_eps = diag(exp(x_f(2*n_f+1:3*n_f)));
  SIG_f(n_f+1:2*n_f,n_f+1:2*n_f)  = SIG_f_eps;
  
  SIG = zeros(2*n_s+2*n_f+2);
  SIG(1:2*n_s,1:2*n_s) = SIG_s;
  SIG(2*n_s+1:2*n_s+2*n_f,2*n_s+1:2*n_s+2*n_f) = SIG_f;
  SIG(end-1:end,end-1:end) = SIG_eta;
  

 
 Q = V*SIG*V'; Q = (Q + Q')/2;


C = zeros(n_s+n_f,3*n_s+2*n_f+2*p); %% still need add two time-varying rows with aggregate flows:
                                     % this is done in the Kalman filter
                                     % step
                                     
R = eye(n)*1e-12; % add two time-varying rows with aggregate flows

C_s = [eye(n_s) zeros(n_s) eye(n_s)];
C_f = [eye(n_f) eye(n_f)];

C(1:n_s,1:3*n_s) = C_s;
C(1:n_s,(3*n_s+2*n_f+1)) = Theta_s;
C(n_s+1:(n_s+n_f),3*n_s+1:(3*n_s+2*n_f)) = C_f;
C(n_s+1:(n_s+n_f),(3*n_s+2*n_f+2)) = Theta_f;


% Define S0 and P0
S0tr_s = [9.5;1.6;1.3;12;3.7;1.9];
S0tr_s = [S0tr_s;zeros(n_s,1)];
S0eps_s = zeros(n_s,1);  % Initialize individual IID disturbances
S0tr_f = [60;40;35;70;45;40];
S0eps_f = zeros(n_f,1);
S0var = zeros(2*p,1);
    % assemble
S0 = [S0tr_s;S0eps_s;S0tr_f;S0eps_f;S0var];


P0tr_s = 1*diag(ones(2*n_s,1).^2);
P0tr_s(n_s+1:end,n_s+1:end) = 0.05*diag(ones(n_s,1).^2);

P0tr_f = 100*diag(ones(n_f,1).^2); %40


vecP0cyc_s = (eye((n_s)^2)-kron(PSI_s,PSI_s))\SIG_s_eps(:);
P0cyc_s = reshape(vecP0cyc_s,n_s,n_s);
P0cyc_s = (P0cyc_s + P0cyc_s')/2;


vecP0cyc_f = (eye((n_f)^2)-kron(PSI_f,PSI_f))\SIG_f_eps(:);
P0cyc_f = reshape(vecP0cyc_f,n_f,n_f);
P0cyc_f = (P0cyc_f + P0cyc_f')/2;

vecP0cyc_var = (eye((2*p)^2)-kron(F_var,F_var))\SIG_var(:);
P0cyc_var = reshape(vecP0cyc_var,2*p,2*p);
P0cyc_var = (P0cyc_var + P0cyc_var')/2;

% For initial condition MH step
 if DO_IID
    P0cyc = P0cyc_var;
       
      else
          
    P0cyc = [P0cyc_s zeros(n_s,n_f+2*p)
             zeros(n_f,n_s) P0cyc_f zeros(n_f,2*p)
                    zeros(2*p,n_s+n_f) P0cyc_var];
    P0cyc_new = (P0cyc + P0cyc)/2; 
 end

    % assemble
P0    = zeros(size(A));
P0(1:2*n_s,1:2*n_s)     = P0tr_s;
P0(2*n_s+1:3*n_s,2*n_s+1:3*n_s) = P0cyc_s;
P0(3*n_s+1:4*n_f,3*n_s+1:4*n_f) = P0tr_f;
P0(4*n_f+1:5*n_f,4*n_f+1:5*n_f) = P0cyc_f;
P0(5*n_f+1:end,5*n_f+1:end) = P0cyc_var;


tic

% Store MCMC
States = NaN(T,size(A,2),Ndraws);
%Trends = ones(T,n,Ndraws)*NaN;
LogLik = NaN(1,Ndraws);
%SS0    = ones(n,Ndraws)*NaN;
AA     = NaN(size(A,1),size(A,2),Ndraws);
QQ     = NaN(size(Q,1),size(Q,2),Ndraws);
CC     = NaN(size(C,1),size(C,2),Ndraws);
%RR     = ones(n,n,Ndraws)*NaN;

P_acc_var = NaN(1,Ndraws);
P_acc     = NaN(1,Ndraws);

logML = -inf;  % Initialize log maximum likelihood

%% Begin estimation
% For reference, see the appendix.
 %keyboard
for jm = 1:Ndraws  % MCMC draws
  
    %disp(jm)
    % ------------------------- Block 1a ----------------------------------
    
    kf = KF(y,wgts, C, R, A, Q, S0, P0,n_s,n_f);
    

    loglik = kf.LogLik;
    
    theta_old = [C([1 3:n_s],(3*n_s+2*n_f+1));C([n_s+1 n_s+3:(n_s+n_f)],(3*n_s+2*n_f+2))];
    
    theta_new = theta_old + randn(size(theta_old))*std_theta*c_scale;  % Perturb theta
    
    C_new            = C;
    C_new([1 3:n_s],(3*n_s+2*n_f+1)) = theta_new(1:n_s-1);   % loadings on common factor    
    C_new([n_s+1 n_s+3:(n_s+n_f)],(3*n_s+2*n_f+2)) = theta_new(n_s:end);
    
    kf_new     = KF(y,wgts, C_new, R, A, Q, S0, P0,n_s,n_f);  % Likelihood of new parameters
    loglik_new = kf_new.LogLik;
    
    log_rat    = (loglik_new + sum(log(normpdf(theta_new,mean_theta,std_theta^2)))) ...
               - (loglik     + sum(log(normpdf(theta_old,mean_theta,std_theta^2))));
    p_acc = min(exp(log_rat),1);
    
    
    
    if rand<=p_acc  % Accept
        C      = C_new;
        loglik = loglik_new;
        kf     = kf_new;
    end;
    
    % ----------------------------- Block 2a ------------------------------
    
    kc   = KC(kf);                     % Smoother
   
    if DO_RWs  
    Ytr_s  = [kc.S0(1:n_s)'; kc.S(:,1:n_s)]; % Trend (tau) components for s 
    else
    Ytr_s  = [kc.S0(n_s+1:2*n_s)'; kc.S(:,n_s+1:2*n_s)]; % Trend (gt) components for s    
    end
    Ytr_f  = [kc.S0(3*n_s+1:3*n_s+n_f)'; kc.S(:,3*n_s+1:3*n_s+n_f)]; % Trend (taut) components for f
    
    Ycyc_eps_s = [kc.S0(2*n_s+1:3*n_s)';kc.S(:,2*n_s+1:3*n_s)]; % Cyclical components eps for s 
    Ycyc_eps_f = [kc.S0(3*n_s+n_f+1:3*n_s+2*n_f)';kc.S(:,3*n_s+n_f+1:3*n_s+2*n_f)]; % Cyclical components eps for f 
%    Ycyc_eps_f = kc.S(:,3*n_s+n_f+1:3*n_s+2*n_f); % Cyclical components
%    eps for f (IID CASE)
    Y_cyc_var  = [kc.S0(3*n_s+2*n_f+1:3*n_s+2*n_f+2)';kc.S(:,3*n_s+2*n_f+1:3*n_s+2*n_f+2)]; % VAR(p)
    
   
    
    % ----------------------------- Block 2b -------------------------------
    
    % s:
    
    for jg = 1:n_s
   % p(?e|y ?0:T)=IW(?e +S?e,?e +T)
   S = diff(Ytr_s(:,jg))'*diff(Ytr_s(:,jg)) + SC0trs;
   SIG_s(jg,jg) = iwishrnd(S,df0trs + T);
  
%    S = diff(Ytr_s(:,jg))'*diff(Ytr_s(:,jg)) ;
%    SIG_s(jg,jg) = iwishrnd(S,T-1);
   
       if DO_IID
   S = Ycyc_eps_s(2:end,jg)'*Ycyc_eps_s(2:end,jg) + Psiepsl_s;  % do not need initial condition (S0)
   SIG_eps_s(jg,jg) = iwishrnd(S,df_eps + T); 
       else
          
   [betaeps,sigmaeps] = BVARs(Ycyc_eps_s(:,jg), 1, 0, Psiepsl_s,df_eps, lambdaeps,1, 1); 
                        
   SIG_s_eps(jg,jg) = sigmaeps;
   PSI_s(jg,jg) = betaeps;
       end    
       
    end % jg
 
    F_s(2*n_s+1:end,2*n_s+1:end) = PSI_s;
    SIG_s(n_s+1:2*n_s,n_s+1:2*n_s) = SIG_s_eps;

    
    % f:
    
    for jg = 1:n_f
   % p(?e|y ?0:T)=IW(?e +S?e,?e +T)
   S = diff(Ytr_f(:,jg))'*diff(Ytr_f(:,jg)) + SC0trf;
   SIG_f(jg,jg) = iwishrnd(S,df0trf + T);
%    S = diff(Ytr_f(:,jg))'*diff(Ytr_f(:,jg));
%    SIG_f(jg,jg) = iwishrnd(S,T-1);
   
   if DO_IID   
   S = Ycyc_eps_f(:,jg)'*Ycyc_eps_f(:,jg) + Psiepsl_f;  
   SIG_f_eps(jg,jg) = iwishrnd(S,df_eps + T); 
   else
          
   [betaepsf,sigmaepsf] = BVARs(Ycyc_eps_f(:,jg), 1, 0, Psiepsl_f,df_eps, lambdaepsf,1, 1); 
   
   SIG_f_eps(jg,jg) = sigmaepsf;
   PSI_f(jg,jg) = betaepsf;   
   end    
    end % jg
   
   F_f(n_f+1:end,n_f+1:end) = PSI_f; 
   SIG_f(n_f+1:2*n_f,n_f+1:2*n_f)  = SIG_f_eps;
   
   
     % VAR(p)
   
    [beta_var,sigma_var] = BVARs(Y_cyc_var,p,b0',Psi,dfvar,lambda,1,1); 
    
    sigma_var = (sigma_var + sigma_var')/2;
    
    F_var = [beta_var'
          eye(2) zeros(2)];
    
    SIG_eta = sigma_var;
    SIG_var = V_var*SIG_eta*V_var';
    SIG_var = (SIG_var + SIG_var')/2;

    
    
   % Update new matrices
    
    A_new = A;
    A_new(1:3*n_s,1:3*n_s) = F_s;
    A_new(3*n_s+1:(3*n_s+2*n_f),3*n_s+1:(3*n_s+2*n_f)) = F_f;
    A_new((3*n_s+2*n_f)+1:end,(3*n_s+2*n_f)+1:end) = F_var;
   
    SIG_new = SIG;
    SIG_new(1:2*n_s,1:2*n_s) = SIG_s;
    SIG_new(2*n_s+1:2*n_s+2*n_f,2*n_s+1:2*n_s+2*n_f) = SIG_f;
    SIG_new(end-1:end,end-1:end) = SIG_eta;
  
    Q_new = V*SIG_new*V'; Q_new = (Q_new + Q_new')/2;
 
      % disp(max(abs([eig(PSI_s);eig(PSI_f);eig(F_var)])))
    if max(abs([eig(PSI_s);eig(PSI_f);eig(F_var)])) < 1  % Convergence criteria
      
        vecP0cyc_s = (eye((n_s)^2)-kron(PSI_s,PSI_s))\SIG_s_eps(:);
        P0cyc_s_new = reshape(vecP0cyc_s,n_s,n_s);
        P0cyc_s_new = (P0cyc_s_new + P0cyc_s_new')/2;


       vecP0cyc_f = (eye((n_f)^2)-kron(PSI_f,PSI_f))\SIG_f_eps(:);
        P0cyc_f_new = reshape(vecP0cyc_f,n_f,n_f);
        P0cyc_f_new = (P0cyc_f_new + P0cyc_f_new')/2;

      vecP0cyc_var = (eye((2*p)^2)-kron(F_var,F_var))\SIG_var(:);
      P0cyc_var_new = reshape(vecP0cyc_var,2*p,2*p);
      P0cyc_var_new = (P0cyc_var_new + P0cyc_var_new')/2;

      % MH for initial conditions
      
      if DO_IID
          
       Y0cyc = kc.S0(3*n_s+2*n_f+1:end);   
       P0cyc_new = P0cyc_var_new;
       
      else
          
       Y0cyc = [Ycyc_eps_s(1,:)';Ycyc_eps_f(1,:)';kc.S0(3*n_s+2*n_f+1:end)];  
       
       P0cyc_new = [P0cyc_s_new zeros(n_s,n_f+2*p)
                     zeros(n_f,n_s) P0cyc_f_new zeros(n_f,2*p)
                     zeros(2*p,n_s+n_f) P0cyc_var_new];
       P0cyc_new = (P0cyc_new + P0cyc_new')/2;         
          
      end
     
         rat = mvnpdf(Y0cyc, Y0cyc*0, P0cyc_new) / mvnpdf(Y0cyc, Y0cyc*0, P0cyc);
        
        p_acc_var = min(rat,1);
        
       %keyboard
      
        if rand<=p_acc_var  % Accept
            A  = A_new;
            Q  = Q_new;
            P0cyc = P0cyc_new;
            
            % Assemble P0 back
           
            P0(2*n_s+1:3*n_s,2*n_s+1:3*n_s) = P0cyc_s_new;
            P0(4*n_f+1:5*n_f,4*n_f+1:5*n_f) = P0cyc_f_new;
            P0(5*n_f+1:end,5*n_f+1:end) = P0cyc_var_new;
        end;
        
    else
        p_acc_var = 0;
    end %eig cond
%end 
    
    
    % Store MCMC
    States(:,:,jm) = kc.S;
    %Trends(:,:,jm) = kc.S(:,end)*C(:,end)';
    LogLik(jm) = loglik;
    %LogML(jm)  = logML;
    %SS0(:,jm)  = S0(1:n);
    AA(:,:,jm) = A;
    QQ(:,:,jm) = Q;
    CC(:,:,jm) = C;
    %RR(:,:,jm) = R;
    Lambda(jm) = lambda;
    
    P_acc(jm)    = p_acc;
    P_acc_var(jm)= p_acc_var;
    
    if mod(jm,10)==0  % Print to command window
        if jm>1
            if jm <=1000
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate so far: ',num2str(mean(P_acc(1:jm)))])
                disp(['Acceptance rate so far: ',num2str(mean(P_acc_var(1:jm)))])
            elseif jm <10000
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate of the last 1k draws: ',num2str(mean(P_acc(jm-1000+1:jm)))])
                disp(['Acceptance rate of the last 1k draws: ',num2str(mean(P_acc_var(jm-1000+1:jm)))])
            else
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate of the last 10k draws: ',num2str(mean(P_acc(jm-5000+1:jm)))])
                disp(['Acceptance rate of the last 10k draws: ',num2str(mean(P_acc_var(jm-5000+1:jm)))])
            end
        end
        
    end
    end %ndraws

Ndraws = length(Lambda)-1;

skip = 1;
%Discard = floor(Ndraws/2);  % Burn-in index
Discard = 15000;
% Remove burn-in draws
States = States(:,:,Discard+1:Ndraws);
%Trends = Trends(:,:,Discard+1:Ndraws);
AA     = AA(:,:,Discard+1:Ndraws);
QQ     = QQ(:,:,Discard+1:Ndraws);
CC     = CC(:,:,Discard+1:Ndraws);
%RR     = RR(:,:,Discard+1:Ndraws);
LogLik = LogLik(:,Discard+1:Ndraws);
%LogML  = LogML(:,Discard+1:Ndraws);
%SS0    = SS0(:,Discard+1:Ndraws);

%return

% Figs temp
legend_text = cell(n_s+n_f,1);
legend_text{1} = 's_m16to24';
legend_text{2} = 's_m25to54';
legend_text{3} = 's_m55plus';
legend_text{4} = 's_f16to24';
legend_text{5} = 's_f25to54';
legend_text{6} = 's_f55plus';
legend_text{7} = 'f_m16to24';
legend_text{8} = 'f_m25to54';
legend_text{9} = 'f_m55plus';
legend_text{10} = 'f_f16to24';
legend_text{11} = 'f_f25to54';
legend_text{12} = 'f_f55plus';

Bands2Show = [68,95];

%% Save results
save(filename, '-v7.3')

end %estimation

if DO_PLOTS == 1 
    
wts = wgts;
Figspec = ['Figs_',spec];
%Figspec = ['Figs_',spec,'extra']; %comment this!
pathfig = ['~/Dropbox/CEGS/ReplicationFiles/State_Space_Flows/',Figspec];
    
% load results    

load(filename)


DO_PLOTS = 1;
SAVE_PLOTS=1;

% 1. Figures 4 and 5 in the draft
% flows
        % s
for jj = 1:n_s
sample_index = 1960:1/4:2018.5;

figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(squeeze(States(:,jj,:))'./100,sample_index,Bands2Show);
hold on
plot(sample_index,y(:,jj)./100,'k--')
xlim([1975,2018.5])
ng = [spec,legend_text{jj}]; 
title(ng);
if SAVE_PLOTS
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);

end
end

      % f
for jj = 1:n_f

figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(squeeze(States(:,3*n_s+jj,:))'./100,sample_index,Bands2Show);
hold on
plot(sample_index,y(:,n_s+jj)./100,'k--')
xlim([1975,2018.5])
ng = [spec,legend_text{n_s+jj}]; 
title(ng);
if SAVE_PLOTS
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end
end


% Prepare counterfactuals



sample_fixc = find(sample_index > 1985);
sample_fixcsd = find(sample_index == 1985);

sample_fixs = find(sample_index > 2006);
sample_fixssd = find(sample_index == 2006);

sample_fixsym = find(sample_index > 1995);
sample_fixsymd = find(sample_index == 1995);

%                   time,flows,draws
States_fixc = States(:,:,:);
for j = 1:length(sample_fixc)
States_fixc(sample_fixc(j),[4 5],:) = States(sample_fixcsd,[4 5],:);
end

States_fixcy = States(:,:,:);
for j = 1:length(sample_fixc)
States_fixcy(sample_fixc(j),[1 4 5],:) = States(sample_fixcsd,[1 4 5],:);
end

States_fixs = States(:,:,:);
for j = 1:length(sample_fixs)
States_fixs(sample_fixs(j),[1:6],:) = States(sample_fixssd,[1:6],:);
end

States_fixsel = States(:,:,:);
for j = 1:length(sample_fixs)
States_fixsel(sample_fixs(j),[1 4 5],:) = States(sample_fixssd,[1 4 5],:);
end

States_fixsel2 = States(:,:,:);
for j = 1:length(sample_fixs)
States_fixsel2(sample_fixs(j),[2 3 6],:) = States(sample_fixssd,[2 3 6],:);
end

States_fixsym = States(:,:,:);
for j = 1:length(sample_fixsym)
States_fixsym(sample_fixsym(j),1,:) = States(sample_fixsymd,1,:);
end

% compute ubar


wts_fixshare = repmat(wts(1,:),length(sample_index),1); %fix at 1976

% gender-specific sbar
for jj = 1:T
wts_male(jj,:) = wts(jj,1:3)./sum(wts(jj,1:3));
wts_female(jj,:)= wts(jj,4:6)./sum(wts(jj,4:6));
wtf_male(jj,:) = wts(jj,7:9)./sum(wts(jj,7:9));
wtf_female(jj,:)= wts(jj,10:12)./sum(wts(jj,10:12));
end

% Aggregate s
for jj = 1:T
s_male(jj) = wts_male(jj,:)*y(jj,1:3)';
s_female(jj) = wts_female(jj,:)*y(jj,4:6)';
s(jj) = wts(jj,1:6)*y(jj,1:n_s)';
s_fixw(jj) = wts_fixshare(jj,1:6)*y(jj,1:n_s)';
end

s(1:64) = y(1:64,1+n_f+n_s); % 1960:1/4:1975.75
% Aggregate sbar



%%

n_draws_swl = length(LogLik) ;
for gg = 1:n_draws_swl
for jj = 1:T

sbar(jj,gg) = wts(jj,1:6)*squeeze(States(jj,1:n_s,gg))';  
sbar_male(jj,gg) = wts_male(jj,:)*squeeze(States(jj,1:3,gg))';
sbar_female(jj,gg) = wts_female(jj,:)*squeeze(States(jj,4:6,gg))';
sbarfixcs(jj,gg) = wts(jj,1:6)*squeeze(States_fixc(jj,1:n_s,gg))'; 
sbarfixcys(jj,gg) = wts(jj,1:6)*squeeze(States_fixcy(jj,1:n_s,gg))'; 
sbarfixw(jj,gg) =  wts_fixshare(jj,1:6)*squeeze(States(jj,1:n_s,gg))';
sbarfixs(jj,gg) = wts(jj,1:6)*squeeze(States_fixs(jj,1:n_s,gg))'; 
sbarfixsel(jj,gg) = wts(jj,1:6)*squeeze(States_fixsel(jj,1:n_s,gg))'; 
sbarfixsel2(jj,gg) = wts(jj,1:6)*squeeze(States_fixsel2(jj,1:n_s,gg))'; 
sbarfixsym(jj,gg) = wts(jj,1:6)*squeeze(States_fixsym(jj,1:n_s,gg))'; 

end
end

% 2. Top  panel in figure 6 in the draft

figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(sbar'./100,sample_index,Bands2Show);
hold on
plot(sample_index,s./100,'k--')
ng = [spec,'aggregates']; 
%title(ng);

if SAVE_PLOTS

namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end



% Aggregate f
for jj = 1:T
    
f(jj) = wts(jj,n_s+1:end)*y(jj,n_s+1:n_s+n_f)';
f_male(jj)  = wtf_male(jj,:)*y(jj,n_s+1:n_s+3)';
f_female(jj) = wtf_female(jj,:)*y(jj,n_s+4:n_s+6)';
f_fixw(jj)      = wts_fixshare(jj,n_s+1:end)*y(jj,n_s+1:n_s+n_f)';
end

f(1:64) = y(1:64,2+n_f+n_s); % 1960:1/4:1975.75

% u
for jj = 1:T

    u(jj) = s(jj)./(s(jj)+f(jj));

end


% Aggregate fbar

%for gg = 1:length(LogLik) 
for gg = 1:n_draws_swl
for jj = 1:T
    
fbar(jj,gg) = wts(jj,n_s+1:end)*squeeze(States(jj,3*n_s+1:3*n_s+n_f,gg))';
fbar_male(jj,gg) = wtf_male(jj,:)*squeeze(States(jj,3*n_s+1:3*n_s+3,gg))';
fbar_female(jj,gg) = wtf_female(jj,:)*squeeze(States(jj,3*n_s+4:3*n_s+6,gg))';

fbarfixw(jj,gg) = wts_fixshare(jj,n_s+1:end)*squeeze(States(jj,3*n_s+1:3*n_s+n_f,gg))';

end
end

% 3. middle  panel in figure 6 in the draft


figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(fbar'./100,sample_index,Bands2Show);
hold on
plot(sample_index,f./100,'k--')
ng = [spec,'aggregatef']; 
%title(ng);

if SAVE_PLOTS

namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end

%% ubar

 load Joint_estimationCst_fUbar_mat ubar
 ubartp = ubar; clear ubar

for gg = 1:n_draws_swl
for jj = 1:T
    
ubar(jj,gg) = sbar(jj,gg)/(sbar(jj,gg)+fbar(jj,gg));
ubar_fixcs(jj,gg) = sbarfixcs(jj,gg)/(sbarfixcs(jj,gg)+fbar(jj,gg));
ubar_fixcys(jj,gg) = sbarfixcys(jj,gg)/(sbarfixcys(jj,gg)+fbar(jj,gg));
ubar_fixs(jj,gg) = sbarfixs(jj,gg)/(sbarfixs(jj,gg)+fbar(jj,gg));
ubar_fixw(jj,gg) = sbarfixw(jj,gg)/(sbarfixw(jj,gg)+fbarfixw(jj,gg));
ubar_fixsel(jj,gg) = sbarfixsel(jj,gg)/(sbarfixsel(jj,gg)+fbar(jj,gg)); 
ubar_fixsel2(jj,gg) = sbarfixsel2(jj,gg)/(sbarfixsel2(jj,gg)+fbar(jj,gg));
ubar_fixsym(jj,gg) = sbarfixsym(jj,gg)/(sbarfixsym(jj,gg)+fbar(jj,gg));

end
end

% 4. bottom  panel in figure 6 in the draft

% unemployment rate
ng = [spec,'ubarandu']; 
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(100*ubar',sample_index,Bands2Show);hold on
plot(sample_index,100*u,'k--')
if SAVE_PLOTS

namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end



% 5. (CounterfactuAL #3) third  panel in figure 7 in the draft

% Scenario 2:  holding fixed s of female < 55 and s of male < 25 starting in 1985
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(100*ubar',sample_index,Bands2Show);hold on

plot(sample_index,mean(100*ubar_fixcs,2),'r-','LineWidth',1.5)
plot(sample_index,mean(100*ubar_fixcys,2),'b-','LineWidth',1.5)
ylim([3.5 9])

ng = [spec,'ubar_fixwless55ym']; 
%title(ng);

if SAVE_PLOTS

namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end



% 6. (CounterfactuAL #2) second  panel in figure 7 in the draft

% Scenario 3.: holding fixed weights to 1976
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(100*ubar',sample_index,Bands2Show);hold on
plot(sample_index,mean(100*ubar_fixw,2),'r-','LineWidth',1.5)
ylim([4 9])
ng = [spec,'ubar_fixweights76']; 
%title(ng);

if SAVE_PLOTS

namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end


% 7. (CounterfactuAL #4) fourth  panel in figure 7 in the draft

% Scenario 4.: holding fixed s of men >24 and women > 54 since 2006
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
vcPlotDistBands(100*ubar',sample_index,Bands2Show);hold on
plot(sample_index,mean(100*ubar_fixsel2,2),'r-','LineWidth',1.5)
ylim([3.5 8])
xlim([2005 2018.5])
ng = [spec,'ubar_fixmw2006']; 
%title(ng);

if SAVE_PLOTS

namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end




%% ubar constnant f
% Scenario 5.: holding fixed f to its mean + holding individual means
% constnt and let the weights vary


fbarc = mean(f);
for gg = 1:n_draws_swl
for jj = 1:T
    
ubar_cf(jj,gg) = sbar(jj,gg)/(sbar(jj,gg)+fbarc);

end
end

% 8. (CounterfactuAL #1) first  panel in figure 7 in the draft

figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 8.1125])
plot(sample_index,100*mean(ubar_cf,2),'b-','LineWidth',1.5);
hold on
vcPlotDistBands(100*ubar',sample_index,Bands2Show);
plot(sample_index,100*mean(ubartp,2),'r-','LineWidth',1.5)
ylim([3.5 9])
ng = [spec,'ubar_cf']; 
%title(ng);

if SAVE_PLOTS

namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [pathfig,'\',namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [pathfig,'\',namesinglefig_pdf]);
end




% produces mean and std of ubar
ubar_std = std(100*ubar,0,2);
ubar_mean = mean(100*ubar,2);
% figure;plot(ubar_std)
% figure;plot(ubar_mean)

ubarStatname = [filename,'UbarStats'];
ubarname = [filename,'Ubar_mat'];
save(ubarStatname,'ubar_std', 'ubar_mean');
save(ubarname,'ubar');
%save UbarStats ubar_std ubar_mean
%save Ubar_mat ubar
end
return;

