clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
hazards = readtable('../csv/hazards_age_sa_quart.csv');

%% sa hazard rates figure by groups
figure;
hold on
f16to24 = plot(hazards.Date,hazards.f16to24,'LineWidth',1.5,'LineStyle','--','Color','k')
f25to54 = plot(hazards.Date,hazards.f25to54,'LineWidth',1.5,'LineStyle','-','Color','k')
f55plus = plot(hazards.Date,hazards.f55plus,'LineWidth',1.5,'LineStyle','-.','Color','k')
shadenber(gcf)
hold off
title('outflow rate (f) by age')
legend([f16to24 f25to54 f55plus], {'f 16-24','f 25-54','f 55plus'},'Location','northeast')
saveas(gcf,'../figure/right/hazards_age_f_sa_quart','epsc')

global ax1_YLim
figure; % s figure with separate axis
date = hazards.Date;
s16to24 = hazards.s16to24;
s25to54 = hazards.s25to54;
s55plus = hazards.s55plus;
s25to54=line(date, s25to54, 'LineWidth',1.5,'LineStyle','-','Color','k');
ax1=gca;
ax1.XColor = 'k';
ax1.YColor = 'k';
ax1.YLim = [0 0.065];
ax1_YLim = [0 0.065];
%ax1.YTick = 0:0.01:0.065;
ax1_pos = ax1.Position; % position of first axes
shadenber1(s25to54)
ax2 = axes('Position',ax1.Position,'XAxisLocation','bottom','YAxisLocation','right','Color','none');
ax2.YLim = [0.06 0.125];
%ax2.YTick = 0.065:0.01:0.13;
s55plus = line(date, s55plus,'Parent',ax1,'LineWidth',1.5,'LineStyle','-.','Color','k');
s16to24 = line(date, s16to24,'Parent',ax2,'LineWidth',1.5,'LineStyle','--','Color','k');
title('inflow rate (s) by age')
lgnd = legend([s16to24 s25to54 s55plus], {'s 16-24','s 25-54','s 55plus'},'Location','northeast')
set(lgnd,'color','none');
saveas(gcf,'../figure/right/hazards_age_s_sa_quart_sepaxis','epsc')

%close all

