clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
UU = readtable('../../output/u_sex_nsa.xlsx');
UU = table2array(UU);
date = UU(:,1)*100+01;
UU(:,1)=[];
[T,M] = size(UU);

for i=1:2
 U_sm(:,i) = UU(:,i);
end
for i=1:2
 U_m(:,i) =UU(:,i+2);
end
for i=1:2
 E_m(:,i) =UU(:,i+4);
end
for i=1:2
 N_m(:,i) =UU(:,i+6);
end

U(:,1) = U_m(:,1);
U(:,2) = U_m(:,2);

U_s(:,1) = U_sm(:,1);
U_s(:,2) = U_sm(:,2);

E(:,1) = E_m(:,1);
E(:,2) = E_m(:,2);

N(:,1) = N_m(:,1);
N(:,2) = N_m(:,2);

U_s(217:T,1) = 1.153209*U_s(217:T,1);
U_s(217:T,2) = 1.158577*U_s(217:T,2);

group = 2; % group size

%% calculate aggregate unemployment rates
urate = U./(U+E);
urate = [date urate];
urate = array2table(urate);
urate.Properties.VariableNames = {'Date' 'ur_men' 'ur_women'};
writetable(urate,'csv/urates_sex.csv');

%% calculate hazard rates for each group
for i=1:group
 F = 1 - ((U(2:end,i)-U_s(2:end,i))./U(1:end-1,i));
 Fall(:,i) = F;
end
fall = -log(1 - Fall);

opts = optimset('Display','off');
sall = ones(T-1,2);
s0   = 0.034;
for i=1:group
for t=1:T-1
    U_t = U(t,i);
    FU  = U(t+1,i);
    f_t = fall(t,i);
    Lf_t= U(t,i)+E(t,i);
    s(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = s(t);
end
sall(:,i) = s;
end

%% calculate aggregate hazard rates using total stocks
for t=1:T
    Utotal(t) = sum(U(t,1:group));
    Ustotal(t) = sum(U_s(t,1:group));
    Etotal(t) = sum(E(t,1:group));
    Ntotal(t) = sum(N(t,1:group));
    utotal(t) = Utotal(t)./(Utotal(t)+Etotal(t));
end

Ftotal = 1 - ((Utotal(2:end)-Ustotal(2:end))./Utotal(1:end-1));
ftotal = -log(1 - Ftotal);

opts = optimset('Display','off');
s0   = 0.034;
for t=1:T-1
    U_t = Utotal(t);
    FU  = Utotal(t+1);
    f_t = ftotal(t);
    Lf_t= Utotal(t)+Etotal(t);
    stotal(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = stotal(t);
end

%% calculate aggregate hazard rates using weighted sum of s and f
for i=1:group
weights(:,i) = (E(:,i)+N(:,i))./(Etotal'+Ntotal'); % s and f weight
weightf(:,i) = U(:,i)./Utotal';
popshare(:,i) = (E(:,i)+N(:,i)+U(:,i))./(Etotal'+Ntotal'+Utotal'); % population share
lfshare(:,i) = (E(:,i)+U(:,i))./(Etotal'+Utotal'); % labor force share
end

for i=1:T-1
stotal_ws(i,:) = sum(sall(i,:).*weights(i,:),2);
end

for i=1:T-1
ftotal_ws(i,:) = sum(fall(i,:).*weightf(i,:),2);
end

weight = [date weights weightf lfshare popshare];
weight = array2table(weight);
weight.Properties.VariableNames = {'Date' 'sw_men' 'sw_women' 'fw_men' 'fw_women' 'lfshare_men' 'lfshare_women' 'popshare_men' 'popshare_women'};
writetable(weight,'csv/weights_sex.csv');

hazrate = [date(1:T-1,:) fall sall ftotal_ws stotal_ws ftotal' stotal'];
hazrate = array2table(hazrate);
hazrate.Properties.VariableNames = {'Date' 'f_men' 'f_women' 's_men' 's_women'...
    'f_act_ws' 's_act_ws' 'f_act_total' 's_act_total'};
writetable(hazrate,'csv/hazards_sex.csv');
