clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
UU = readtable('../../output/u_ind_nsa.xlsx');

% check U_s trend for mining
date = UU.date*100+01;
date = num2str(date);
date=datenum(date,'yyyymmdd');
figure;
U5_mining = plot(date,UU.U5_mining,'LineWidth',1.5)
datetick('x','yyyy','keepticks')
saveas(gcf,'U5_mining','epsc')

U5_mining_avg=mean(UU.U5_mining);



UU = table2array(UU);
date = UU(:,1)*100+01;
year = floor(UU(:,1)/100);
UU(:,1)=[];
[T,M] = size(UU);

group = 9; % group size

for i=1:group
 U_sm(:,i) = UU(:,i);
end
for i=1:group
 U_m(:,i) =UU(:,i+group);
end
for i=1:group
 E_m(:,i) =UU(:,i+group*2);
end
for i=1:group
 N_m(:,i) =UU(:,i+group*3);
end

U_sm(217:end,:) = 1.1*U_sm(217:end,:);

group = 8; % group size - drop missing ind group
U = U_m(:,1:group);
U_s = U_sm(:,1:group);
E = E_m(:,1:group);
N = N_m(:,1:group);

% if 0 stock make it NaN
U(U==0)=NaN;
U_s(U_s==0)=NaN;
E(E==0)=NaN;
N(N==0)=NaN;

%% calculate aggregate unemployment rates
urate = U./(U+E);
urate = [date urate];
urate = array2table(urate);
ur_names = readtable('ur_names.xlsx');
urate.Properties.VariableNames = ur_names.Properties.VariableNames;
writetable(urate,'csv/urates_ind.csv');

%% calculate hazard rates for each group
for i=1:group
 F = 1 - ((U(2:end,i)-U_s(2:end,i))./U(1:end-1,i));
 Fall(:,i) = F;
end
Fall(Fall >= 1) = NaN; % define Fall to be NaN if >=1 - this might be the case due to adjustment factor
fall = -log(1 - Fall);
fall_nan=isnan(fall);
% change all NaN to some number to be able to use fsolve below
fall(fall_nan)=0.5;
U_nan=isnan(U);
U(U_nan)=0.5;
E_nan=isnan(E);
E(E_nan)=0.5;

opts = optimset('Display','off');
sall = ones(T-1,group);
s0   = 0.034;
for i=1:group
for t=1:T-1
    U_t = U(t,i);
    FU  = U(t+1,i);
    f_t = fall(t,i);
    Lf_t= U(t,i)+E(t,i);
    s(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = s(t);
end
sall(:,i) = s;
end

% change entries with NaN stocks back to be NaN
fall(fall_nan)=NaN;
sall(fall_nan)=NaN;
sall(U_nan(1:T-1,:))=NaN;
sall(U_nan(2:T,:))=NaN;
sall(E_nan(1:T-1,:))=NaN;

U(U_nan)=NaN;
E(E_nan)=NaN;

%% calculate aggregate hazard rates using total stocks
for t=1:T
    Utotal(t) = nansum(U(t,1:group));
    Ustotal(t) = nansum(U_s(t,1:group));
    Etotal(t) = nansum(E(t,1:group));
    Ntotal(t) = nansum(N(t,1:group));
    utotal(t) = Utotal(t)./(Utotal(t)+Etotal(t));
end

Ftotal = 1 - ((Utotal(2:end)-Ustotal(2:end))./Utotal(1:end-1));
ftotal = -log(1 - Ftotal);

opts = optimset('Display','off');
s0   = 0.034;
for t=1:T-1
    U_t = Utotal(t);
    FU  = Utotal(t+1);
    f_t = ftotal(t);
    Lf_t= Utotal(t)+Etotal(t);
    stotal(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = stotal(t);
end

%% calculate aggregate hazard rates using weighted sum of s and f
for i=1:group
weights(:,i) = (E(:,i)+N(:,i))./(Etotal'+Ntotal'); % s and f weight
weightf(:,i) = U(:,i)./Utotal';
popshare(:,i) = (E(:,i)+N(:,i)+U(:,i))./(Etotal'+Ntotal'+Utotal'); % population share
end

for i=1:T-1
stotal_ws(i,:) = nansum(sall(i,:).*weights(i,:),2);
end

for i=1:T-1
ftotal_ws(i,:) = nansum(fall(i,:).*weightf(i,:),2);
end

weight = [date weights weightf popshare];
weight = array2table(weight);
weight_names = readtable('weight_names.xlsx');
weight.Properties.VariableNames = weight_names.Properties.VariableNames;
writetable(weight,'csv/weights_ind.csv');

hazrate = [date(1:T-1,:) fall sall ftotal_ws stotal_ws ftotal' stotal'];
hazrate = array2table(hazrate);
haz_names = readtable('haz_names.xlsx');
hazrate.Properties.VariableNames = haz_names.Properties.VariableNames;
writetable(hazrate,'csv/hazards_ind.csv');
