clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
hazards = readtable('csv/hazards_age_sa_quart.csv');
weights = readtable('csv/weights_age_sa_quart.csv');

%% sa hazard rates figure by groups
figure;
hold on
f16to24 = plot(hazards.Date,hazards.f16to24,'LineWidth',1.5,'LineStyle','--','Color','k')
f25to54 = plot(hazards.Date,hazards.f25to54,'LineWidth',1.5,'LineStyle','-','Color','k')
f55plus = plot(hazards.Date,hazards.f55plus,'LineWidth',1.5,'LineStyle','-.','Color','k')
f_agg = plot(hazards.Date,hazards.f_act_ws,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('quarterly sa outflow rate (f) by age')
legend([f16to24 f25to54 f55plus f_agg], {'f 16-24','f 25-54','f 55plus','f agg'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_f_sa_quart','epsc')

figure;
hold on
s16to24 = plot(hazards.Date,hazards.s16to24,'LineWidth',1.5,'LineStyle','--','Color','k')
s25to54 = plot(hazards.Date,hazards.s25to54,'LineWidth',1.5,'LineStyle','-','Color','k')
s55plus = plot(hazards.Date,hazards.s55plus,'LineWidth',1.5,'LineStyle','-.','Color','k')
s_agg = plot(hazards.Date,hazards.s_act_ws,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('quarterly sa inflow rate (s) by age')
legend([s16to24 s25to54 s55plus s_agg], {'s 16-24','s 25-54','s 55plus','s agg'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_s_sa_quart','epsc')

global ax1_YLim
figure; % s figure with separate axis
date = hazards.Date;
s16to24 = hazards.s16to24;
s25to54 = hazards.s25to54;
s55plus = hazards.s55plus;
s25to54=line(date, s25to54, 'LineWidth',1.5,'LineStyle','-','Color','k');
ax1=gca;
ax1.XColor = 'k';
ax1.YColor = 'k';
ax1.YLim = [0 0.065];
ax1_YLim = [0 0.065];
%ax1.YTick = 0:0.01:0.065;
ax1_pos = ax1.Position; % position of first axes
shadenber1(s25to54)
ax2 = axes('Position',ax1.Position,'XAxisLocation','bottom','YAxisLocation','right','Color','none');
ax2.YLim = [0.06 0.125];
%ax2.YTick = 0.065:0.01:0.13;
s55plus = line(date, s55plus,'Parent',ax1,'LineWidth',1.5,'LineStyle','-.','Color','k');
s16to24 = line(date, s16to24,'Parent',ax2,'LineWidth',1.5,'LineStyle','--','Color','k');
title('quarterly sa inflow rate (s) by age')
lgnd = legend([s16to24 s25to54 s55plus], {'s 16-24','s 25-54','s 55plus'},'Location','northeast')
set(lgnd,'color','none');
saveas(gcf,'../../tex/figure/age/hazards_age_s_sa_quart_sepaxis','epsc')

close all

%% weights figure by groups
figure;
hold on
sw_16to24 = plot(weights.Date,weights.sw_16to24,'LineWidth',1.5,'LineStyle','--','Color','k')
sw_25to54 = plot(weights.Date,weights.sw_25to54,'LineWidth',1.5,'LineStyle','-','Color','k')
sw_55plus = plot(weights.Date,weights.sw_55plus,'LineWidth',1.5,'LineStyle','-.','Color','k')
shadenber(gcf)
hold off
title('quarterly sa s weights by age')
legend([sw_16to24 sw_25to54 sw_55plus], {'s weights 16to24','s weights 25to54','s weights 55plus'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/weights_age_s_sa_quart','epsc') % quarterly sa

figure;
hold on
fw_16to24 = plot(weights.Date,weights.fw_16to24,'LineWidth',1.5,'LineStyle','--','Color','k')
fw_25to54 = plot(weights.Date,weights.fw_25to54,'LineWidth',1.5,'LineStyle','-','Color','k')
fw_55plus = plot(weights.Date,weights.fw_55plus,'LineWidth',1.5,'LineStyle','-.','Color','k')
shadenber(gcf)
hold off
title('quarterly sa f weights by age')
legend([fw_16to24 fw_25to54 fw_55plus], {'f weights 16to24','f weights 25to54','f weights 55plus'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/weights_age_f_sa_quart','epsc') % quarterly sa

figure;
hold on
lfs_16to24 = plot(weights.Date,weights.lfshare_16to24,'LineWidth',1.5,'LineStyle','--','Color','k')
lfs_25to54 = plot(weights.Date,weights.lfshare_25to54,'LineWidth',1.5,'LineStyle','-','Color','k')
lfs_55plus = plot(weights.Date,weights.lfshare_55plus,'LineWidth',1.5,'LineStyle','-.','Color','k')
shadenber(gcf)
hold off
title('quarterly sa labor force share by age')
legend([lfs_16to24 lfs_25to54 lfs_55plus], {'lfs 16to24','lfs 25to54','lfs 55plus'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/lfshare_age_sa_quart','epsc') % quarterly sa

close all

%% shift-share (calculate hazard rates holding weight constant at 2000Q2/1993Q1)
group=3;
T=height(hazards);

weights2000 = table2array([weights(98,2:group+1)]);
weightf2000 = table2array([weights(98,2+group:group+1+group)]);
weights1993 = table2array([weights(69,2:group+1)]);
weightf1993 = table2array([weights(69,2+group:group+1+group)]);

fall=table2array(hazards(:,2:group+1));
fall_2000=fall(98:end,:);
fall_1993=fall(69:end,:);
sall=table2array(hazards(:,2+group:group+1+group));
sall_2000=sall(98:end,:);
sall_1993=sall(69:end,:);

for i=1:size(sall_2000,1)
s_ws_counter_2000(i,:) = sum(sall_2000(i,:).*weights2000,2);
end
s_ws_counter_2000(1,:)=hazards.s_act_ws(98,:);

for i=1:size(sall_1993,1)
s_ws_counter_1993(i,:) = sum(sall_1993(i,:).*weights1993,2);
end
s_ws_counter_1993(1,:)=hazards.s_act_ws(69,:);

for i=1:size(fall_2000,1)
f_ws_counter_2000(i,:) = sum(fall_2000(i,:).*weightf2000,2);
end
f_ws_counter_2000(1,:)=hazards.f_act_ws(98,:);

for i=1:size(fall_1993,1)
f_ws_counter_1993(i,:) = sum(fall_1993(i,:).*weightf1993,2);
end
f_ws_counter_1993(1,:)=hazards.f_act_ws(69,:);

hazards_ss_2000 = cat(2,hazards(98:T,:), array2table(f_ws_counter_2000));
hazards_ss_2000 = cat(2,hazards_ss_2000, array2table(s_ws_counter_2000));
hazards_ss_1993 = cat(2,hazards(69:T,:), array2table(f_ws_counter_1993));
hazards_ss_1993 = cat(2,hazards_ss_1993, array2table(s_ws_counter_1993));

writetable(hazards_ss_2000,'csv/hazards_age_ss_2000_sa.csv');
writetable(hazards_ss_1993,'csv/hazards_age_ss_1993_sa.csv');



figure;
hold on
f_agg = plot(hazards_ss_2000.Date,hazards_ss_2000.f_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
f_agg_ss = plot(hazards_ss_2000.Date,hazards_ss_2000.f_ws_counter_2000,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('age shift share quarterly sa outflow rate (f) 2000Q2')
legend([f_agg f_agg_ss], {'f agg','f agg ss'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_f_sa_quart_ss_2000','epsc')

figure;
hold on
f_agg = plot(hazards_ss_1993.Date,hazards_ss_1993.f_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
f_agg_ss = plot(hazards_ss_1993.Date,hazards_ss_1993.f_ws_counter_1993,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('age shift share quarterly sa outflow rate (f) 1993Q1')
legend([f_agg f_agg_ss], {'f agg','f agg ss'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_f_sa_quart_ss_1993','epsc')


figure;
hold on
s_agg = plot(hazards_ss_2000.Date,hazards_ss_2000.s_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
s_agg_ss = plot(hazards_ss_2000.Date,hazards_ss_2000.s_ws_counter_2000,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('age shift share quarterly sa inflow rate (s) 2000Q2')
legend([s_agg s_agg_ss], {'s agg','s agg ss'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_s_sa_quart_ss_2000','epsc')


figure;
hold on
s_agg = plot(hazards_ss_1993.Date,hazards_ss_1993.s_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
s_agg_ss = plot(hazards_ss_1993.Date,hazards_ss_1993.s_ws_counter_1993,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('age shift share quarterly sa inflow rate (s) 1993Q1')
legend([s_agg s_agg_ss], {'s agg','s agg ss'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_s_sa_quart_ss_1993','epsc')


weights1976 = table2array([weights(1,2:group+1)]);
weightf1976 = table2array([weights(1,2+group:group+1+group)]);

fall=table2array(hazards(:,2:group+1));
fall_1976=fall(1:end,:);
sall=table2array(hazards(:,2+group:group+1+group));
sall_1976=sall(1:end,:);

for i=1:size(sall_1976,1)
s_ws_counter_1976(i,:) = sum(sall_1976(i,:).*weights1976,2);
end
s_ws_counter_1976(1,:)=hazards.s_act_ws(1,:);

for i=1:size(fall_1976,1)
f_ws_counter_1976(i,:) = sum(fall_1976(i,:).*weightf1976,2);
end
f_ws_counter_1976(1,:)=hazards.f_act_ws(1,:);

hazards_ss_1976 = cat(2,hazards(1:T,:), array2table(f_ws_counter_1976));
hazards_ss_1976 = cat(2,hazards_ss_1976, array2table(s_ws_counter_1976));

writetable(hazards_ss_1976,'csv/hazards_age_ss_1976_sa.csv');

figure;
hold on
s_agg = plot(hazards_ss_1976.Date,hazards_ss_1976.s_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
s_agg_ss = plot(hazards_ss_1976.Date,hazards_ss_1976.s_ws_counter_1976,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('age shift share quarterly sa inflow rate (s) 1976Q1')
legend([s_agg s_agg_ss], {'s agg','s agg ss'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_s_sa_quart_ss_1976','epsc')

figure;
hold on
f_agg = plot(hazards_ss_1976.Date,hazards_ss_1976.f_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
f_agg_ss = plot(hazards_ss_1976.Date,hazards_ss_1976.f_ws_counter_1976,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('age shift share quarterly sa outflow rate (f) 1976Q1')
legend([s_agg s_agg_ss], {'s agg','s agg ss'},'Location','northeast')
saveas(gcf,'../../tex/figure/age/hazards_age_f_sa_quart_ss_1976','epsc')

%close all

