%   - y[T x n]:  Series
%   - C[n x ns]: Maps series to states
%   - R[n x n]:  Variance covariance matrix of state equation
%   - A[ns x ns]:  Factor transition equation
%   - Q[ns x ns]:  Variance-covariance matrix of transition equation. 
%   - S0[ns x ns]: Initial states
%   - P0[ns x ns]: MSE matrix
function kf = KF(y,ws,C,R,A,Q,S0,P0,n_s,n_f)

T = size(y,1);
ns = size(C,2);  % Number of states
Sprev = S0;
Pprev  = P0;

LogLik = 0;

 S = zeros(T,ns)*NaN;
 P = zeros(ns,ns,T)*NaN;
Sf = zeros(T,ns)*NaN;
Pf = zeros(ns,ns,T)*NaN;
    
 % Add the two observables to the C matrix
 Theta_s = C(1:n_s,(3*n_s+2*n_f+1));
 Theta_f = C([n_s+1:(n_s+n_f)],(3*n_s+2*n_f+2));
 Ctv = [C;zeros(2,ns)];
    
for t = 1:T  % Loop through time t
    Sft = A*Sprev;       % Forecast for states
    Pft = A*Pprev*A' + Q;  % MSE of forecast
    yt = y(t,:)';
    
    % Update time-varying component
    Ctv(end-1,1:3*n_s) = [ws(t,1:n_s), zeros(1,n_s), ws(t,1:n_s)];
    Ctv(end-1,(3*n_s+2*n_f+1)) = ws(t,1:n_s)*Theta_s;
    Ctv(end,3*n_s+1:(3*n_s+2*n_f)) = [ws(t,n_s+1:end), ws(t,n_s+1:end)];
    Ctv(end,3*n_s+2*n_f+2) = ws(t,n_s+1:end)*Theta_f;
    
    
    % Remove missing values
    Miss = isnan(yt);
    yt = yt(Miss==0);  
    Ct = Ctv(Miss==0,:);
    Rt = R(Miss==0,Miss==0);
    
    
    yf = Ct*Sft;               % y_t|t-1
   % iV  = inv(Ct*Pft*Ct'+Rt);  % inv(E[(y_t - y_t|t-1)(y_t - y_t|t-1)'])
    iV  = (Ct*Pft*Ct'+Rt)\eye(size(Ct,1));  % inv(E[(y_t - y_t|t-1)(y_t - y_t|t-1)'])
    Gain = Pft*Ct'*iV;         % Kalman gain
    St  = Sft + Gain*(yt-yf);  
    Pt  = Pft - Gain*Ct*Pft;
    LogLik = LogLik + .5*log(det(iV))-.5*(yt-yf)'*iV*(yt-yf)-.5*(2*pi);
    

    S(t,:) = St';
    P(:,:,t) = Pt;
    Sf(t,:) = Sft';
    Pf(:,:,t) = Pft;
    Sprev = St;
    Pprev = Pt;
end;

kf.LogLik = LogLik;
kf.S=S;
kf.P=P;
kf.S0=S0;
kf.P0=P0;
kf.Sf=Sf;
kf.Pf=Pf;
kf.A=A;
kf.Q=Q;
kf.C =C;
kf.R = R;