function kc = KC(kf);

S  = kf.S;
P  = kf.P;
Sf = kf.Sf;
Pf = kf.Pf;
S0 = kf.S0;
P0 = kf.P0;
A = kf.A;

[T,ns] = size(S);
drS = zeros(T,ns)*NaN;
mu = S(T,:)';
sigma = P(:,:,T)';
[U,D,V] = svd(sigma);
draw = mu + U*sqrt(D)*V'*randn(size(mu));
% sigma = .5*sigma+.5*sigma'+1e-6*eye(ns)*mean(diag(sigma));  % Symmetric, nonzero diagonal
% draw = mu + chol(sigma)'*randn(size(mu));
drS(T,:) = draw';

for t=T-1:-1:1
  %  iPf = pinv(Pf(:,:,t+1));
    
     % Compute inverse using singular value decomposition
        
        %%%%%%%%
        
    P_star = Pf(:,:,t+1);    
        
    [u,s,v] = svd(P_star);

    md = min(size(s));
    bigev = find(diag(s(1:md,1:md))>1e-6);
    sigpropdim = length(bigev);


for i = 1:md
    if i > sigpropdim
        s(i,i) = 0;
    else
        s(i,i)    = 1/s(i,i);
    end
end

    iPf = v*s*u';

    
    %%%%%%%
    
    
    mu =  S(t,:)'+P(:,:,t)*A'*iPf*(drS(t+1,:)-Sf(t+1,:))';
    sigma  =  P(:,:,t) - P(:,:,t)*A'*iPf*A*P(:,:,t);
    [U,D,V] = svd(sigma);
draw = mu + U*sqrt(D)*V'*randn(size(mu));
%     sigma = .5*sigma+.5*sigma'+1e-6*eye(ns)*mean(diag(sigma));
%     draw = mu + chol(sigma)'*randn(size(mu));
    drS(t,:) = draw';
end;

% iPf = pinv(Pf(:,:,1));
 P_star = Pf(:,:,1);    
        
    [u,s,v] = svd(P_star);

    md = min(size(s));
    bigev = find(diag(s(1:md,1:md))>1e-6);
    sigpropdim = length(bigev);


for i = 1:md
    if i > sigpropdim
        s(i,i) = 0;
    else
        s(i,i)    = 1/s(i,i);
    end
end

    iPf = v*s*u';




mu =  S0+P0*A'*iPf*(drS(1,:)'-Sf(1,:)');
sigma  =  P0 - P0*A'*iPf*A*P0;

[U,D,V] = svd(sigma);
draw = mu + U*sqrt(D)*V'*randn(size(mu));

% sigma = .5*sigma+.5*sigma'+1e-6*eye(ns)*mean(diag(sigma));
% draw = mu + chol(sigma)'*randn(size(mu));



drS0 = draw;
kc.S  = drS;
kc.S0 = drS0;
