%function Main_mode(iter)
clear;
% Computes mode
addpath Routines
addpath UseData
%iter=2;

%% Setup
DO_General = 0; % specification with correlated shocks
DO_Mode =1;
DO_ModalPreds = 1;
SAVE_PLOTS =0;
DO_Hessian =0;
DO_MH = 0;
DO_CK = 0;


% load data
%load FlowsBarni sflows_b
load Barniflows_saJin flows_saJin
y = flows_saJin(:,7:end);

for jk = 1:6
    
    yq(:,jk) = mean(reshape(y(:,jk),3,size(y,1)/3)',2);
end   
y = 100*yq;

[T,n] = size(y);


p = 1; % Number of lags in the VAR for the cycle component

% Define params and priors for the theta vector using my files

% params1_index.Gamma = 1; params1_fixed(params1_index.Gamma,1) = 0; 
% params2_index.Obs_shocks = 1; params2_fixed(params2_index.Obs_shocks,1) = 0;
% params3_index.Sigeta = 1;     params3_fixed(params3_index.Sigeta,1) = 0;
% params4_index.omega = 1;     params4_fixed(params4_index.omega,1) = 0;
% 
% priors1.Gamma.shape        = 'gampdf';         priors1.Gamma.mean       = 1;      priors1.Gamma.std  = 0.5;     
% priors2.Obs_shocks.shape   = 'invgampdf';      priors2.Obs_shocks.mean  = 0.1;    priors2.Obs_shocks.std = 2;
% priors3.Sigeta.shape      = 'invgampdf';       priors3.Sigeta.mean = 0.1;      priors3.Sigeta.std = 2;
% priors4.omega.shape       = 'gampdf';          priors4.omega.mean = 0.8;      priors4.omega.std = 0.6;
% 
% [priors1_est] = assignPriorParams(priors1,params1_fixed, params1_index);
% [priors2_est] = assignPriorParams(priors2,params2_fixed, params2_index);
% [priors4_est] = assignPriorParams(priors4,params4_fixed, params4_index);

if DO_Mode
    
% Priors    
dfpsi = 1+2; % degrees of freedom for AR var prior, d
Psi =   (0.1).^2;
SC0tr =    ones(n,1).^2/100;
df0tr = 100;  % Degrees of freedom for trends
df0eps = 10; % Degrees of freedom for individual IID disturbances
SC0trg =   1.^2/100; % Initial conditions Q for common slow-moving trend 
SC0eps = ones(n,1).^2/10;  % Initial conditions Q for iindividual IID disturbances/VCV prior
lambda = 1.25;
b0 = 0; 
mean_theta = 1;
std_theta = .5; %25;%35;

% Optimization
trsf = 1;

%initial parameters
Theta_mode = ones(n-1,1);
sigma_mode = 100^2*exp(-8);%Psi;
SCtr_mode = 100^2*ones(n,1)*exp(-12);%ones(n,1).^2/100;
SCeps_mode = 100^2*ones(n,1)*exp(-4);%ones(n,1).^2/10;
psi_mode = zeros(n,1);
phi_mode = 0.5;

x0 = Theta_mode;
x0 = [x0;log(sigma_mode)];
x0 = [x0;log(SCtr_mode)];
x0 = [x0;log(SCeps_mode)];
% Comment for IID shocks
x0 = [x0;psi_mode];
x0 = [x0;phi_mode];
%x0 = [x0;log(sigma_mode)];

load Rez_alts100 x 


x0 = x;

% Find mode

% Fminsearch setup
stop_crit_x = 1e-8; stop_crit_f = 1e-8; maxits = 15000;
max_funevals = 48000;%1.5*maxits;
options = optimset('Display','iter','TolX',stop_crit_x,'TolFun',stop_crit_f,'MaxFunEvals',max_funevals,'MaxIter',15000);

% Csminwel setup
size_vector = 1e-4.*ones(length(x0),1);
GMat = diag(size_vector);
csmwmaxeval = 25;




%  options = optimset('Display','iter','TolX',stop_crit_x,'TolFun',stop_crit_f,'MaxFunEvals',max_funevals,'MaxIter',15000);
% 
%  
 [opt_x,fval,exitflag,output] = fminunc('OBJ_mode',x0,options,trsf,n,p,y,Psi,dfpsi,df0tr,df0eps,lambda,SC0trg,SC0tr,SC0eps,b0,mean_theta,std_theta);
 
 [opt_x,fval,exitflagfs,output] = fminsearch('OBJ_mode',opt_x,options,trsf,n,p,y,Psi,dfpsi,df0tr,df0eps,lambda,SC0trg,SC0tr,SC0eps,b0,mean_theta,std_theta);

 
% [fval,opt_x,gh,H,itct,fcount,retcodeh] = csminwel('OBJ_mode',opt_x,GMat,[],1e-8,csmwmaxeval,trsf,n,p,y,Psi,dfpsi,df0tr,df0eps,lambda,SC0trg,SC0tr,SC0eps,b0,mean_theta,std_theta);
                                     
% options = optimset('Display','iter','TolX',stop_crit_x,'TolFun',stop_crit_f,'MaxFunEvals',max_funevals,'MaxIter',20);
% 
 [opt_x,fval,exitflag,output] = fminunc('OBJ_mode',opt_x,options,trsf,n,p,y,Psi,dfpsi,df0tr,df0eps,lambda,SC0trg,SC0tr,SC0eps,b0,mean_theta,std_theta);
%  
[opt_x,fval,exitflagfs,output] = fminsearch('OBJ_mode',opt_x,options,trsf,n,p,y,Psi,dfpsi,df0tr,df0eps,lambda,SC0trg,SC0tr,SC0eps,b0,mean_theta,std_theta);
 
% tranform params


% opt_xtrf = [];
% 
% Theta = exp(opt_x(1:1 + n_sig_obs));
% 
% opt_xtrf = [opt_xtrf;exp(opt_x(1:1 + n_sig_obs))];
% 
% Phi = reshape(opt_x(1 + n_sig_obs+1:1 + n_sig_obs+n*n),n,n);
% Phi(1,1) =exp(Phi(1,1));
% Phi(2,2) =exp(Phi(2,2));
% Phi(3,3) =exp(Phi(3,3));
% opttmp = opt_x(1 + n_sig_obs+1:1 + n_sig_obs+n*n);
% opttmp([1 5 9]) = exp(opttmp([1 5 9]));
% opt_xtrf = [opt_xtrf;opttmp];
% 
% Sigma_vec_offdiag = opt_x(1 + n_sig_obs+n*n+1:1 + n_sig_obs+n*n+n); 
% 
% opt_xtrf = [opt_xtrf; opt_x(1 + n_sig_obs+n*n+1:1 + n_sig_obs+n*n+n)];
%  
%  idx_offdiag = tril(ones(n))-eye(n);
%  Sigma_nu = zeros(n);
%  Sigma_nu(logical(idx_offdiag)) = Sigma_vec_offdiag;
%  Sigma_vec_diag = exp(opt_x(1 + n_sig_obs+n*n+n+1:1 + n_sig_obs+n*n+n+n)); 
%  
%  opt_xtrf = [opt_xtrf; exp(opt_x(1 + n_sig_obs+n*n+n+1:1 + n_sig_obs+n*n+n+n))];
%  
%  idx_diag = eye(n);
%  Sigma_nu(logical(idx_diag)) = Sigma_vec_diag;
% 
%  Sig_nu  = Sigma_nu*Sigma_nu';
% 
%  Sig_eta = diag(exp(opt_x(1 + n_sig_obs+n*n+n+n+1:1 + n_sig_obs+n*n+n+n+n)));
% opt_xtrf = [opt_xtrf; exp(opt_x(1 + n_sig_obs+n*n+n+n+1:1 + n_sig_obs+n*n+n+n+n))];
% %return
% save Modev10cMinnx0 fval Theta Phi Sig_nu Sig_eta dfpsi Psi_nu lambda bdiag opt_xtrf

end

if DO_ModalPreds
trsf=1;
x= opt_x;

    Theta = [x(1);1;x(2:n-1)];
    
    sigma = exp(x(n));
  
 Q  = zeros(2*n+1);
 
 Acyc = zeros(n+1);
 
 Acyc(1:n,1:n) = diag(x(3*n+1:4*n));
 Acyc(end,end) =  x(4*n+1); 

% IID eps
%  Acyc(1:n,1:n) = zeros(n);%diag(x(3*n+1:4*n));
%  Acyc(end,end) =  x(3*n+1); 
 
 
A = [eye(n)   eye(n)  zeros(n,n+1)
      zeros(n) eye(n)  zeros(n,n+1)
      zeros(n+1,2*n) Acyc];
 


V = [eye(n) zeros(n,n+1)
      eye(n) zeros(n) zeros(n,1)
      zeros(n) eye(n) zeros(n,1)
      zeros(1,2*n) 1];
 
 if trsf == 1
     
 Q(1:n,1:n)                = diag(exp(x(n+1:2*n)));
 Qeps                      = diag(exp(x(2*n+1:3*n)));
 Q(n+1:2*n,n+1:2*n)    = Qeps;
 Q(end,end)                = sigma;
 
 Qcyc = Q(n+1:2*n+1, n+1:2*n+1);
  
 Q = V*Q*V';


C = zeros(n,3*n+1);
C(:,1:n) = eye(n); % indiviadual trends
C(:,2*n+1:3*n) = eye(n); % individual IID disturbances

C(:,end)        = Theta;

R = eye(n)*1e-12;

% Initial conditions

%S0tr  =     zeros(2*n,1);  % Initial conditions for individual trends
S0tr  =     6*ones(2*n,1);  % Initial conditions for individual trends
%S0tr  =     [6*ones(n,1);zeros(n,1)]; % Initial conditions for individual trends

S0eps = zeros(n,1);  % Initialize individual IID disturbances
S0cyc = 0; % Initialize common cyclical component
S0    = [S0tr;S0eps;S0cyc];

P0tr = 10000*diag(ones(2*n,1).^2);
P0    = zeros(3*n+1);
%P0cyc         = 1/(1-Acyc^2);%dlyap(Acyc,Q(end,end));
P0(1:2*n,1:2*n)     = P0tr;
% P0(2*n+1:3*n,2*n+1:3*n) = Qeps;
% P0(end,end)     = P0cyc;
vecP0cyc = (eye((n+1)^2)-kron(Acyc,Acyc))\Qcyc(:);
P0cyc = reshape(vecP0cyc,n+1,n+1);
P0(2*n+1:end,2*n+1:end) = P0cyc;


        
    
end % trsf
 

kf = KF(y,C,R,A,Q,S0,P0);
kc   = KC(kf);
%save TEstTonight 
%save Rez_Test100 x kc kf n % this is a new name. nothing is saved with
%this name yet

figure;plot(y(:,1),'k')
hold on
plot(kc.S(:,1),'r')
plot(kc.S(:,1)+Theta(1)*kc.S(:,end),'b--')
title('s_m16to24')

if SAVE_PLOTS
ng = 's_m16to24'; 
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);
end

figure;plot(y(:,2),'k')
hold on
plot(kc.S(:,2),'r')
plot(kc.S(:,2)+Theta(2)*kc.S(:,end),'b--')
title('s_m25to54')

if SAVE_PLOTS
ng = 's_m25to54'; 
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);
end

figure;plot(y(:,3),'k')
hold on
plot(kc.S(:,3),'r')
plot(kc.S(:,3)+Theta(3)*kc.S(:,end),'b--')
title('s_m55plus')

if SAVE_PLOTS
ng = 's_m55plus'; 
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);
end

figure;plot(y(:,4),'k')
hold on
plot(kc.S(:,4),'r')
plot(kc.S(:,4)+Theta(4)*kc.S(:,end),'b--')
title('s_f16to24')
if SAVE_PLOTS
ng = 's_f16to24'; 
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);
end

figure;plot(y(:,5),'k')
hold on
plot(kc.S(:,5),'r')
plot(kc.S(:,5)+Theta(5)*kc.S(:,end),'b--')
title('s_f25to54')

if SAVE_PLOTS
ng = 's_f25to54'; 
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);
end

figure;plot(y(:,6),'k')
hold on
plot(kc.S(:,6),'r')
plot(kc.S(:,6)+Theta(6)*kc.S(:,end),'b--')
title('s_f55plus')
if SAVE_PLOTS
ng = 's_f55plus'; 
namesinglefig_eps = [char(strcat(ng,'.eps'))];
namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);
end

end    
    
%%%%%
return
%%%%%%
if DO_Hessian
    
   % load Modev4MLx0 fval opt_xtrf
    load Modev10cMinnx0 fval opt_xtrf lambda bdiag dfpsi Psi_nu
    b0 = zeros(n*p,n); b0(1:n,1:n) = eye(n)*bdiag;
    
ComputeHessian

end

if DO_MH
    % This is the latest estimate (as of November 8) 
    load Modev10cMinnx0 fval opt_xtrf lambda bdiag dfpsi Psi_nu
      b0 = zeros(n*p,n); b0(1:n,1:n) = eye(n)*bdiag;
    load Hessian10bMinn sigscaleHess

    MH
end

if DO_CK
  
   load Alldraws X_select_draws_all
   
% n_draws_swl = 20000;
% 
% All_draws = X_select_draws_all;
% 
%  drawsel = randperm(size(All_draws,2));
% 
% X_select_draws = All_draws(:,drawsel(1:min(n_draws_swl,size(All_draws,2))));    

 %load Modev10cMinnx0 fval opt_xtrf lambda bdiag dfpsi Psi_nu
 
 n_draws_swl = size(X_select_draws_all,2);
 
dimF = n*nlags + n*p + r;

States = NaN(dimF,T,n_draws_swl);

Ypred = NaN(n_all,T,n_draws_swl);

parfor j=1:n_draws_swl
%for j=1:n_draws_swl
   disp(j) 
x = X_select_draws_all(:,j);    
 
Phi = reshape(x(1 + n_sig_obs+1:1 + n_sig_obs+n*n),n,n);
Sigma_vec_offdiag = x(1 + n_sig_obs+n*n+1:1 + n_sig_obs+n*n+n); 
idx_offdiag = tril(ones(n))-eye(n);
Sigma_nu = zeros(n);
Sigma_nu(logical(idx_offdiag)) = Sigma_vec_offdiag;
idx_diag = eye(n);
   
 Theta = (x(1:1 + n_sig_obs));
 Sigma_vec_diag = (x(1 + n_sig_obs+n*n+n+1:1 + n_sig_obs+n*n+n+n)); 
  %  idx_diag = eye(n);
 Sigma_nu(logical(idx_diag)) = Sigma_vec_diag;
 Sig_nu  = Sigma_nu*Sigma_nu';
 Sig_eta = diag((x(1 + n_sig_obs+n*n+n+n+1:1 + n_sig_obs+n*n+n+n+n)));  


F = zeros(dimF);
F(1:n,n*nlags+1:n*nlags + n*p + r) = [Phi eye(n)]; %z = x + zbar
F([n+1:2*n 2*n+1:3*n 3*n+1:4*n 4*n+1:5*n],[1:n n+1:2*n 2*n+1:3*n 3*n+1:4*n]) = eye((nlags-1)*n); %lagged z
F(n*nlags+1:n*nlags + n*p,n*nlags+1:n*nlags + n*p) = Phi;
F(n*nlags + n*p +1:n*nlags + n*p + r,n*nlags + n*p +1:n*nlags + n*p + r) = eye(r);

% Make Vz
Vz = eye(r);
Vz(3,1) = Theta(1);
Vz(3,2) = 1;

% Make V
V = zeros(dimF,n*p + r);
V(1:n,1:n) = eye(n);
V(1:n,n*p+1:n*p + r) = Vz;
V(end-n+1:end,n*p+1:n*p + r) = Vz;
V(end-2*n+1:end-n,1:n) = eye(n);

% Make Q
Sig = zeros(n*p + r);
Sig(1:n,1:n) = Sig_nu;
Sig(n*p+1:end,n*p+1:end) = Sig_eta;
Q = V*Sig*V';


% Make H and R
H = [];
Rvec = [];

for i = 1:n
      
     [~, Htemp, RvecTemp] = CREATEH(X,n,F,Theta((i-1)*4+2:i*4+1),varlist{varorder(i),2},i,true,false);
     
     
    H = [H; Htemp];
    Rvec = [Rvec; RvecTemp];
end 
R = diag(Rvec);


% Initial conditions for state space

%initial conditions
S0tr = [2 2 4]'; %initial condition trend state (check values)
S0x = zeros(n*p,1); %initial condition for x cycle state (VAR)
S0z = repmat(S0tr,[nlags,1]); % initial condition for z 


S0 = [S0z;S0x;S0tr];

P0 = zeros(dimF);

% Conditions on initial state

P0(end-r,end-r)=eye(size(r))/1;

Qc = Q(1:n*nlags + n*p,1:n*nlags + n*p);
Fc = F(1:n*nlags + n*p,1:n*nlags + n*p);
vecP0c = pinv(eye((n*nlags + n*p)^2) - kron(Fc,Fc))*Qc(:); 
P0(1:n*nlags + n*p,1:n*nlags + n*p) = reshape(vecP0c,n*nlags + n*p,n*nlags + n*p);

 kf = KF(y,H,R,F,Q,S0,P0);
 
 % Smoothed draw
 
     kc = KC(kf);
    
    States(:,:,j) = kc.S';
    Ypred(:,:,j) = H* kc.S';
end %parfor loop
save Preds10c States Ypred -v7.3

end
%save 

% -14286.3 
%
% 0.0015
%     0.0009
%     0.0005
%     0.0003
%     0.0005
%     0.0004
%   -22.4945
%   -21.7508
%   -26.5657
%   -23.9638
%   -21.7047
%   -21.3756
%    -9.7909
%   -13.3754
%   -12.3498
%    -9.6865
%   -12.7457
%   -11.7314
%     0.9335
    